/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestUnknownOperators
extends AbstractTestFunctions {
    @BeforeClass
    public void setUp() {
        this.registerScalar(this.getClass());
    }

    @ScalarFunction(value="null_function", deterministic=false)
    @SqlNullable
    @SqlType(value="unknown")
    public static Boolean nullFunction() {
        return null;
    }

    @Test
    public void testLiteral() {
        this.assertFunction("NULL", (Type)UnknownType.UNKNOWN, null);
    }

    @Test
    public void testEqual() {
        this.assertFunction("NULL = NULL", (Type)BooleanType.BOOLEAN, null);
    }

    @Test
    public void testNotEqual() {
        this.assertFunction("NULL <> NULL", (Type)BooleanType.BOOLEAN, null);
    }

    @Test
    public void testLessThan() {
        this.assertFunction("NULL < NULL", (Type)BooleanType.BOOLEAN, null);
    }

    @Test
    public void testLessThanOrEqual() {
        this.assertFunction("NULL <= NULL", (Type)BooleanType.BOOLEAN, null);
    }

    @Test
    public void testGreaterThan() {
        this.assertFunction("NULL > NULL", (Type)BooleanType.BOOLEAN, null);
    }

    @Test
    public void testGreaterThanOrEqual() {
        this.assertFunction("NULL >= NULL", (Type)BooleanType.BOOLEAN, null);
    }

    @Test
    public void testBetween() {
        this.assertFunction("NULL BETWEEN NULL AND NULL", (Type)BooleanType.BOOLEAN, null);
    }

    @Test
    public void testCastToBigint() {
        this.assertFunction("cast(NULL as bigint)", (Type)BigintType.BIGINT, null);
        this.assertFunction("cast(null_function() as bigint)", (Type)BigintType.BIGINT, null);
    }

    @Test
    public void testCastToVarchar() {
        this.assertFunction("cast(NULL as varchar)", (Type)VarcharType.VARCHAR, null);
        this.assertFunction("cast(null_function() as varchar)", (Type)VarcharType.VARCHAR, null);
    }

    @Test
    public void testCastToDouble() {
        this.assertFunction("cast(NULL as double)", (Type)DoubleType.DOUBLE, null);
        this.assertFunction("cast(null_function() as double)", (Type)DoubleType.DOUBLE, null);
    }

    @Test
    public void testCastToBoolean() {
        this.assertFunction("cast(NULL as boolean)", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("cast(null_function() as boolean)", (Type)BooleanType.BOOLEAN, null);
    }

    @Test
    public void testIsDistinctFrom() {
        this.assertFunction("NULL IS DISTINCT FROM NULL", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testIndeterminate() throws Exception {
        this.assertOperator(OperatorType.INDETERMINATE, "null", (Type)BooleanType.BOOLEAN, true);
    }
}

