/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type.khyperloglog;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.type.khyperloglog.KHyperLogLog;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.io.BaseEncoding;
import io.airlift.slice.Slice;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import org.testng.annotations.Test;

public class TestKHyperLogLogFunctions
extends AbstractTestFunctions {
    private static final int histSize = 256;
    private static final int threshold = 2;
    private static final double potential = 0.6;

    private TestKHyperLogLogFunctions() {
    }

    @Test
    public void testCardinalityNullArray() {
        this.assertFunction("cardinality(merge_khll(null))", (Type)BigintType.BIGINT, null);
    }

    @Test
    public void testMergeSingleColumn() {
        int blockSize = 1;
        long uniqueElements = 10000 * blockSize;
        String projection = this.getMergeProjection(this.buildKHyperLogLogs(blockSize, uniqueElements, 2, 0.6));
        this.functionAssertions.assertFunction("(CAST(" + projection + " AS VARBINARY)) IS NULL", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testCardinalitySingleColumn() {
        int blockSize = 1;
        long uniqueElements = 10000 * blockSize;
        double error = (double)uniqueElements * 0.05;
        String projection = this.getCardinalityProjection(this.buildKHyperLogLogs(blockSize, uniqueElements, 2, 0.6));
        this.functionAssertions.assertFunctionWithError(projection, (Type)BigintType.BIGINT, uniqueElements, error);
    }

    @Test
    public void testReidentificationSingleColumn() {
        int blockSize = 1;
        long uniqueElements = 10000 * blockSize;
        double error = 0.03;
        String projection = this.getReidentificationProjection(this.buildKHyperLogLogs(blockSize, uniqueElements, 2, 0.6), 2);
        this.functionAssertions.assertFunctionWithError(projection, (Type)DoubleType.DOUBLE, 0.6, error);
    }

    @Test
    public void testHistogramSingleColumn() {
        int blockSize = 1;
        long uniqueElements = 10000 * blockSize;
        double error = 0.015;
        String projection = this.getHistogramProjection(this.buildKHyperLogLogs(blockSize, uniqueElements, 2, 0.6), 256);
        this.functionAssertions.assertFunction("cardinality(" + projection + ")", (Type)BigintType.BIGINT, 256L);
        this.functionAssertions.assertFunctionWithError(projection + String.format("[%d]", 2), (Type)DoubleType.DOUBLE, 0.3, error);
    }

    @Test
    public void testIntersectionCardinality() {
        int blockSize = 10;
        long uniqueElements = 10000 * blockSize;
        double error = (double)uniqueElements * 0.05;
        List<KHyperLogLog> list1 = this.buildKHyperLogLogs(blockSize, uniqueElements, 2, 0.6);
        List<KHyperLogLog> list2 = this.buildKHyperLogLogs(15, uniqueElements * 15L / (long)blockSize, 2, 0.6);
        String projection = this.getIntersectionCardinalityProjection(list1, list2);
        this.functionAssertions.assertFunctionWithError(projection, (Type)BigintType.BIGINT, uniqueElements, error);
    }

    @Test
    public void testJaccardIndex() {
        int blockSize = 10;
        long uniqueElements = 10000 * blockSize;
        double error = 0.03333333333333333;
        List<KHyperLogLog> list1 = this.buildKHyperLogLogs(blockSize, uniqueElements, 2, 0.6);
        List<KHyperLogLog> list2 = this.buildKHyperLogLogs((int)((double)blockSize * 1.5), (int)((double)uniqueElements * 1.5), 2, 0.6);
        String projection = this.getJaccardIndexProjection(list1, list2);
        this.functionAssertions.assertFunctionWithError(projection, (Type)DoubleType.DOUBLE, 0.6666666666666666, error);
    }

    @Test
    public void testMergeManyColumns() {
        int blockSize = 100;
        long uniqueElements = 1000 * blockSize;
        String projection = this.getMergeProjection(this.buildKHyperLogLogs(blockSize, uniqueElements, 2, 0.6));
        this.functionAssertions.assertFunction("(CAST(" + projection + " AS VARBINARY)) IS NULL", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testCardinalityManyColumns() {
        int blockSize = 100;
        long uniqueElements = 1000 * blockSize;
        double error = (double)uniqueElements * 0.05;
        String projection = this.getCardinalityProjection(this.buildKHyperLogLogs(blockSize, uniqueElements, 2, 0.6));
        this.functionAssertions.assertFunctionWithError(projection, (Type)BigintType.BIGINT, uniqueElements, error);
    }

    @Test
    public void testReidentificationManyColumns() {
        int blockSize = 100;
        long uniqueElements = 1000 * blockSize;
        double error = 0.03;
        String projection = this.getReidentificationProjection(this.buildKHyperLogLogs(blockSize, uniqueElements, 2, 0.6), 2);
        this.functionAssertions.assertFunctionWithError(projection, (Type)DoubleType.DOUBLE, 0.6, error);
    }

    @Test
    public void testHistogramManyColumns() {
        int blockSize = 100;
        long uniqueElements = 1000 * blockSize;
        double error = 0.015;
        String projection = this.getHistogramProjection(this.buildKHyperLogLogs(blockSize, uniqueElements, 2, 0.6), 256);
        this.functionAssertions.assertFunction("cardinality(" + projection + ")", (Type)BigintType.BIGINT, 256L);
        this.functionAssertions.assertFunctionWithError(projection + String.format("[%d]", 2), (Type)DoubleType.DOUBLE, 0.3, error);
    }

    private List<KHyperLogLog> buildKHyperLogLogs(int blockSize, long uniqueElements, int targetThreshold, double p) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Random generator = new Random(123L);
        for (int j = 0; j < blockSize; ++j) {
            KHyperLogLog khll = new KHyperLogLog();
            for (long i = (long)j * uniqueElements / (long)blockSize; i < (long)(j + 1) * uniqueElements / (long)blockSize; ++i) {
                long baseCount = generator.nextInt(targetThreshold);
                long count = generator.nextDouble() < p ? baseCount : baseCount + (long)targetThreshold;
                for (long uii = 0L; uii <= count; ++uii) {
                    khll.add(i, uii);
                }
            }
            builder.add((Object)khll);
        }
        return builder.build();
    }

    private String getCardinalityProjection(List<KHyperLogLog> list) {
        String projection = this.getMergeProjection(list);
        return String.format("cardinality(%s)", projection);
    }

    private String getIntersectionCardinalityProjection(List<KHyperLogLog> list1, List<KHyperLogLog> list2) {
        String projection1 = this.getMergeProjection(list1);
        String projection2 = this.getMergeProjection(list2);
        return String.format("intersection_cardinality(%s, %s)", projection1, projection2);
    }

    private String getJaccardIndexProjection(List<KHyperLogLog> list1, List<KHyperLogLog> list2) {
        String projection1 = this.getMergeProjection(list1);
        String projection2 = this.getMergeProjection(list2);
        return String.format("jaccard_index(%s, %s)", projection1, projection2);
    }

    private String getReidentificationProjection(List<KHyperLogLog> list, int threshold) {
        String projection = this.getMergeProjection(list);
        return String.format("reidentification_potential(%s, %d)", projection, threshold);
    }

    private String getHistogramProjection(List<KHyperLogLog> list, int histogramSize) {
        String projection = this.getMergeProjection(list);
        return String.format("uniqueness_distribution(%s, %d)", projection, histogramSize);
    }

    private String getMergeProjection(List<KHyperLogLog> list) {
        String projection = "merge_khll(ARRAY[";
        ListIterator<KHyperLogLog> iterator = list.listIterator();
        ImmutableList.Builder casts = ImmutableList.builder();
        for (KHyperLogLog current : list) {
            Slice firstSerial = current.serialize();
            byte[] firstBytes = firstSerial.getBytes();
            String firstEncode = BaseEncoding.base16().lowerCase().encode(firstBytes);
            casts.add((Object)("CAST(X'" + firstEncode + "' AS KHyperLogLog)"));
        }
        projection = projection + Joiner.on((String)", ").join((Iterable)casts.build());
        projection = projection + "])";
        return projection;
    }
}

