/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.Objects;

public class InfiniteRecordSet
implements RecordSet {
    private final List<Type> types;
    private final List<?> record;

    public InfiniteRecordSet(List<Type> types, List<?> record) {
        this.types = types;
        this.record = record;
    }

    public List<Type> getColumnTypes() {
        return this.types;
    }

    public RecordCursor cursor() {
        return new InMemoryRecordCursor(this.types, this.record);
    }

    private static class InMemoryRecordCursor
    implements RecordCursor {
        private final List<Type> types;
        private final List<?> record;

        private InMemoryRecordCursor(List<Type> types, List<?> record) {
            this.types = (List)Objects.requireNonNull(ImmutableList.copyOf(types), "types is null");
            this.record = (List)Objects.requireNonNull(ImmutableList.copyOf(record), "record is null");
        }

        public long getCompletedBytes() {
            return 0L;
        }

        public long getReadTimeNanos() {
            return 0L;
        }

        public boolean advanceNextPosition() {
            return true;
        }

        public Type getType(int field) {
            return this.types.get(field);
        }

        public boolean getBoolean(int field) {
            Objects.requireNonNull(this.record.get(field), "value is null");
            return (Boolean)this.record.get(field);
        }

        public long getLong(int field) {
            Objects.requireNonNull(this.record.get(field), "value is null");
            return (Long)this.record.get(field);
        }

        public double getDouble(int field) {
            Objects.requireNonNull(this.record.get(field), "value is null");
            return (Double)this.record.get(field);
        }

        public Slice getSlice(int field) {
            Object value = this.record.get(field);
            Objects.requireNonNull(value, "value is null");
            if (value instanceof byte[]) {
                return Slices.wrappedBuffer((byte[])((byte[])value));
            }
            if (value instanceof String) {
                return Slices.utf8Slice((String)((String)value));
            }
            throw new IllegalArgumentException("Field " + field + " is not a String, but is a " + value.getClass().getName());
        }

        public Object getObject(int field) {
            Object value = this.record.get(field);
            Objects.requireNonNull(value, "value is null");
            return value;
        }

        public boolean isNull(int field) {
            return this.record.get(field) == null;
        }

        public void close() {
        }
    }
}

