/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpcds;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.tpcds.TpcdsSplit;
import com.facebook.presto.tpcds.TpcdsTableHandle;
import com.facebook.presto.tpcds.TpcdsTableLayoutHandle;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class TpcdsSplitManager
implements ConnectorSplitManager {
    private final NodeManager nodeManager;
    private final int splitsPerNode;
    private final boolean noSexism;

    public TpcdsSplitManager(NodeManager nodeManager, int splitsPerNode, boolean noSexism) {
        Objects.requireNonNull(nodeManager);
        Preconditions.checkArgument((splitsPerNode > 0 ? 1 : 0) != 0, (Object)"splitsPerNode must be at least 1");
        this.nodeManager = nodeManager;
        this.splitsPerNode = splitsPerNode;
        this.noSexism = noSexism;
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableLayoutHandle layout, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy) {
        TpcdsTableHandle tableHandle = ((TpcdsTableLayoutHandle)layout).getTable();
        Set nodes = this.nodeManager.getRequiredWorkerNodes();
        Preconditions.checkState((!nodes.isEmpty() ? 1 : 0) != 0, (Object)"No TPCDS nodes available");
        int totalParts = nodes.size() * this.splitsPerNode;
        int partNumber = 0;
        ImmutableList.Builder splits = ImmutableList.builder();
        for (Node node : nodes) {
            for (int i = 0; i < this.splitsPerNode; ++i) {
                splits.add((Object)new TpcdsSplit(tableHandle, partNumber, totalParts, (List<HostAddress>)ImmutableList.of((Object)node.getHostAndPort()), this.noSexism));
                ++partNumber;
            }
        }
        return new FixedSplitSource((Iterable)splits.build());
    }
}

