/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpcds.statistics;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.statistics.ColumnStatistics;
import com.facebook.presto.spi.statistics.Estimate;
import com.facebook.presto.spi.statistics.TableStatistics;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.CharType;
import com.facebook.presto.spi.type.Chars;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.tpcds.TpcdsColumnHandle;
import com.facebook.presto.tpcds.statistics.ColumnStatisticsData;
import com.facebook.presto.tpcds.statistics.TableStatisticsData;
import com.facebook.presto.tpcds.statistics.TableStatisticsDataRepository;
import com.teradata.tpcds.Table;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.time.LocalDate;
import java.util.Map;
import java.util.Optional;

public class TpcdsTableStatisticsFactory {
    private final TableStatisticsDataRepository statisticsDataRepository = new TableStatisticsDataRepository();

    public TableStatistics create(String schemaName, Table table, Map<String, ColumnHandle> columnHandles) {
        Optional<TableStatisticsData> statisticsDataOptional = this.statisticsDataRepository.load(schemaName, table);
        return statisticsDataOptional.map(statisticsData -> this.toTableStatistics(columnHandles, (TableStatisticsData)statisticsData)).orElse(TableStatistics.EMPTY_STATISTICS);
    }

    private TableStatistics toTableStatistics(Map<String, ColumnHandle> columnHandles, TableStatisticsData statisticsData) {
        long rowCount = statisticsData.getRowCount();
        TableStatistics.Builder tableStatistics = TableStatistics.builder().setRowCount(new Estimate((double)rowCount));
        if (rowCount > 0L) {
            Map<String, ColumnStatisticsData> columnsData = statisticsData.getColumns();
            for (Map.Entry<String, ColumnHandle> entry : columnHandles.entrySet()) {
                TpcdsColumnHandle columnHandle = (TpcdsColumnHandle)entry.getValue();
                tableStatistics.setColumnStatistics(entry.getValue(), this.toColumnStatistics(columnsData.get(entry.getKey()), columnHandle.getType(), rowCount));
            }
        }
        return tableStatistics.build();
    }

    private ColumnStatistics toColumnStatistics(ColumnStatisticsData columnStatisticsData, Type type, long rowCount) {
        ColumnStatistics.Builder columnStatistics = ColumnStatistics.builder();
        long nullCount = columnStatisticsData.getNullsCount();
        columnStatistics.setNullsFraction(new Estimate((double)nullCount / (double)rowCount));
        columnStatistics.addRange(builder -> builder.setLowValue(columnStatisticsData.getMin().map(value -> this.toPrestoValue(value, type))).setHighValue(columnStatisticsData.getMax().map(value -> this.toPrestoValue(value, type))).setDistinctValuesCount(new Estimate((double)columnStatisticsData.getDistinctValuesCount())).setFraction(new Estimate(((double)rowCount - (double)nullCount) / (double)rowCount)).build());
        return columnStatistics.build();
    }

    private Object toPrestoValue(Object tpcdsValue, Type type) {
        if (type instanceof VarcharType) {
            return Slices.utf8Slice((String)((String)tpcdsValue));
        }
        if (type instanceof CharType) {
            return Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)((String)tpcdsValue)), (Type)type);
        }
        if (tpcdsValue instanceof String && type.equals(DateType.DATE)) {
            return LocalDate.parse((CharSequence)tpcdsValue).toEpochDay();
        }
        if (type.equals(BigintType.BIGINT) || type.equals(IntegerType.INTEGER) || type.equals(DateType.DATE) || type instanceof DecimalType && Decimals.isShortDecimal((Type)type)) {
            return ((Number)tpcdsValue).longValue();
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return ((Number)tpcdsValue).doubleValue();
        }
        if (type.equals(TimeType.TIME)) {
            return ((Number)tpcdsValue).longValue();
        }
        throw new IllegalArgumentException("unsupported column type " + type);
    }
}

