/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpcds;

import com.facebook.presto.spi.connector.ConnectorPartitioningHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class TpcdsPartitioningHandle
implements ConnectorPartitioningHandle {
    private final String table;
    private final long totalRows;

    @JsonCreator
    public TpcdsPartitioningHandle(@JsonProperty(value="table") String table, @JsonProperty(value="totalRows") long totalRows) {
        this.table = Objects.requireNonNull(table, "table is null");
        Preconditions.checkArgument((totalRows > 0L ? 1 : 0) != 0, (Object)"totalRows must be at least 1");
        this.totalRows = totalRows;
    }

    @JsonProperty
    public String getTable() {
        return this.table;
    }

    @JsonProperty
    public long getTotalRows() {
        return this.totalRows;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TpcdsPartitioningHandle that = (TpcdsPartitioningHandle)o;
        return Objects.equals(this.table, that.table) && Objects.equals(this.totalRows, that.totalRows);
    }

    public int hashCode() {
        return Objects.hash(this.table, this.totalRows);
    }

    public String toString() {
        return this.table + ":" + this.totalRows;
    }
}

