/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpcds;

import com.facebook.presto.common.type.Chars;
import com.facebook.presto.common.type.DecimalParseResult;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.tpcds.TpcdsMetadata;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.teradata.tpcds.Results;
import com.teradata.tpcds.column.Column;
import com.teradata.tpcds.column.ColumnType;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.ChronoField;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class TpcdsRecordSet
implements RecordSet {
    private final Results results;
    private final List<Column> columns;
    private final List<Type> columnTypes;

    public TpcdsRecordSet(Results results, List<Column> columns) {
        Objects.requireNonNull(results, "results is null");
        this.results = results;
        this.columns = ImmutableList.copyOf(columns);
        ImmutableList.Builder columnTypes = ImmutableList.builder();
        for (Column column : columns) {
            columnTypes.add((Object)TpcdsMetadata.getPrestoType(column.getType()));
        }
        this.columnTypes = columnTypes.build();
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return new TpcdsRecordCursor(this.results.iterator(), this.columns);
    }

    public class TpcdsRecordCursor
    implements RecordCursor {
        private final Iterator<List<List<String>>> rows;
        private final List<Column> columns;
        private List<String> row;
        private boolean closed;

        public TpcdsRecordCursor(Iterator<List<List<String>>> rows, List<Column> columns) {
            this.rows = Objects.requireNonNull(rows);
            this.columns = Objects.requireNonNull(columns);
        }

        public long getCompletedBytes() {
            return 0L;
        }

        public long getReadTimeNanos() {
            return 0L;
        }

        public Type getType(int field) {
            return TpcdsMetadata.getPrestoType(this.columns.get(field).getType());
        }

        public boolean advanceNextPosition() {
            if (this.closed || !this.rows.hasNext()) {
                this.closed = true;
                this.row = null;
                return false;
            }
            this.row = this.rows.next().get(0);
            return true;
        }

        public boolean getBoolean(int field) {
            throw new UnsupportedOperationException();
        }

        public long getLong(int field) {
            Preconditions.checkState((this.row != null ? 1 : 0) != 0, (Object)"No current row");
            Column column = this.columns.get(field);
            if (column.getType().getBase() == ColumnType.Base.DATE) {
                return LocalDate.parse(this.row.get(column.getPosition())).toEpochDay();
            }
            if (column.getType().getBase() == ColumnType.Base.TIME) {
                return LocalTime.parse(this.row.get(column.getPosition())).get(ChronoField.MILLI_OF_DAY);
            }
            if (column.getType().getBase() == ColumnType.Base.INTEGER) {
                return Integer.parseInt(this.row.get(column.getPosition()));
            }
            if (column.getType().getBase() == ColumnType.Base.DECIMAL) {
                DecimalParseResult decimalParseResult = Decimals.parse((String)this.row.get(column.getPosition()));
                return Decimals.rescale((long)((Long)decimalParseResult.getObject()), (int)decimalParseResult.getType().getScale(), (int)((DecimalType)TpcdsRecordSet.this.columnTypes.get(field)).getScale());
            }
            return Long.parseLong(this.row.get(column.getPosition()));
        }

        public double getDouble(int field) {
            Preconditions.checkState((this.row != null ? 1 : 0) != 0, (Object)"No current row");
            return Double.parseDouble(this.row.get(this.columns.get(field).getPosition()));
        }

        public Slice getSlice(int field) {
            Preconditions.checkState((this.row != null ? 1 : 0) != 0, (Object)"No current row");
            Column column = this.columns.get(field);
            if (column.getType().getBase() == ColumnType.Base.DECIMAL) {
                return (Slice)Decimals.parse((String)this.row.get(column.getPosition())).getObject();
            }
            Slice characters = Slices.utf8Slice((String)this.row.get(this.columns.get(field).getPosition()));
            if (column.getType().getBase() == ColumnType.Base.CHAR) {
                characters = Chars.trimTrailingSpaces((Slice)characters);
            }
            return characters;
        }

        public Object getObject(int field) {
            throw new UnsupportedOperationException();
        }

        public boolean isNull(int field) {
            Preconditions.checkState((this.row != null ? 1 : 0) != 0, (Object)"No current row");
            return this.row.get(this.columns.get(field).getPosition()) == null;
        }

        public void close() {
            this.row = null;
            this.closed = true;
        }
    }
}

