/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpch;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.facebook.presto.tpch.TpchTableHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class TpchSplit
implements ConnectorSplit {
    private final TpchTableHandle tableHandle;
    private final int totalParts;
    private final int partNumber;
    private final List<HostAddress> addresses;
    private final TupleDomain<ColumnHandle> predicate;

    @JsonCreator
    public TpchSplit(@JsonProperty(value="tableHandle") TpchTableHandle tableHandle, @JsonProperty(value="partNumber") int partNumber, @JsonProperty(value="totalParts") int totalParts, @JsonProperty(value="addresses") List<HostAddress> addresses, @JsonProperty(value="predicate") TupleDomain<ColumnHandle> predicate) {
        Preconditions.checkState((partNumber >= 0 ? 1 : 0) != 0, (Object)"partNumber must be >= 0");
        Preconditions.checkState((totalParts >= 1 ? 1 : 0) != 0, (Object)"totalParts must be >= 1");
        Preconditions.checkState((totalParts > partNumber ? 1 : 0) != 0, (Object)"totalParts must be > partNumber");
        this.tableHandle = Objects.requireNonNull(tableHandle, "tableHandle is null");
        this.partNumber = partNumber;
        this.totalParts = totalParts;
        this.addresses = ImmutableList.copyOf((Collection)Objects.requireNonNull(addresses, "addresses is null"));
        this.predicate = Objects.requireNonNull(predicate, "predicate is null");
    }

    @JsonProperty
    public TpchTableHandle getTableHandle() {
        return this.tableHandle;
    }

    @JsonProperty
    public int getTotalParts() {
        return this.totalParts;
    }

    @JsonProperty
    public int getPartNumber() {
        return this.partNumber;
    }

    public Object getInfo() {
        return this;
    }

    public NodeSelectionStrategy getNodeSelectionStrategy() {
        return NodeSelectionStrategy.HARD_AFFINITY;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    public List<HostAddress> getPreferredNodes(List<HostAddress> sortedCandidates) {
        return this.addresses;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getPredicate() {
        return this.predicate;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TpchSplit other = (TpchSplit)obj;
        return Objects.equals(this.tableHandle, other.tableHandle) && Objects.equals(this.totalParts, other.totalParts) && Objects.equals(this.partNumber, other.partNumber) && Objects.equals(this.predicate, other.predicate);
    }

    public int hashCode() {
        return Objects.hash(this.tableHandle, this.totalParts, this.partNumber);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableHandle", (Object)this.tableHandle).add("partNumber", this.partNumber).add("totalParts", this.totalParts).add("predicate", this.predicate).toString();
    }
}

