/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.config.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.statement.SqlStatements;
import org.jdbi.v3.core.statement.TemplateEngine;
import org.jdbi.v3.sqlobject.config.Configurer;
import org.jdbi.v3.sqlobject.config.UseTemplateEngine;

public class UseTemplateEngineImpl
implements Configurer {
    @Override
    public void configureForMethod(ConfigRegistry registry, Annotation annotation, Class<?> sqlObjectType, @Nullable Method method) {
        UseTemplateEngine anno = (UseTemplateEngine)annotation;
        TemplateEngine templateEngine = UseTemplateEngineImpl.instantiate(anno.value(), sqlObjectType, method);
        ((SqlStatements)registry.get(SqlStatements.class)).setTemplateEngine(templateEngine);
    }

    @Override
    public void configureForType(ConfigRegistry registry, Annotation annotation, Class<?> sqlObjectType) {
        this.configureForMethod(registry, annotation, sqlObjectType, null);
    }

    private static TemplateEngine instantiate(Class<? extends TemplateEngine> engineClass, Class<?> sqlObjectType, @Nullable Method method) {
        return Stream.of(UseTemplateEngineImpl.tryConstructor(engineClass, new Object[0]), UseTemplateEngineImpl.tryConstructor(engineClass, sqlObjectType), UseTemplateEngineImpl.tryConstructor(engineClass, sqlObjectType, method)).map(Supplier::get).filter(Objects::nonNull).findFirst().orElseThrow(() -> new IllegalStateException("Unable to instantiate, no viable constructor for " + engineClass.getName()));
    }

    private static <T extends TemplateEngine> Supplier<T> tryConstructor(Class<T> c, Object ... args) {
        Object[] nonNullArgs = Arrays.stream(args).filter(Objects::nonNull).toArray(Object[]::new);
        return () -> {
            try {
                Class[] classes = (Class[])Arrays.stream(nonNullArgs).map(Object::getClass).toArray(Class[]::new);
                return (TemplateEngine)c.getConstructor(classes).newInstance(nonNullArgs);
            }
            catch (NoSuchMethodException ignored) {
                return null;
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        };
    }
}

