/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.orc.metadata.CompressionKind;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.io.compress.SnappyCodec;
import parquet.hadoop.metadata.CompressionCodecName;

public enum HiveCompressionCodec {
    NONE(null, CompressionKind.NONE, CompressionCodecName.UNCOMPRESSED, f -> true),
    SNAPPY(SnappyCodec.class, CompressionKind.SNAPPY, CompressionCodecName.SNAPPY, f -> true),
    GZIP(GzipCodec.class, CompressionKind.ZLIB, CompressionCodecName.GZIP, f -> true),
    LZ4(null, CompressionKind.NONE, null, f -> f == HiveStorageFormat.PAGEFILE),
    ZSTD(null, CompressionKind.ZSTD, null, f -> f == HiveStorageFormat.ORC || f == HiveStorageFormat.DWRF);

    private final Optional<Class<? extends CompressionCodec>> codec;
    private final CompressionKind orcCompressionKind;
    private final Optional<CompressionCodecName> parquetCompressionCodec;
    private final Predicate<HiveStorageFormat> supportedStorageFormats;

    private HiveCompressionCodec(Class<? extends CompressionCodec> codec, CompressionKind orcCompressionKind, CompressionCodecName parquetCompressionCodec, Predicate<HiveStorageFormat> supportedStorageFormats) {
        this.codec = Optional.ofNullable(codec);
        this.orcCompressionKind = Objects.requireNonNull(orcCompressionKind, "orcCompressionKind is null");
        this.parquetCompressionCodec = Optional.ofNullable(parquetCompressionCodec);
        this.supportedStorageFormats = Objects.requireNonNull(supportedStorageFormats, "supportedStorageFormats is null");
    }

    public Optional<Class<? extends CompressionCodec>> getCodec() {
        return this.codec;
    }

    public CompressionKind getOrcCompressionKind() {
        return this.orcCompressionKind;
    }

    public Optional<CompressionCodecName> getParquetCompressionCodec() {
        return this.parquetCompressionCodec;
    }

    public boolean isSupportedStorageFormat(HiveStorageFormat hiveStorageFormat) {
        return this.supportedStorageFormats.test(hiveStorageFormat);
    }
}

