/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveWriteUtils;
import com.facebook.presto.hive.LocationHandle;
import com.facebook.presto.hive.LocationService;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.SemiTransactionalHiveMetastore;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.hadoop.fs.Path;

public class HiveLocationService
implements LocationService {
    private final HdfsEnvironment hdfsEnvironment;

    @Inject
    public HiveLocationService(HdfsEnvironment hdfsEnvironment) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
    }

    @Override
    public LocationHandle forNewTable(SemiTransactionalHiveMetastore metastore, ConnectorSession session, String schemaName, String tableName, boolean tempPathRequired) {
        HdfsContext context = new HdfsContext(session, schemaName, tableName);
        Path targetPath = HiveWriteUtils.getTableDefaultLocation(context, metastore, this.hdfsEnvironment, schemaName, tableName);
        if (MetastoreUtil.pathExists((HdfsContext)context, (HdfsEnvironment)this.hdfsEnvironment, (Path)targetPath)) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PATH_ALREADY_EXISTS, String.format("Target directory for table '%s.%s' already exists: %s", schemaName, tableName, targetPath));
        }
        return this.createLocationHandle(context, session, targetPath, LocationHandle.TableType.NEW, tempPathRequired);
    }

    @Override
    public LocationHandle forExistingTable(SemiTransactionalHiveMetastore metastore, ConnectorSession session, Table table, boolean tempPathRequired) {
        HdfsContext context = new HdfsContext(session, table.getDatabaseName(), table.getTableName());
        Path targetPath = new Path(table.getStorage().getLocation());
        return this.createLocationHandle(context, session, targetPath, LocationHandle.TableType.EXISTING, tempPathRequired);
    }

    @Override
    public LocationHandle forTemporaryTable(SemiTransactionalHiveMetastore metastore, ConnectorSession session, Table table, boolean tempPathRequired) {
        String schemaName = table.getDatabaseName();
        String tableName = table.getTableName();
        HdfsContext context = new HdfsContext(session, schemaName, tableName);
        Path targetPath = new Path(HiveWriteUtils.getTableDefaultLocation(context, metastore, this.hdfsEnvironment, schemaName, tableName), UUID.randomUUID().toString().replaceAll("-", "_"));
        return new LocationHandle(targetPath, targetPath, tempPathRequired ? Optional.of(HiveWriteUtils.createTemporaryPath(session, context, this.hdfsEnvironment, targetPath)) : Optional.empty(), LocationHandle.TableType.TEMPORARY, LocationHandle.WriteMode.DIRECT_TO_TARGET_NEW_DIRECTORY);
    }

    private LocationHandle createLocationHandle(HdfsContext context, ConnectorSession session, Path targetPath, LocationHandle.TableType tableType, boolean tempPathRequired) {
        Optional tempPath;
        Optional<Object> optional = tempPath = tempPathRequired ? Optional.of(HiveWriteUtils.createTemporaryPath(session, context, this.hdfsEnvironment, targetPath)) : Optional.empty();
        if (this.shouldUseTemporaryDirectory(session, context, targetPath)) {
            Path writePath = HiveWriteUtils.createTemporaryPath(session, context, this.hdfsEnvironment, targetPath);
            MetastoreUtil.createDirectory((HdfsContext)context, (HdfsEnvironment)this.hdfsEnvironment, (Path)writePath);
            return new LocationHandle(targetPath, writePath, tempPath, tableType, LocationHandle.WriteMode.STAGE_AND_MOVE_TO_TARGET_DIRECTORY);
        }
        if (tableType.equals((Object)LocationHandle.TableType.EXISTING)) {
            return new LocationHandle(targetPath, targetPath, tempPath, tableType, LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY);
        }
        return new LocationHandle(targetPath, targetPath, tempPath, tableType, LocationHandle.WriteMode.DIRECT_TO_TARGET_NEW_DIRECTORY);
    }

    private boolean shouldUseTemporaryDirectory(ConnectorSession session, HdfsContext context, Path path) {
        return HiveSessionProperties.isTemporaryStagingDirectoryEnabled(session) && !HiveWriteUtils.isS3FileSystem(context, this.hdfsEnvironment, path);
    }

    @Override
    public LocationService.WriteInfo getQueryWriteInfo(LocationHandle locationHandle) {
        return new LocationService.WriteInfo(locationHandle.getTargetPath(), locationHandle.getWritePath(), locationHandle.getTempPath(), locationHandle.getWriteMode());
    }

    @Override
    public LocationService.WriteInfo getTableWriteInfo(LocationHandle locationHandle) {
        return new LocationService.WriteInfo(locationHandle.getTargetPath(), locationHandle.getWritePath(), locationHandle.getTempPath(), locationHandle.getWriteMode());
    }

    @Override
    public LocationService.WriteInfo getPartitionWriteInfo(LocationHandle locationHandle, Optional<Partition> partition, String partitionName) {
        Optional<Path> tempPath = locationHandle.getTempPath().map(path -> new Path(path, UUID.randomUUID().toString().replaceAll("-", "_")));
        if (partition.isPresent()) {
            Path writePath;
            LocationHandle.WriteMode writeMode = locationHandle.getWriteMode();
            Path targetPath = new Path(partition.get().getStorage().getLocation());
            switch (writeMode) {
                case STAGE_AND_MOVE_TO_TARGET_DIRECTORY: {
                    writePath = new Path(locationHandle.getWritePath(), partitionName);
                    break;
                }
                case DIRECT_TO_TARGET_EXISTING_DIRECTORY: {
                    writePath = targetPath;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("inserting into existing partition is not supported for %s", writeMode));
                }
            }
            return new LocationService.WriteInfo(targetPath, writePath, tempPath, writeMode);
        }
        return new LocationService.WriteInfo(new Path(locationHandle.getTargetPath(), partitionName), new Path(locationHandle.getWritePath(), partitionName), tempPath, locationHandle.getWriteMode());
    }
}

