/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.event.client.EventClient;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveFileWriterFactory;
import com.facebook.presto.hive.HiveInsertTableHandle;
import com.facebook.presto.hive.HiveOutputTableHandle;
import com.facebook.presto.hive.HivePageSink;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveWritableTableHandle;
import com.facebook.presto.hive.HiveWriterFactory;
import com.facebook.presto.hive.HiveWriterStats;
import com.facebook.presto.hive.LocationService;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.OrcFileWriterFactory;
import com.facebook.presto.hive.PartitionUpdate;
import com.facebook.presto.hive.metastore.CachingHiveMetastore;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.HivePageSinkMetadataProvider;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.PageIndexerFactory;
import com.facebook.presto.spi.PageSinkProperties;
import com.facebook.presto.spi.PageSorter;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.units.DataSize;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;

public class HivePageSinkProvider
implements ConnectorPageSinkProvider {
    private final Set<HiveFileWriterFactory> fileWriterFactories;
    private final HdfsEnvironment hdfsEnvironment;
    private final PageSorter pageSorter;
    private final ExtendedHiveMetastore metastore;
    private final PageIndexerFactory pageIndexerFactory;
    private final TypeManager typeManager;
    private final int maxOpenPartitions;
    private final int maxOpenSortFiles;
    private final DataSize writerSortBufferSize;
    private final boolean immutablePartitions;
    private final LocationService locationService;
    private final ListeningExecutorService writeVerificationExecutor;
    private final JsonCodec<PartitionUpdate> partitionUpdateCodec;
    private final NodeManager nodeManager;
    private final EventClient eventClient;
    private final HiveSessionProperties hiveSessionProperties;
    private final HiveWriterStats hiveWriterStats;
    private final OrcFileWriterFactory orcFileWriterFactory;
    private final long perTransactionMetastoreCacheMaximumSize;

    @Inject
    public HivePageSinkProvider(Set<HiveFileWriterFactory> fileWriterFactories, HdfsEnvironment hdfsEnvironment, PageSorter pageSorter, ExtendedHiveMetastore metastore, PageIndexerFactory pageIndexerFactory, TypeManager typeManager, HiveClientConfig hiveClientConfig, MetastoreClientConfig metastoreClientConfig, LocationService locationService, JsonCodec<PartitionUpdate> partitionUpdateCodec, NodeManager nodeManager, EventClient eventClient, HiveSessionProperties hiveSessionProperties, HiveWriterStats hiveWriterStats, OrcFileWriterFactory orcFileWriterFactory) {
        this.fileWriterFactories = ImmutableSet.copyOf((Collection)Objects.requireNonNull(fileWriterFactories, "fileWriterFactories is null"));
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.pageSorter = Objects.requireNonNull(pageSorter, "pageSorter is null");
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.pageIndexerFactory = Objects.requireNonNull(pageIndexerFactory, "pageIndexerFactory is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.maxOpenPartitions = hiveClientConfig.getMaxPartitionsPerWriter();
        this.maxOpenSortFiles = hiveClientConfig.getMaxOpenSortFiles();
        this.writerSortBufferSize = Objects.requireNonNull(hiveClientConfig.getWriterSortBufferSize(), "writerSortBufferSize is null");
        this.immutablePartitions = hiveClientConfig.isImmutablePartitions();
        this.locationService = Objects.requireNonNull(locationService, "locationService is null");
        this.writeVerificationExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(hiveClientConfig.getWriteValidationThreads(), Threads.daemonThreadsNamed((String)"hive-write-validation-%s")));
        this.partitionUpdateCodec = Objects.requireNonNull(partitionUpdateCodec, "partitionUpdateCodec is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.eventClient = Objects.requireNonNull(eventClient, "eventClient is null");
        this.hiveSessionProperties = Objects.requireNonNull(hiveSessionProperties, "hiveSessionProperties is null");
        this.hiveWriterStats = Objects.requireNonNull(hiveWriterStats, "stats is null");
        this.orcFileWriterFactory = Objects.requireNonNull(orcFileWriterFactory, "orcFileWriterFactory is null");
        this.perTransactionMetastoreCacheMaximumSize = metastoreClientConfig.getPerTransactionMetastoreCacheMaximumSize();
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorOutputTableHandle tableHandle, PageSinkProperties pageSinkProperties) {
        HiveOutputTableHandle handle = (HiveOutputTableHandle)tableHandle;
        return this.createPageSink(handle, true, session, pageSinkProperties.isCommitRequired());
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorInsertTableHandle tableHandle, PageSinkProperties pageSinkProperties) {
        HiveInsertTableHandle handle = (HiveInsertTableHandle)tableHandle;
        return this.createPageSink(handle, false, session, pageSinkProperties.isCommitRequired());
    }

    private ConnectorPageSink createPageSink(HiveWritableTableHandle handle, boolean isCreateTable, ConnectorSession session, boolean commitRequired) {
        List sortedBy;
        OptionalInt bucketCount = OptionalInt.empty();
        if (handle.getBucketProperty().isPresent()) {
            bucketCount = OptionalInt.of(handle.getBucketProperty().get().getBucketCount());
            sortedBy = handle.getBucketProperty().get().getSortedBy();
        } else {
            sortedBy = handle.getPreferredOrderingColumns();
        }
        HiveWriterFactory writerFactory = new HiveWriterFactory(this.fileWriterFactories, handle.getSchemaName(), handle.getTableName(), isCreateTable, handle.getInputColumns(), handle.getTableStorageFormat(), handle.getPartitionStorageFormat(), handle.getCompressionCodec(), bucketCount, sortedBy, handle.getLocationHandle(), this.locationService, handle.getFilePrefix(), new HivePageSinkMetadataProvider(handle.getPageSinkMetadata(), (ExtendedHiveMetastore)CachingHiveMetastore.memoizeMetastore((ExtendedHiveMetastore)this.metastore, (long)this.perTransactionMetastoreCacheMaximumSize)), this.typeManager, this.hdfsEnvironment, this.pageSorter, this.writerSortBufferSize, this.maxOpenSortFiles, this.immutablePartitions, session, this.nodeManager, this.eventClient, this.hiveSessionProperties, this.hiveWriterStats, this.orcFileWriterFactory, commitRequired);
        return new HivePageSink(writerFactory, handle.getInputColumns(), handle.getBucketProperty(), this.pageIndexerFactory, this.typeManager, this.hdfsEnvironment, this.maxOpenPartitions, this.writeVerificationExecutor, this.partitionUpdateCodec, session);
    }
}

