/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveRecordCursorProvider;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.IonSqlQueryBuilder;
import com.facebook.presto.hive.S3SelectCsvRecordReader;
import com.facebook.presto.hive.S3SelectRecordCursor;
import com.facebook.presto.hive.s3.PrestoS3ClientFactory;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordCursor;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.joda.time.DateTimeZone;

public class S3SelectRecordCursorProvider
implements HiveRecordCursorProvider {
    private static final Set<String> CSV_SERDES = ImmutableSet.of((Object)LazySimpleSerDe.class.getName());
    private final HdfsEnvironment hdfsEnvironment;
    private final HiveClientConfig clientConfig;
    private final PrestoS3ClientFactory s3ClientFactory;

    @Inject
    public S3SelectRecordCursorProvider(HdfsEnvironment hdfsEnvironment, HiveClientConfig clientConfig, PrestoS3ClientFactory s3ClientFactory) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.clientConfig = Objects.requireNonNull(clientConfig, "clientConfig is null");
        this.s3ClientFactory = Objects.requireNonNull(s3ClientFactory, "s3ClientFactory is null");
    }

    @Override
    public Optional<RecordCursor> createRecordCursor(Configuration configuration, ConnectorSession session, Path path, long start, long length, long fileSize, Properties schema, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, DateTimeZone hiveStorageTimeZone, TypeManager typeManager, boolean s3SelectPushdownEnabled) {
        if (!s3SelectPushdownEnabled) {
            return Optional.empty();
        }
        try {
            this.hdfsEnvironment.getFileSystem(session.getUser(), path, configuration);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed getting FileSystem: " + path, (Throwable)e);
        }
        String serdeName = HiveUtil.getDeserializerClassName(schema);
        if (CSV_SERDES.contains(serdeName)) {
            IonSqlQueryBuilder queryBuilder = new IonSqlQueryBuilder(typeManager);
            String ionSqlQuery = queryBuilder.buildSql(columns, effectivePredicate);
            S3SelectCsvRecordReader recordReader = new S3SelectCsvRecordReader(configuration, this.clientConfig, path, start, length, schema, ionSqlQuery, this.s3ClientFactory);
            return Optional.of(new S3SelectRecordCursor(configuration, path, recordReader, length, schema, columns, hiveStorageTimeZone, typeManager));
        }
        return Optional.empty();
    }
}

