/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.orc;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.FileFormatDataSourceStats;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveBatchPageSourceFactory;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveFileContext;
import com.facebook.presto.hive.HiveOrcAggregatedMemoryContext;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.orc.HdfsOrcDataSource;
import com.facebook.presto.hive.orc.OrcBatchPageSource;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcBatchRecordReader;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcReader;
import com.facebook.presto.orc.OrcReaderOptions;
import com.facebook.presto.orc.StripeMetadataSource;
import com.facebook.presto.orc.TupleDomainOrcPredicate;
import com.facebook.presto.orc.cache.OrcFileTailSource;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.FixedPageSource;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.joda.time.DateTimeZone;

public class OrcBatchPageSourceFactory
implements HiveBatchPageSourceFactory {
    private final TypeManager typeManager;
    private final boolean useOrcColumnNames;
    private final HdfsEnvironment hdfsEnvironment;
    private final FileFormatDataSourceStats stats;
    private final int domainCompactionThreshold;
    private final OrcFileTailSource orcFileTailSource;
    private final StripeMetadataSource stripeMetadataSource;

    @Inject
    public OrcBatchPageSourceFactory(TypeManager typeManager, HiveClientConfig config, HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats stats, OrcFileTailSource orcFileTailSource, StripeMetadataSource stripeMetadataSource) {
        this(typeManager, Objects.requireNonNull(config, "hiveClientConfig is null").isUseOrcColumnNames(), hdfsEnvironment, stats, config.getDomainCompactionThreshold(), orcFileTailSource, stripeMetadataSource);
    }

    public OrcBatchPageSourceFactory(TypeManager typeManager, boolean useOrcColumnNames, HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats stats, int domainCompactionThreshold, OrcFileTailSource orcFileTailSource, StripeMetadataSource stripeMetadataSource) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.useOrcColumnNames = useOrcColumnNames;
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.domainCompactionThreshold = domainCompactionThreshold;
        this.orcFileTailSource = Objects.requireNonNull(orcFileTailSource, "orcFileTailSource is null");
        this.stripeMetadataSource = Objects.requireNonNull(stripeMetadataSource, "stripeMetadataSource is null");
    }

    @Override
    public Optional<? extends ConnectorPageSource> createPageSource(Configuration configuration, ConnectorSession session, Path path, long start, long length, long fileSize, Storage storage, SchemaTableName tableName, Map<String, String> tableParameters, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, DateTimeZone hiveStorageTimeZone, HiveFileContext hiveFileContext) {
        if (!OrcSerde.class.getName().equals(storage.getStorageFormat().getSerDe())) {
            return Optional.empty();
        }
        if (fileSize == 0L) {
            return Optional.of(new FixedPageSource((Iterable)ImmutableList.of()));
        }
        return Optional.of(OrcBatchPageSourceFactory.createOrcPageSource(OrcEncoding.ORC, this.hdfsEnvironment, session.getUser(), configuration, path, start, length, fileSize, columns, this.useOrcColumnNames, effectivePredicate, hiveStorageTimeZone, this.typeManager, HiveSessionProperties.getOrcMaxBufferSize(session), HiveSessionProperties.getOrcStreamBufferSize(session), HiveSessionProperties.getOrcLazyReadSmallRanges(session), HiveSessionProperties.isOrcBloomFiltersEnabled(session), this.stats, this.domainCompactionThreshold, this.orcFileTailSource, this.stripeMetadataSource, hiveFileContext, new OrcReaderOptions(HiveSessionProperties.getOrcMaxMergeDistance(session), HiveSessionProperties.getOrcTinyStripeThreshold(session), HiveSessionProperties.getOrcMaxReadBlockSize(session), HiveSessionProperties.isOrcZstdJniDecompressionEnabled(session))));
    }

    public static OrcBatchPageSource createOrcPageSource(OrcEncoding orcEncoding, HdfsEnvironment hdfsEnvironment, String sessionUser, Configuration configuration, Path path, long start, long length, long fileSize, List<HiveColumnHandle> columns, boolean useOrcColumnNames, TupleDomain<HiveColumnHandle> effectivePredicate, DateTimeZone hiveStorageTimeZone, TypeManager typeManager, DataSize maxBufferSize, DataSize streamBufferSize, boolean lazyReadSmallRanges, boolean orcBloomFiltersEnabled, FileFormatDataSourceStats stats, int domainCompactionThreshold, OrcFileTailSource orcFileTailSource, StripeMetadataSource stripeMetadataSource, HiveFileContext hiveFileContext, OrcReaderOptions orcReaderOptions) {
        HdfsOrcDataSource orcDataSource;
        Preconditions.checkArgument((domainCompactionThreshold >= 1 ? 1 : 0) != 0, (Object)"domainCompactionThreshold must be at least 1");
        try {
            FSDataInputStream inputStream = hdfsEnvironment.getFileSystem(sessionUser, path, configuration).openFile(path, hiveFileContext);
            orcDataSource = new HdfsOrcDataSource(new OrcDataSourceId(path.toString()), fileSize, orcReaderOptions.getMaxMergeDistance(), maxBufferSize, streamBufferSize, lazyReadSmallRanges, inputStream, stats);
        }
        catch (Exception e) {
            if (Strings.nullToEmpty((String)e.getMessage()).trim().equals("Filesystem closed") || e instanceof FileNotFoundException) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, (Throwable)e);
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, OrcBatchPageSourceFactory.splitError(e, path, start, length), (Throwable)e);
        }
        HiveOrcAggregatedMemoryContext systemMemoryUsage = new HiveOrcAggregatedMemoryContext();
        try {
            OrcReader reader = new OrcReader((OrcDataSource)orcDataSource, orcEncoding, orcFileTailSource, stripeMetadataSource, (OrcAggregatedMemoryContext)new HiveOrcAggregatedMemoryContext(), orcReaderOptions, hiveFileContext.isCacheable());
            List<HiveColumnHandle> physicalColumns = HiveUtil.getPhysicalHiveColumnHandles(columns, useOrcColumnNames, reader, path);
            ImmutableMap.Builder includedColumns = ImmutableMap.builder();
            ImmutableList.Builder columnReferences = ImmutableList.builder();
            for (HiveColumnHandle column : physicalColumns) {
                if (column.getColumnType() != HiveColumnHandle.ColumnType.REGULAR) continue;
                Type type = typeManager.getType(column.getTypeSignature());
                includedColumns.put((Object)column.getHiveColumnIndex(), (Object)type);
                columnReferences.add((Object)new TupleDomainOrcPredicate.ColumnReference((Object)column, column.getHiveColumnIndex(), type));
            }
            TupleDomainOrcPredicate predicate = new TupleDomainOrcPredicate(effectivePredicate, (List)columnReferences.build(), orcBloomFiltersEnabled, Optional.of(domainCompactionThreshold));
            OrcBatchRecordReader recordReader = reader.createBatchRecordReader((Map)includedColumns.build(), (OrcPredicate)predicate, start, length, hiveStorageTimeZone, (OrcAggregatedMemoryContext)systemMemoryUsage, 1);
            return new OrcBatchPageSource(recordReader, (OrcDataSource)orcDataSource, physicalColumns, typeManager, systemMemoryUsage, stats);
        }
        catch (Exception e) {
            try {
                orcDataSource.close();
            }
            catch (IOException physicalColumns) {
                // empty catch block
            }
            if (e instanceof PrestoException) {
                throw (PrestoException)((Object)e);
            }
            String message = OrcBatchPageSourceFactory.splitError(e, path, start, length);
            if (e.getClass().getSimpleName().equals("BlockMissingException")) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_MISSING_DATA, message, (Throwable)e);
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, message, (Throwable)e);
        }
    }

    private static String splitError(Throwable t, Path path, long start, long length) {
        return String.format("Error opening Hive split %s (offset=%s, length=%s): %s", path, start, length, t.getMessage());
    }
}

