/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.pagefile;

import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveCompressionCodec;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveFileWriter;
import com.facebook.presto.hive.HiveFileWriterFactory;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.datasink.DataSinkFactory;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.pagefile.AirliftCompressorAdapter;
import com.facebook.presto.hive.pagefile.AirliftDecompressorAdapter;
import com.facebook.presto.hive.pagefile.PageFileFooterOutput;
import com.facebook.presto.hive.pagefile.PageFileWriter;
import com.facebook.presto.orc.DataSink;
import com.facebook.presto.orc.zlib.DeflateCompressor;
import com.facebook.presto.orc.zlib.InflateDecompressor;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.page.PagesSerde;
import com.google.common.collect.ImmutableList;
import io.airlift.compress.Compressor;
import io.airlift.compress.Decompressor;
import io.airlift.compress.lz4.Lz4Compressor;
import io.airlift.compress.lz4.Lz4Decompressor;
import io.airlift.compress.snappy.SnappyCompressor;
import io.airlift.compress.snappy.SnappyDecompressor;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;

public class PageFileWriterFactory
implements HiveFileWriterFactory {
    private final HdfsEnvironment hdfsEnvironment;
    private final DataSinkFactory dataSinkFactory;
    private final BlockEncodingSerde blockEncodingSerde;

    @Inject
    public PageFileWriterFactory(HdfsEnvironment hdfsEnvironment, DataSinkFactory dataSinkFactory, BlockEncodingSerde blockEncodingSerde) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.dataSinkFactory = Objects.requireNonNull(dataSinkFactory, "dataSinkFactory is null");
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
    }

    @Override
    public Optional<HiveFileWriter> createFileWriter(Path path, List<String> inputColumnNames, StorageFormat storageFormat, Properties schema, JobConf configuration, ConnectorSession session) {
        if (!storageFormat.getOutputFormat().equals(HiveStorageFormat.PAGEFILE.getOutputFormat())) {
            return Optional.empty();
        }
        HiveCompressionCodec compression = HiveCompressionCodec.valueOf(configuration.get("pagefile.output.compression"));
        if (!compression.isSupportedStorageFormat(HiveStorageFormat.PAGEFILE)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, String.format("%s compression is not supported for %s", compression.name(), HiveStorageFormat.PAGEFILE.getOutputFormat()));
        }
        PagesSerde pagesSerde = PageFileWriterFactory.createPagesSerdeForPageFile(this.blockEncodingSerde, Optional.of(compression));
        try {
            ExtendedFileSystem fileSystem = this.hdfsEnvironment.getFileSystem(session.getUser(), path, (Configuration)configuration);
            DataSink dataSink = this.dataSinkFactory.createDataSink(session, (FileSystem)fileSystem, path);
            Callable<Void> rollbackAction = () -> PageFileWriterFactory.lambda$createFileWriter$0((FileSystem)fileSystem, path);
            return Optional.of(new PageFileWriter(dataSink, pagesSerde, compression, HiveSessionProperties.getPageFileStripeMaxSize(session), rollbackAction));
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_OPEN_ERROR, "Error creating pagefile", (Throwable)e);
        }
    }

    public static void createEmptyPageFile(DataSinkFactory dataSinkFactory, ConnectorSession session, FileSystem fileSystem, Path path) {
        try {
            DataSink dataSink = dataSinkFactory.createDataSink(session, fileSystem, path);
            dataSink.write((List)ImmutableList.of((Object)PageFileFooterOutput.createEmptyPageFileFooterOutput()));
            dataSink.close();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_OPEN_ERROR, "Error creating empty pagefile", (Throwable)e);
        }
    }

    public static PagesSerde createPagesSerdeForPageFile(BlockEncodingSerde blockEncodingSerde, Optional<HiveCompressionCodec> compressionCodec) {
        if (!compressionCodec.isPresent()) {
            return new PagesSerde(blockEncodingSerde, Optional.empty(), Optional.empty(), Optional.empty());
        }
        AirliftCompressorAdapter pageCompressor = null;
        AirliftDecompressorAdapter pageDecompressor = null;
        switch (compressionCodec.get()) {
            case NONE: {
                break;
            }
            case SNAPPY: {
                pageCompressor = new AirliftCompressorAdapter((Compressor)new SnappyCompressor());
                pageDecompressor = new AirliftDecompressorAdapter((Decompressor)new SnappyDecompressor());
                break;
            }
            case LZ4: {
                pageCompressor = new AirliftCompressorAdapter((Compressor)new Lz4Compressor());
                pageDecompressor = new AirliftDecompressorAdapter((Decompressor)new Lz4Decompressor());
                break;
            }
            case GZIP: {
                pageCompressor = new AirliftCompressorAdapter((Compressor)new DeflateCompressor());
                pageDecompressor = new AirliftDecompressorAdapter((Decompressor)new InflateDecompressor());
                break;
            }
            default: {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("%s compression is not supported for %s", compressionCodec.get().name(), HiveStorageFormat.PAGEFILE.getOutputFormat()));
            }
        }
        return new PagesSerde(blockEncodingSerde, Optional.ofNullable(pageCompressor), Optional.ofNullable(pageDecompressor), Optional.empty());
    }

    private static /* synthetic */ Void lambda$createFileWriter$0(FileSystem fileSystem, Path path) throws Exception {
        fileSystem.delete(path, false);
        return null;
    }
}

