/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.pagefile;

import com.facebook.presto.hive.HiveCompressionCodec;
import com.facebook.presto.hive.pagefile.PageDataOutput;
import com.facebook.presto.hive.pagefile.PageFileFooterOutput;
import com.facebook.presto.orc.DataSink;
import com.facebook.presto.orc.stream.DataOutput;
import com.facebook.presto.spi.page.SerializedPage;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class PageWriter
implements Closeable {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(PageWriter.class).instanceSize();
    private final DataSink dataSink;
    private final HiveCompressionCodec compressionCodec;
    private long bufferedBytes;
    private long retainedBytes;
    private long maxBufferedBytes;
    private boolean closed;
    private List<DataOutput> bufferedPages;
    private List<Long> stripeOffsets;
    private long stripeOffset;

    public PageWriter(DataSink dataSink, HiveCompressionCodec compressionCodec, DataSize pageFileStripeMaxSize) {
        this.dataSink = Objects.requireNonNull(dataSink, "pageDataSink is null");
        this.compressionCodec = Objects.requireNonNull(compressionCodec, "compressionCodec is null");
        this.maxBufferedBytes = Objects.requireNonNull(pageFileStripeMaxSize, "pageFileStripeMaxSize is null").toBytes();
        this.bufferedPages = new ArrayList<DataOutput>();
        this.stripeOffsets = new ArrayList<Long>();
    }

    public long getWrittenBytes() {
        return this.dataSink.size();
    }

    public void write(SerializedPage page) throws IOException {
        PageDataOutput pageDataOutput = new PageDataOutput(page);
        long writtenSize = pageDataOutput.size();
        if (this.maxBufferedBytes - this.bufferedBytes < writtenSize) {
            this.flushStripe();
        }
        this.bufferedPages.add(pageDataOutput);
        this.bufferedBytes += writtenSize;
        this.retainedBytes += page.getRetainedSizeInBytes();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (!this.bufferedPages.isEmpty()) {
            this.flushStripe();
        }
        this.dataSink.write((List)ImmutableList.of((Object)new PageFileFooterOutput(this.stripeOffsets, this.compressionCodec)));
        this.dataSink.close();
    }

    public long getRetainedBytes() {
        return (long)INSTANCE_SIZE + this.retainedBytes + this.dataSink.getRetainedSizeInBytes();
    }

    private void flushStripe() throws IOException {
        this.dataSink.write(this.bufferedPages);
        this.stripeOffsets.add(this.stripeOffset);
        this.stripeOffset += this.bufferedBytes;
        this.bufferedPages.clear();
        this.bufferedBytes = 0L;
        this.retainedBytes = 0L;
    }
}

