/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.block;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.BlockUtil;
import com.facebook.presto.common.block.IntArrayList;
import com.facebook.presto.common.block.MapBlock;
import com.facebook.presto.common.block.SingleMapBlock;
import com.facebook.presto.common.type.Type;
import io.airlift.slice.SizeOf;
import io.airlift.slice.SliceOutput;
import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public abstract class AbstractMapBlock
implements Block {
    static final int HASH_MULTIPLIER = 2;
    protected final Type keyType;
    protected final MethodHandle keyNativeHashCode;
    protected final MethodHandle keyBlockNativeEquals;
    protected final MethodHandle keyBlockHashCode;

    public AbstractMapBlock(Type keyType, MethodHandle keyNativeHashCode, MethodHandle keyBlockNativeEquals, MethodHandle keyBlockHashCode) {
        this.keyType = Objects.requireNonNull(keyType, "keyType is null");
        this.keyNativeHashCode = keyNativeHashCode;
        this.keyBlockNativeEquals = keyBlockNativeEquals;
        this.keyBlockHashCode = Objects.requireNonNull(keyBlockHashCode, "keyBlockHashCode is null");
    }

    protected abstract Block getRawKeyBlock();

    protected abstract Block getRawValueBlock();

    protected abstract HashTables getHashTables();

    protected abstract int[] getOffsets();

    @Override
    public abstract int getOffsetBase();

    @Nullable
    protected abstract boolean[] getMapIsNull();

    protected abstract void ensureHashTableLoaded();

    int getOffset(int position) {
        return this.getOffsets()[position + this.getOffsetBase()];
    }

    @Override
    public String getEncodingName() {
        return "MAP";
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        int[] newOffsets = new int[length + 1];
        boolean[] newMapIsNull = new boolean[length];
        IntArrayList entriesPositions = new IntArrayList();
        int newPosition = 0;
        for (int i = offset; i < offset + length; ++i) {
            int position = positions[i];
            if (this.isNull(position)) {
                newMapIsNull[newPosition] = true;
                newOffsets[newPosition + 1] = newOffsets[newPosition];
            } else {
                int entriesStartOffset = this.getOffset(position);
                int entriesEndOffset = this.getOffset(position + 1);
                int entryCount = entriesEndOffset - entriesStartOffset;
                newOffsets[newPosition + 1] = newOffsets[newPosition] + entryCount;
                for (int elementIndex = entriesStartOffset; elementIndex < entriesEndOffset; ++elementIndex) {
                    entriesPositions.add(elementIndex);
                }
            }
            ++newPosition;
        }
        int[] rawHashTables = this.getHashTables().get();
        int[] newRawHashTables = null;
        int newHashTableEntries = newOffsets[newOffsets.length - 1] * 2;
        if (rawHashTables != null) {
            newRawHashTables = new int[newHashTableEntries];
            int newHashIndex = 0;
            for (int i = offset; i < offset + length; ++i) {
                int position = positions[i];
                int entriesStartOffset = this.getOffset(position);
                int entriesEndOffset = this.getOffset(position + 1);
                for (int hashIndex = entriesStartOffset * 2; hashIndex < entriesEndOffset * 2; ++hashIndex) {
                    newRawHashTables[newHashIndex] = rawHashTables[hashIndex];
                    ++newHashIndex;
                }
            }
        }
        Block newKeys = this.getRawKeyBlock().copyPositions(entriesPositions.elements(), 0, entriesPositions.size());
        Block newValues = this.getRawValueBlock().copyPositions(entriesPositions.elements(), 0, entriesPositions.size());
        return MapBlock.createMapBlockInternal(0, length, Optional.of(newMapIsNull), newOffsets, newKeys, newValues, new HashTables(Optional.ofNullable(newRawHashTables), length, newHashTableEntries), this.keyType, this.keyBlockNativeEquals, this.keyNativeHashCode, this.keyBlockHashCode);
    }

    @Override
    public Block getRegion(int position, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        return MapBlock.createMapBlockInternal(position + this.getOffsetBase(), length, Optional.ofNullable(this.getMapIsNull()), this.getOffsets(), this.getRawKeyBlock(), this.getRawValueBlock(), this.getHashTables(), this.keyType, this.keyBlockNativeEquals, this.keyNativeHashCode, this.keyBlockHashCode);
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        int entriesStart = this.getOffsets()[this.getOffsetBase() + position];
        int entriesEnd = this.getOffsets()[this.getOffsetBase() + position + length];
        int entryCount = entriesEnd - entriesStart;
        return this.getRawKeyBlock().getRegionSizeInBytes(entriesStart, entryCount) + this.getRawValueBlock().getRegionSizeInBytes(entriesStart, entryCount) + 5L * (long)length + 8L * (long)entryCount + this.getHashTables().getInstanceSizeInBytes();
    }

    @Override
    public long getPositionsSizeInBytes(boolean[] positions) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidPositions(positions, positionCount);
        boolean[] entryPositions = new boolean[this.getRawKeyBlock().getPositionCount()];
        int usedEntryCount = 0;
        int usedPositionCount = 0;
        for (int i = 0; i < positions.length; ++i) {
            if (!positions[i]) continue;
            ++usedPositionCount;
            int entriesStart = this.getOffsets()[this.getOffsetBase() + i];
            int entriesEnd = this.getOffsets()[this.getOffsetBase() + i + 1];
            for (int j = entriesStart; j < entriesEnd; ++j) {
                entryPositions[j] = true;
            }
            usedEntryCount += entriesEnd - entriesStart;
        }
        return this.getRawKeyBlock().getPositionsSizeInBytes(entryPositions) + this.getRawValueBlock().getPositionsSizeInBytes(entryPositions) + 5L * (long)usedPositionCount + 8L * (long)usedEntryCount + this.getHashTables().getInstanceSizeInBytes();
    }

    @Override
    public Block copyRegion(int position, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        int startValueOffset = this.getOffset(position);
        int endValueOffset = this.getOffset(position + length);
        Block newKeys = this.getRawKeyBlock().copyRegion(startValueOffset, endValueOffset - startValueOffset);
        Block newValues = this.getRawValueBlock().copyRegion(startValueOffset, endValueOffset - startValueOffset);
        int[] newOffsets = BlockUtil.compactOffsets(this.getOffsets(), position + this.getOffsetBase(), length);
        boolean[] mapIsNull = this.getMapIsNull();
        boolean[] newMapIsNull = mapIsNull == null ? null : BlockUtil.compactArray(mapIsNull, position + this.getOffsetBase(), length);
        int[] rawHashTables = this.getHashTables().get();
        int[] newRawHashTables = null;
        int expectedNewHashTableEntries = (endValueOffset - startValueOffset) * 2;
        if (rawHashTables != null) {
            newRawHashTables = BlockUtil.compactArray(rawHashTables, startValueOffset * 2, expectedNewHashTableEntries);
        }
        if (newKeys == this.getRawKeyBlock() && newValues == this.getRawValueBlock() && newOffsets == this.getOffsets() && newMapIsNull == mapIsNull && newRawHashTables == rawHashTables) {
            return this;
        }
        return MapBlock.createMapBlockInternal(0, length, Optional.ofNullable(newMapIsNull), newOffsets, newKeys, newValues, new HashTables(Optional.ofNullable(newRawHashTables), length, expectedNewHashTableEntries), this.keyType, this.keyBlockNativeEquals, this.keyNativeHashCode, this.keyBlockHashCode);
    }

    @Override
    public Block getBlock(int position) {
        this.checkReadablePosition(position);
        int startEntryOffset = this.getOffset(position);
        int endEntryOffset = this.getOffset(position + 1);
        return new SingleMapBlock(startEntryOffset * 2, (endEntryOffset - startEntryOffset) * 2, this);
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        this.checkReadablePosition(position);
        blockBuilder.appendStructureInternal(this, position);
    }

    @Override
    public void writePositionTo(int position, SliceOutput output) {
        if (this.isNull(position)) {
            output.writeByte(0);
        } else {
            int startValueOffset = this.getOffset(position);
            int endValueOffset = this.getOffset(position + 1);
            int numberOfElements = endValueOffset - startValueOffset;
            output.writeByte(1);
            output.writeInt(numberOfElements);
            Block rawKeyBlock = this.getRawKeyBlock();
            Block rawValueBlock = this.getRawValueBlock();
            for (int i = startValueOffset; i < endValueOffset; ++i) {
                rawKeyBlock.writePositionTo(i, output);
                rawValueBlock.writePositionTo(i, output);
            }
        }
    }

    @Override
    public Block getSingleValueBlock(int position) {
        this.checkReadablePosition(position);
        int startValueOffset = this.getOffset(position);
        int endValueOffset = this.getOffset(position + 1);
        int valueLength = endValueOffset - startValueOffset;
        Block newKeys = this.getRawKeyBlock().copyRegion(startValueOffset, valueLength);
        Block newValues = this.getRawValueBlock().copyRegion(startValueOffset, valueLength);
        int[] rawHashTables = this.getHashTables().get();
        int[] newRawHashTables = null;
        int expectedNewHashTableEntries = (endValueOffset - startValueOffset) * 2;
        if (rawHashTables != null) {
            newRawHashTables = Arrays.copyOfRange(rawHashTables, startValueOffset * 2, endValueOffset * 2);
        }
        return MapBlock.createMapBlockInternal(0, 1, Optional.of(new boolean[]{this.isNull(position)}), new int[]{0, valueLength}, newKeys, newValues, new HashTables(Optional.ofNullable(newRawHashTables), 1, expectedNewHashTableEntries), this.keyType, this.keyBlockNativeEquals, this.keyNativeHashCode, this.keyBlockHashCode);
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        this.checkReadablePosition(position);
        if (this.isNull(position)) {
            return 0L;
        }
        int startValueOffset = this.getOffset(position);
        int endValueOffset = this.getOffset(position + 1);
        long size = 0L;
        Block rawKeyBlock = this.getRawKeyBlock();
        Block rawValueBlock = this.getRawValueBlock();
        for (int i = startValueOffset; i < endValueOffset; ++i) {
            size += rawKeyBlock.getEstimatedDataSizeForStats(i);
            size += rawValueBlock.getEstimatedDataSizeForStats(i);
        }
        return size;
    }

    @Override
    public boolean mayHaveNull() {
        return this.getMapIsNull() != null;
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        boolean[] mapIsNull = this.getMapIsNull();
        return mapIsNull != null && mapIsNull[position + this.getOffsetBase()];
    }

    public boolean isHashTablesPresent() {
        return this.getHashTables().get() != null;
    }

    private void checkReadablePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid");
        }
    }

    @Override
    public Block getBlockUnchecked(int internalPosition) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        int startEntryOffset = this.getOffsets()[internalPosition];
        int endEntryOffset = this.getOffsets()[internalPosition + 1];
        return new SingleMapBlock(startEntryOffset * 2, (endEntryOffset - startEntryOffset) * 2, this);
    }

    @Override
    public boolean isNullUnchecked(int internalPosition) {
        assert (this.mayHaveNull()) : "no nulls present";
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return this.getMapIsNull()[internalPosition];
    }

    @Override
    public Block appendNull() {
        boolean[] mapIsNull = BlockUtil.appendNullToIsNullArray(this.getMapIsNull(), this.getOffsetBase(), this.getPositionCount());
        int[] offsets = BlockUtil.appendNullToOffsetsArray(this.getOffsets(), this.getOffsetBase(), this.getPositionCount());
        return MapBlock.createMapBlockInternal(this.getOffsetBase(), this.getPositionCount() + 1, Optional.of(mapIsNull), offsets, this.getRawKeyBlock(), this.getRawValueBlock(), this.getHashTables(), this.keyType, this.keyBlockNativeEquals, this.keyNativeHashCode, this.keyBlockHashCode);
    }

    public static class HashTables {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(HashTables.class).instanceSize();
        @Nullable
        private volatile int[] hashTables;
        private int expectedHashTableCount;
        private int expectedEntryCount;

        HashTables(Optional<int[]> hashTables, int expectedHashTableCount, int expectedEntryCount) {
            if (hashTables.isPresent() && hashTables.get().length != expectedEntryCount) {
                throw new IllegalArgumentException("hashTables size does not match expectedEntryCount");
            }
            this.hashTables = hashTables.orElse(null);
            this.expectedEntryCount = expectedEntryCount;
            this.expectedHashTableCount = expectedHashTableCount;
        }

        @Nullable
        int[] get() {
            return this.hashTables;
        }

        void set(int[] hashTables) {
            Objects.requireNonNull(hashTables, "hashTables is null");
            this.hashTables = hashTables;
            this.expectedEntryCount = hashTables.length;
        }

        int getExpectedHashTableCount() {
            return this.expectedHashTableCount;
        }

        public long getInstanceSizeInBytes() {
            return INSTANCE_SIZE;
        }

        public long getRetainedSizeInBytes() {
            return (long)INSTANCE_SIZE + SizeOf.sizeOfIntArray((int)this.expectedEntryCount);
        }
    }
}

