/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.block;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockEncoding;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.block.EncoderUtil;
import com.facebook.presto.common.block.LongArrayBlock;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;

public class LongArrayBlockEncoding
implements BlockEncoding {
    public static final String NAME = "LONG_ARRAY";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        int positionCount = block.getPositionCount();
        sliceOutput.appendInt(positionCount);
        EncoderUtil.encodeNullsAsBits(sliceOutput, block);
        for (int position = 0; position < positionCount; ++position) {
            if (block.isNull(position)) continue;
            sliceOutput.writeLong(block.getLong(position));
        }
    }

    @Override
    public Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        boolean[] valueIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount).orElse(null);
        long[] values = new long[positionCount];
        for (int position = 0; position < positionCount; ++position) {
            if (valueIsNull != null && valueIsNull[position]) continue;
            values[position] = sliceInput.readLong();
        }
        return new LongArrayBlock(0, positionCount, valueIsNull, values);
    }
}

