/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.event;

import com.facebook.airlift.event.client.EventField;
import com.facebook.airlift.event.client.EventType;
import com.facebook.presto.verifier.event.DeterminismAnalysisRun;
import com.facebook.presto.verifier.framework.LimitQueryDeterminismAnalysis;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@EventType(value="DeterminismAnalysisDetails")
@Immutable
public class DeterminismAnalysisDetails {
    private final List<DeterminismAnalysisRun> runs;
    private final String limitQueryAnalysis;
    private final String limitQueryAnalysisQueryId;

    @JsonCreator
    public DeterminismAnalysisDetails(List<DeterminismAnalysisRun> runs, LimitQueryDeterminismAnalysis limitQueryAnalysis, Optional<String> limitQueryAnalysisQueryId) {
        this.runs = ImmutableList.copyOf(runs);
        this.limitQueryAnalysis = limitQueryAnalysis.name();
        this.limitQueryAnalysisQueryId = limitQueryAnalysisQueryId.orElse(null);
    }

    @EventField
    public List<DeterminismAnalysisRun> getRuns() {
        return this.runs;
    }

    @EventField
    public String getLimitQueryAnalysis() {
        return this.limitQueryAnalysis;
    }

    @EventField
    public String getLimitQueryAnalysisQueryId() {
        return this.limitQueryAnalysisQueryId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<DeterminismAnalysisRun.Builder> runs = new ArrayList<DeterminismAnalysisRun.Builder>();
        private Optional<LimitQueryDeterminismAnalysis> limitQueryAnalysis = Optional.empty();
        private Optional<String> limitQueryAnalysisQueryId = Optional.empty();

        public DeterminismAnalysisRun.Builder addRun() {
            DeterminismAnalysisRun.Builder run = DeterminismAnalysisRun.builder();
            this.runs.add(run);
            return run;
        }

        public void setLimitQueryAnalysis(LimitQueryDeterminismAnalysis limitQueryAnalysis) {
            Preconditions.checkState((!this.limitQueryAnalysis.isPresent() ? 1 : 0) != 0, (Object)"limitQueryAnalysis is already set");
            this.limitQueryAnalysis = Optional.of(limitQueryAnalysis);
        }

        public void setLimitQueryAnalysisQueryId(String limitQueryAnalysisQueryId) {
            Preconditions.checkState((!this.limitQueryAnalysisQueryId.isPresent() ? 1 : 0) != 0, (Object)"limitQueryAnalysis is already set");
            this.limitQueryAnalysisQueryId = Optional.of(limitQueryAnalysisQueryId);
        }

        public DeterminismAnalysisDetails build() {
            return new DeterminismAnalysisDetails((List)this.runs.stream().map(DeterminismAnalysisRun.Builder::build).collect(ImmutableList.toImmutableList()), this.limitQueryAnalysis.orElse(LimitQueryDeterminismAnalysis.NOT_RUN), this.limitQueryAnalysisQueryId);
        }
    }
}

