/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.verifier.framework.QueryConfigurationOverrides;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jdbi.v3.core.mapper.reflect.ColumnName;
import org.jdbi.v3.core.mapper.reflect.JdbiConstructor;

public class QueryConfiguration {
    private final String catalog;
    private final String schema;
    private final Optional<String> username;
    private final Optional<String> password;
    private final Map<String, String> sessionProperties;

    @JdbiConstructor
    public QueryConfiguration(@ColumnName(value="catalog") String catalog, @ColumnName(value="schema") String schema, @ColumnName(value="username") Optional<String> username, @ColumnName(value="password") Optional<String> password, @ColumnName(value="session_properties") Optional<Map<String, String>> sessionProperties) {
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.username = Objects.requireNonNull(username, "username is null");
        this.password = Objects.requireNonNull(password, "password is null");
        this.sessionProperties = ImmutableMap.copyOf(sessionProperties.orElse((Map<String, String>)ImmutableMap.of()));
    }

    public QueryConfiguration applyOverrides(QueryConfigurationOverrides overrides) {
        Map<String, String> sessionProperties = this.sessionProperties;
        if (overrides.getSessionPropertiesOverrideStrategy() == QueryConfigurationOverrides.SessionPropertiesOverrideStrategy.OVERRIDE) {
            sessionProperties = overrides.getSessionPropertiesOverride();
        } else if (overrides.getSessionPropertiesOverrideStrategy() == QueryConfigurationOverrides.SessionPropertiesOverrideStrategy.SUBSTITUTE) {
            sessionProperties = new HashMap<String, String>(sessionProperties);
            for (Map.Entry<String, String> entry : overrides.getSessionPropertiesOverride().entrySet()) {
                sessionProperties.put(entry.getKey(), entry.getValue());
            }
        }
        return new QueryConfiguration(overrides.getCatalogOverride().orElse(this.catalog), overrides.getSchemaOverride().orElse(this.schema), Optional.ofNullable(overrides.getUsernameOverride().orElse(this.username.orElse(null))), Optional.ofNullable(overrides.getPasswordOverride().orElse(this.password.orElse(null))), Optional.of(sessionProperties));
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public Optional<String> getUsername() {
        return this.username;
    }

    public Optional<String> getPassword() {
        return this.password;
    }

    public Map<String, String> getSessionProperties() {
        return this.sessionProperties;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QueryConfiguration o = (QueryConfiguration)obj;
        return Objects.equals(this.catalog, o.catalog) && Objects.equals(this.schema, o.schema) && Objects.equals(this.username, o.username) && Objects.equals(this.password, o.password) && Objects.equals(this.sessionProperties, o.sessionProperties);
    }

    public int hashCode() {
        return Objects.hash(this.catalog, this.schema, this.username, this.password, this.sessionProperties);
    }
}

