/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.resolver;

import com.facebook.presto.jdbc.QueryStats;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.verifier.framework.QueryBundle;
import com.facebook.presto.verifier.framework.QueryException;
import com.facebook.presto.verifier.framework.QueryStage;
import com.facebook.presto.verifier.resolver.FailureResolver;
import com.facebook.presto.verifier.resolver.FailureResolverUtil;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;

public class ChecksumExceededTimeLimitFailureResolver
implements FailureResolver {
    public static final String NAME = "checksum-exceeded-time-limit";

    @Override
    public Optional<String> resolveQueryFailure(QueryStats controlQueryStats, QueryException queryException, Optional<QueryBundle> test) {
        return FailureResolverUtil.mapMatchingPrestoException(queryException, QueryStage.CONTROL_CHECKSUM, (Set<ErrorCodeSupplier>)ImmutableSet.of((Object)StandardErrorCode.EXCEEDED_TIME_LIMIT), e -> Optional.of("Time limit exceeded when running control checksum query"));
    }
}

