/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.rewrite;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.TimeType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.AllColumns;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CreateTable;
import com.facebook.presto.sql.tree.CreateTableAsSelect;
import com.facebook.presto.sql.tree.DropTable;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Insert;
import com.facebook.presto.sql.tree.LikeClause;
import com.facebook.presto.sql.tree.Property;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QueryBody;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.type.UnknownType;
import com.facebook.presto.verifier.framework.ClusterType;
import com.facebook.presto.verifier.framework.QueryBundle;
import com.facebook.presto.verifier.framework.QueryStage;
import com.facebook.presto.verifier.framework.QueryType;
import com.facebook.presto.verifier.framework.VerifierUtil;
import com.facebook.presto.verifier.prestoaction.PrestoAction;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.intellij.lang.annotations.Language;

public class QueryRewriter {
    private final SqlParser sqlParser;
    private final TypeManager typeManager;
    private final PrestoAction prestoAction;
    private final Map<ClusterType, QualifiedName> prefixes;
    private final Map<ClusterType, List<Property>> tableProperties;

    public QueryRewriter(SqlParser sqlParser, TypeManager typeManager, PrestoAction prestoAction, Map<ClusterType, QualifiedName> tablePrefixes, Map<ClusterType, List<Property>> tableProperties) {
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.prestoAction = Objects.requireNonNull(prestoAction, "prestoAction is null");
        this.prefixes = ImmutableMap.copyOf(tablePrefixes);
        this.tableProperties = ImmutableMap.copyOf(tableProperties);
    }

    public QueryBundle rewriteQuery(@Language(value="SQL") String query, ClusterType clusterType) {
        Preconditions.checkState((boolean)this.prefixes.containsKey((Object)clusterType), (String)"Unsupported cluster type: %s", (Object)((Object)clusterType));
        Statement statement = this.sqlParser.createStatement(query, VerifierUtil.PARSING_OPTIONS);
        QueryType queryType = QueryType.of(statement);
        Preconditions.checkArgument((queryType.getCategory() == QueryType.Category.DATA_PRODUCING ? 1 : 0) != 0, (String)"Unsupported statement type: %s", (Object)((Object)queryType));
        QualifiedName prefix = this.prefixes.get((Object)clusterType);
        List<Property> properties = this.tableProperties.get((Object)clusterType);
        if (statement instanceof CreateTableAsSelect) {
            CreateTableAsSelect createTableAsSelect = (CreateTableAsSelect)statement;
            QualifiedName temporaryTableName = this.generateTemporaryTableName(Optional.of(createTableAsSelect.getName()), prefix);
            return new QueryBundle(temporaryTableName, (List<Statement>)ImmutableList.of(), (Statement)new CreateTableAsSelect(temporaryTableName, createTableAsSelect.getQuery(), createTableAsSelect.isNotExists(), QueryRewriter.applyPropertyOverride(createTableAsSelect.getProperties(), properties), createTableAsSelect.isWithData(), createTableAsSelect.getColumnAliases(), createTableAsSelect.getComment()), (List<Statement>)ImmutableList.of((Object)new DropTable(temporaryTableName, true)), clusterType);
        }
        if (statement instanceof Insert) {
            Insert insert = (Insert)statement;
            QualifiedName originalTableName = insert.getTarget();
            QualifiedName temporaryTableName = this.generateTemporaryTableName(Optional.of(originalTableName), prefix);
            return new QueryBundle(temporaryTableName, (List<Statement>)ImmutableList.of((Object)new CreateTable(temporaryTableName, (List)ImmutableList.of((Object)new LikeClause(originalTableName, Optional.of(LikeClause.PropertiesOption.INCLUDING))), false, properties, Optional.empty())), (Statement)new Insert(temporaryTableName, insert.getColumns(), insert.getQuery()), (List<Statement>)ImmutableList.of((Object)new DropTable(temporaryTableName, true)), clusterType);
        }
        if (statement instanceof Query) {
            QualifiedName temporaryTableName = this.generateTemporaryTableName(Optional.empty(), prefix);
            ResultSetMetaData metadata = this.getResultMetadata((Query)statement);
            List<Identifier> columnAliases = this.generateStorageColumnAliases(metadata);
            Query rewrite = this.rewriteNonStorableColumns((Query)statement, metadata);
            return new QueryBundle(temporaryTableName, (List<Statement>)ImmutableList.of(), (Statement)new CreateTableAsSelect(temporaryTableName, rewrite, false, properties, true, Optional.of(columnAliases), Optional.empty()), (List<Statement>)ImmutableList.of((Object)new DropTable(temporaryTableName, true)), clusterType);
        }
        throw new IllegalStateException(String.format("Unsupported query type: %s", statement.getClass()));
    }

    private QualifiedName generateTemporaryTableName(Optional<QualifiedName> originalName, QualifiedName prefix) {
        ArrayList parts = new ArrayList();
        int originalSize = originalName.map(QualifiedName::getOriginalParts).map(List::size).orElse(0);
        int prefixSize = prefix.getOriginalParts().size();
        if (originalName.isPresent() && originalSize > prefixSize) {
            parts.addAll(originalName.get().getOriginalParts().subList(0, originalSize - prefixSize));
        }
        parts.addAll(prefix.getOriginalParts());
        parts.set(parts.size() - 1, prefix.getSuffix() + "_" + UUID.randomUUID().toString().replace("-", ""));
        return QualifiedName.of(parts);
    }

    private List<Identifier> generateStorageColumnAliases(ResultSetMetaData metadata) {
        ImmutableList.Builder aliases = ImmutableList.builder();
        HashSet<String> usedAliases = new HashSet<String>();
        for (String columnName : VerifierUtil.getColumnNames(metadata)) {
            String alias = columnName = QueryRewriter.sanitizeColumnName(columnName);
            int postfix = 1;
            while (usedAliases.contains(alias)) {
                alias = String.format("%s__%s", columnName, postfix);
                ++postfix;
            }
            aliases.add((Object)new Identifier(alias, true));
            usedAliases.add(alias);
        }
        return aliases.build();
    }

    private ResultSetMetaData getResultMetadata(Query query) {
        Query zeroRowQuery;
        if (query.getQueryBody() instanceof QuerySpecification) {
            QuerySpecification querySpecification = (QuerySpecification)query.getQueryBody();
            zeroRowQuery = new Query(query.getWith(), (QueryBody)new QuerySpecification(querySpecification.getSelect(), querySpecification.getFrom(), querySpecification.getWhere(), querySpecification.getGroupBy(), querySpecification.getHaving(), querySpecification.getOrderBy(), Optional.of("0")), Optional.empty(), Optional.empty());
        } else {
            zeroRowQuery = new Query(query.getWith(), query.getQueryBody(), Optional.empty(), Optional.of("0"));
        }
        return this.prestoAction.execute((Statement)zeroRowQuery, QueryStage.REWRITE, PrestoAction.ResultSetConverter.DEFAULT).getMetadata();
    }

    private Query rewriteNonStorableColumns(Query query, ResultSetMetaData metadata) {
        List<Type> columnTypes = VerifierUtil.getColumnTypes(this.typeManager, metadata);
        if (columnTypes.stream().noneMatch(type -> this.getColumnTypeRewrite((Type)type).isPresent())) {
            return query;
        }
        if (!(query.getQueryBody() instanceof QuerySpecification)) {
            return query;
        }
        QuerySpecification querySpecification = (QuerySpecification)query.getQueryBody();
        List selectItems = querySpecification.getSelect().getSelectItems();
        if (selectItems.stream().anyMatch(AllColumns.class::isInstance)) {
            return query;
        }
        ArrayList<SingleColumn> newItems = new ArrayList<SingleColumn>();
        Preconditions.checkState((selectItems.size() == columnTypes.size() ? 1 : 0) != 0, (String)"SelectItem count (%s) mismatches column count (%s)", (int)selectItems.size(), (int)columnTypes.size());
        for (int i = 0; i < selectItems.size(); ++i) {
            SingleColumn singleColumn = (SingleColumn)selectItems.get(i);
            Optional<Type> columnTypeRewrite = this.getColumnTypeRewrite(columnTypes.get(i));
            if (columnTypeRewrite.isPresent()) {
                newItems.add(new SingleColumn((Expression)new Cast(singleColumn.getExpression(), columnTypeRewrite.get().getTypeSignature().toString()), singleColumn.getAlias()));
                continue;
            }
            newItems.add(singleColumn);
        }
        return new Query(query.getWith(), (QueryBody)new QuerySpecification(new Select(querySpecification.getSelect().isDistinct(), newItems), querySpecification.getFrom(), querySpecification.getWhere(), querySpecification.getGroupBy(), querySpecification.getHaving(), querySpecification.getOrderBy(), querySpecification.getLimit()), query.getOrderBy(), query.getLimit());
    }

    private Optional<Type> getColumnTypeRewrite(Type type) {
        if (type.equals(DateType.DATE) || type.equals(TimeType.TIME)) {
            return Optional.of(TimestampType.TIMESTAMP);
        }
        if (type.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE)) {
            return Optional.of(VarcharType.VARCHAR);
        }
        if (type.equals(UnknownType.UNKNOWN)) {
            return Optional.of(BigintType.BIGINT);
        }
        if (type instanceof DecimalType) {
            return Optional.of(DoubleType.DOUBLE);
        }
        if (type instanceof ArrayType) {
            return this.getColumnTypeRewrite(((ArrayType)type).getElementType()).map(ArrayType::new);
        }
        if (type instanceof MapType) {
            Type keyType = ((MapType)type).getKeyType();
            Type valueType = ((MapType)type).getValueType();
            Optional<Type> keyTypeRewrite = this.getColumnTypeRewrite(keyType);
            Optional<Type> valueTypeRewrite = this.getColumnTypeRewrite(valueType);
            if (keyTypeRewrite.isPresent() || valueTypeRewrite.isPresent()) {
                return Optional.of(this.typeManager.getType(new TypeSignature("map", new TypeSignatureParameter[]{TypeSignatureParameter.of((TypeSignature)keyTypeRewrite.orElse(keyType).getTypeSignature()), TypeSignatureParameter.of((TypeSignature)valueTypeRewrite.orElse(valueType).getTypeSignature())})));
            }
            return Optional.empty();
        }
        if (type instanceof RowType) {
            List fields = ((RowType)type).getFields();
            ArrayList<RowType.Field> fieldsRewrite = new ArrayList<RowType.Field>();
            boolean rewrite = false;
            for (RowType.Field field : fields) {
                Optional<Type> fieldTypeRewrite = this.getColumnTypeRewrite(field.getType());
                rewrite = rewrite || fieldTypeRewrite.isPresent();
                fieldsRewrite.add(new RowType.Field(field.getName(), fieldTypeRewrite.orElse(field.getType())));
            }
            return rewrite ? Optional.of(RowType.from(fieldsRewrite)) : Optional.empty();
        }
        return Optional.empty();
    }

    private static String sanitizeColumnName(String columnName) {
        return columnName.replaceAll("[^a-zA-Z0-9_]", "_").toLowerCase(Locale.ENGLISH);
    }

    private static List<Property> applyPropertyOverride(List<Property> properties, List<Property> overrides) {
        Map propertyMap = (Map)properties.stream().collect(ImmutableMap.toImmutableMap(property -> property.getName().getValue().toLowerCase(Locale.ENGLISH), Property::getValue));
        Map overrideMap = (Map)overrides.stream().collect(ImmutableMap.toImmutableMap(property -> property.getName().getValue().toLowerCase(Locale.ENGLISH), Property::getValue));
        return (List)Stream.concat(propertyMap.entrySet().stream(), overrideMap.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (original, override) -> override)).entrySet().stream().map(entry -> new Property(new Identifier((String)entry.getKey()), (Expression)entry.getValue())).collect(ImmutableList.toImmutableList());
    }
}

