/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.source;

import com.facebook.presto.verifier.framework.SourceQuery;
import com.facebook.presto.verifier.source.SourceQuerySupplier;
import com.facebook.presto.verifier.source.VerifierDao;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.inject.Provider;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;

public abstract class AbstractJdbiSourceQuerySupplier
implements SourceQuerySupplier {
    private final Provider<Jdbi> jdbiProvider;
    private final String tableName;
    private final List<String> suites;
    private final int maxQueriesPerSuite;

    public AbstractJdbiSourceQuerySupplier(Provider<Jdbi> jdbiProvider, String tableName, List<String> suites, int maxQueriesPerSuite) {
        this.jdbiProvider = Objects.requireNonNull(jdbiProvider, "jdbiProvider is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.suites = ImmutableList.copyOf(suites);
        this.maxQueriesPerSuite = maxQueriesPerSuite;
    }

    @Override
    public List<SourceQuery> get() {
        ImmutableList.Builder sourceQueries = ImmutableList.builder();
        try (Handle handle = ((Jdbi)this.jdbiProvider.get()).open();){
            VerifierDao verifierDao = (VerifierDao)handle.attach(VerifierDao.class);
            for (String suite : this.suites) {
                sourceQueries.addAll(verifierDao.getSourceQueries(this.tableName, suite, this.maxQueriesPerSuite));
            }
        }
        return sourceQueries.build();
    }
}

