/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.source;

import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.presto.verifier.framework.VerifierConfig;
import com.facebook.presto.verifier.source.MySqlSourceQueryConfig;
import com.facebook.presto.verifier.source.MySqlSourceQuerySupplier;
import com.facebook.presto.verifier.source.SourceQuerySupplier;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import java.util.Set;

public class SourceQueryModule
extends AbstractConfigurationAwareModule {
    private final Set<String> supportedSourceQuerySupplierTypes;

    public SourceQueryModule(Set<String> customSourceQuerySupplierTypes) {
        this.supportedSourceQuerySupplierTypes = ImmutableSet.builder().add((Object)"mysql").addAll(customSourceQuerySupplierTypes).build();
    }

    protected void setup(Binder binder) {
        String sourceQuerySupplierType = ((VerifierConfig)this.buildConfigObject(VerifierConfig.class)).getSourceQuerySupplier();
        Preconditions.checkArgument((boolean)this.supportedSourceQuerySupplierTypes.contains(sourceQuerySupplierType), (String)"Unsupported SourceQuerySupplier: %s", (Object)sourceQuerySupplierType);
        if ("mysql".equals(sourceQuerySupplierType)) {
            ConfigBinder.configBinder((Binder)binder).bindConfig(MySqlSourceQueryConfig.class, "source-query");
            binder.bind(SourceQuerySupplier.class).to(MySqlSourceQuerySupplier.class).in(Scopes.SINGLETON);
        }
    }
}

