/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.ErrorType;

public enum HiveErrorCode implements ErrorCodeSupplier
{
    HIVE_METASTORE_ERROR(0, ErrorType.EXTERNAL),
    HIVE_CURSOR_ERROR(1, ErrorType.EXTERNAL),
    HIVE_TABLE_OFFLINE(2, ErrorType.USER_ERROR),
    HIVE_CANNOT_OPEN_SPLIT(3, ErrorType.EXTERNAL),
    HIVE_FILE_NOT_FOUND(4, ErrorType.EXTERNAL),
    HIVE_UNKNOWN_ERROR(5, ErrorType.EXTERNAL),
    HIVE_PARTITION_OFFLINE(6, ErrorType.USER_ERROR),
    HIVE_BAD_DATA(7, ErrorType.EXTERNAL),
    HIVE_PARTITION_SCHEMA_MISMATCH(8, ErrorType.EXTERNAL),
    HIVE_MISSING_DATA(9, ErrorType.EXTERNAL),
    HIVE_INVALID_PARTITION_VALUE(10, ErrorType.EXTERNAL),
    HIVE_TIMEZONE_MISMATCH(11, ErrorType.EXTERNAL),
    HIVE_INVALID_METADATA(12, ErrorType.EXTERNAL),
    HIVE_INVALID_VIEW_DATA(13, ErrorType.EXTERNAL),
    HIVE_DATABASE_LOCATION_ERROR(14, ErrorType.EXTERNAL),
    HIVE_PATH_ALREADY_EXISTS(15, ErrorType.EXTERNAL),
    HIVE_FILESYSTEM_ERROR(16, ErrorType.EXTERNAL),
    HIVE_SERDE_NOT_FOUND(18, ErrorType.EXTERNAL),
    HIVE_UNSUPPORTED_FORMAT(19, ErrorType.EXTERNAL),
    HIVE_PARTITION_READ_ONLY(20, ErrorType.USER_ERROR),
    HIVE_TOO_MANY_OPEN_PARTITIONS(21, ErrorType.USER_ERROR),
    HIVE_CONCURRENT_MODIFICATION_DETECTED(22, ErrorType.EXTERNAL),
    HIVE_COLUMN_ORDER_MISMATCH(23, ErrorType.USER_ERROR),
    HIVE_FILE_MISSING_COLUMN_NAMES(24, ErrorType.EXTERNAL),
    HIVE_WRITER_OPEN_ERROR(25, ErrorType.EXTERNAL),
    HIVE_WRITER_CLOSE_ERROR(26, ErrorType.EXTERNAL),
    HIVE_WRITER_DATA_ERROR(27, ErrorType.EXTERNAL),
    HIVE_INVALID_BUCKET_FILES(28, ErrorType.EXTERNAL),
    HIVE_EXCEEDED_PARTITION_LIMIT(29, ErrorType.USER_ERROR),
    HIVE_WRITE_VALIDATION_FAILED(30, ErrorType.INTERNAL_ERROR),
    HIVE_PARTITION_DROPPED_DURING_QUERY(31, ErrorType.EXTERNAL),
    HIVE_TABLE_READ_ONLY(32, ErrorType.USER_ERROR),
    HIVE_PARTITION_NOT_READABLE(33, ErrorType.USER_ERROR),
    HIVE_TABLE_NOT_READABLE(34, ErrorType.USER_ERROR),
    HIVE_TABLE_DROPPED_DURING_QUERY(35, ErrorType.EXTERNAL),
    HIVE_CORRUPTED_COLUMN_STATISTICS(37, ErrorType.EXTERNAL),
    HIVE_EXCEEDED_SPLIT_BUFFERING_LIMIT(38, ErrorType.USER_ERROR),
    HIVE_UNKNOWN_COLUMN_STATISTIC_TYPE(39, ErrorType.INTERNAL_ERROR),
    HIVE_TABLE_BUCKETING_IS_IGNORED(40, ErrorType.USER_ERROR),
    HIVE_TRANSACTION_NOT_FOUND(41, ErrorType.INTERNAL_ERROR),
    HIVE_INVALID_ENCRYPTION_METADATA(42, ErrorType.EXTERNAL);

    private final ErrorCode errorCode;
    public static final int ERROR_CODE_MASK = 0x1000000;

    private HiveErrorCode(int code, ErrorType type) {
        this.errorCode = new ErrorCode(code + 0x1000000, this.name(), type);
    }

    public ErrorCode toErrorCode() {
        return this.errorCode;
    }
}

