/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.CacheQuota;
import java.util.Objects;
import java.util.Optional;

public class HiveFileContext {
    public static final HiveFileContext DEFAULT_HIVE_FILE_CONTEXT = new HiveFileContext(true, CacheQuota.NO_CACHE_CONSTRAINTS, Optional.empty());
    private final boolean cacheable;
    private final CacheQuota cacheQuota;
    private final Optional<ExtraHiveFileInfo<?>> extraFileInfo;

    public HiveFileContext(boolean cacheable, CacheQuota cacheQuota, Optional<ExtraHiveFileInfo<?>> extraFileInfo) {
        this.cacheable = cacheable;
        this.cacheQuota = Objects.requireNonNull(cacheQuota, "cacheQuota is null");
        this.extraFileInfo = Objects.requireNonNull(extraFileInfo, "extraFileInfo is null");
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public CacheQuota getCacheQuota() {
        return this.cacheQuota;
    }

    public Optional<ExtraHiveFileInfo<?>> getExtraFileInfo() {
        return this.extraFileInfo;
    }

    public static interface ExtraHiveFileInfo<T> {
        public T getExtraFileInfo();
    }
}

