/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.expressions.translator;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.function.QualifiedFunctionName;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.spi.function.FunctionImplementationType;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlType;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

class TranslatorAnnotationParser {
    private TranslatorAnnotationParser() {
    }

    public static Map<FunctionMetadata, MethodHandle> parseFunctionDefinitions(Class<?> clazz) {
        ImmutableMap.Builder translatorBuilder = ImmutableMap.builder();
        for (ScalarHeaderAndMethods methods : TranslatorAnnotationParser.findScalarsFromSetClass(clazz)) {
            translatorBuilder.putAll(TranslatorAnnotationParser.scalarToFunctionMetadata(methods));
        }
        return translatorBuilder.build();
    }

    private static TypeSignature removeTypeParameters(TypeSignature typeSignature) {
        return new TypeSignature(typeSignature.getBase(), new TypeSignatureParameter[0]);
    }

    public static FunctionMetadata removeTypeParameters(FunctionMetadata metadata) {
        ImmutableList.Builder argumentsBuilder = ImmutableList.builder();
        for (TypeSignature typeSignature : metadata.getArgumentTypes()) {
            argumentsBuilder.add((Object)TranslatorAnnotationParser.removeTypeParameters(typeSignature));
        }
        if (metadata.getOperatorType().isPresent()) {
            return new FunctionMetadata((OperatorType)metadata.getOperatorType().get(), (List)argumentsBuilder.build(), metadata.getReturnType(), metadata.getFunctionKind(), metadata.getImplementationType(), metadata.isDeterministic(), metadata.isCalledOnNullInput());
        }
        return new FunctionMetadata(metadata.getName(), (List)argumentsBuilder.build(), Optional.empty(), metadata.getReturnType(), metadata.getFunctionKind(), metadata.getImplementationType(), metadata.isDeterministic(), metadata.isCalledOnNullInput());
    }

    private static MethodHandle getMethodHandle(Method method) {
        try {
            return MethodHandles.lookup().unreflect(method);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<ScalarHeaderAndMethods> findScalarsFromSetClass(Class<?> clazz) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Method method : TranslatorAnnotationParser.findPublicMethodsWithAnnotation(clazz, SqlType.class, ScalarFunction.class, ScalarOperator.class)) {
            boolean annotationCondition = method.getAnnotation(ScalarFunction.class) != null || method.getAnnotation(ScalarOperator.class) != null;
            Preconditions.checkArgument((boolean)annotationCondition, (Object)String.format("Method [%s] annotated with @SqlType is missing @ScalarFunction or @ScalarOperator", method));
            for (ScalarTranslationHeader header : ScalarTranslationHeader.fromAnnotatedElement(method)) {
                builder.add((Object)new ScalarHeaderAndMethods(header, (Set<Method>)ImmutableSet.of((Object)method)));
            }
        }
        ImmutableList methods = builder.build();
        Preconditions.checkArgument((!methods.isEmpty() ? 1 : 0) != 0, (String)"Class [%s] does not have any methods annotated with @ScalarFunction or @ScalarOperator", (Object)clazz.getName());
        return methods;
    }

    private static Map<FunctionMetadata, MethodHandle> scalarToFunctionMetadata(ScalarHeaderAndMethods scalar) {
        ScalarTranslationHeader header = scalar.getHeader();
        ImmutableMap.Builder metadataBuilder = ImmutableMap.builder();
        for (Method method : scalar.getMethods()) {
            FunctionMetadata metadata = TranslatorAnnotationParser.methodToFunctionMetadata(header, method);
            metadataBuilder.put((Object)TranslatorAnnotationParser.removeTypeParameters(metadata), (Object)TranslatorAnnotationParser.getMethodHandle(method));
        }
        return metadataBuilder.build();
    }

    private static FunctionMetadata methodToFunctionMetadata(ScalarTranslationHeader header, Method method) {
        Objects.requireNonNull(header, "header is null");
        SqlType annotatedReturnType = method.getAnnotation(SqlType.class);
        Preconditions.checkArgument((annotatedReturnType != null ? 1 : 0) != 0, (Object)String.format("Method [%s] is missing @SqlType annotation", method));
        TypeSignature returnType = TypeSignature.parseTypeSignature((String)annotatedReturnType.value(), (Set)ImmutableSet.of());
        ImmutableList.Builder argumentTypes = new ImmutableList.Builder();
        for (Parameter parameter : method.getParameters()) {
            Annotation[] annotations = parameter.getAnnotations();
            SqlType type = Stream.of(annotations).filter(SqlType.class::isInstance).map(SqlType.class::cast).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Method [%s] is missing @SqlType annotation for parameter", method)));
            TypeSignature typeSignature = TypeSignature.parseTypeSignature((String)type.value(), (Set)ImmutableSet.of());
            argumentTypes.add((Object)typeSignature);
        }
        if (header.getOperatorType().isPresent()) {
            return new FunctionMetadata(header.getOperatorType().get(), (List)argumentTypes.build(), returnType, FunctionKind.SCALAR, FunctionImplementationType.BUILTIN, header.isDeterministic(), header.isCalledOnNullInput());
        }
        return new FunctionMetadata(header.getName(), (List)argumentTypes.build(), Optional.empty(), returnType, FunctionKind.SCALAR, FunctionImplementationType.BUILTIN, header.isDeterministic(), header.isCalledOnNullInput());
    }

    @SafeVarargs
    private static Set<Method> findPublicMethodsWithAnnotation(Class<?> clazz, Class<? extends Annotation> ... annotationClasses) {
        ImmutableSet.Builder methods = ImmutableSet.builder();
        for (Method method : clazz.getDeclaredMethods()) {
            for (Annotation annotation : method.getAnnotations()) {
                for (Class<? extends Annotation> annotationClass : annotationClasses) {
                    if (!annotationClass.isInstance(annotation)) continue;
                    Preconditions.checkArgument((boolean)Modifier.isPublic(method.getModifiers()), (String)"Method [%s] annotated with @%s must be public", (Object)method, (Object)annotationClass.getSimpleName());
                    methods.add((Object)method);
                }
            }
        }
        return methods.build();
    }

    private static class ScalarTranslationHeader {
        private final QualifiedFunctionName name;
        private final Optional<OperatorType> operatorType;
        private final boolean deterministic;
        private final boolean calledOnNullInput;

        public static List<ScalarTranslationHeader> fromAnnotatedElement(AnnotatedElement annotated) {
            ImmutableList result;
            ScalarFunction scalarFunction = annotated.getAnnotation(ScalarFunction.class);
            ScalarOperator scalarOperator = annotated.getAnnotation(ScalarOperator.class);
            ImmutableList.Builder builder = ImmutableList.builder();
            if (scalarFunction != null) {
                String baseName = scalarFunction.value().isEmpty() ? ScalarTranslationHeader.camelToSnake(ScalarTranslationHeader.annotatedName(annotated)) : scalarFunction.value();
                builder.add((Object)new ScalarTranslationHeader(baseName, scalarFunction.deterministic(), scalarFunction.calledOnNullInput()));
                for (String alias : scalarFunction.alias()) {
                    builder.add((Object)new ScalarTranslationHeader(alias, scalarFunction.deterministic(), scalarFunction.calledOnNullInput()));
                }
            }
            if (scalarOperator != null) {
                builder.add((Object)new ScalarTranslationHeader(scalarOperator.value(), true, scalarOperator.value().isCalledOnNullInput()));
            }
            Preconditions.checkArgument((!(result = builder.build()).isEmpty() ? 1 : 0) != 0);
            return result;
        }

        private ScalarTranslationHeader(String name, boolean deterministic, boolean calledOnNullInput) {
            this.name = Objects.requireNonNull(QualifiedFunctionName.of((CatalogSchemaName)new CatalogSchemaName("presto", "default"), (String)name));
            this.operatorType = Optional.empty();
            this.deterministic = deterministic;
            this.calledOnNullInput = calledOnNullInput;
        }

        private ScalarTranslationHeader(OperatorType operatorType, boolean deterministic, boolean calledOnNullInput) {
            this.name = operatorType.getFunctionName();
            this.operatorType = Optional.of(operatorType);
            this.deterministic = deterministic;
            this.calledOnNullInput = calledOnNullInput;
        }

        private static String annotatedName(AnnotatedElement annotatedElement) {
            if (annotatedElement instanceof Class) {
                return ((Class)annotatedElement).getSimpleName();
            }
            if (annotatedElement instanceof Method) {
                return ((Method)annotatedElement).getName();
            }
            throw new UnsupportedOperationException("Only Classes and Methods are supported as annotated elements.");
        }

        private static String camelToSnake(String name) {
            return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name);
        }

        QualifiedFunctionName getName() {
            return this.name;
        }

        Optional<OperatorType> getOperatorType() {
            return this.operatorType;
        }

        boolean isDeterministic() {
            return this.deterministic;
        }

        boolean isCalledOnNullInput() {
            return this.calledOnNullInput;
        }
    }

    private static class ScalarHeaderAndMethods {
        private final ScalarTranslationHeader header;
        private final Set<Method> methods;

        public ScalarHeaderAndMethods(ScalarTranslationHeader header, Set<Method> methods) {
            this.header = Objects.requireNonNull(header, "header is null");
            this.methods = Objects.requireNonNull(methods, "methods are null");
        }

        public ScalarTranslationHeader getHeader() {
            return this.header;
        }

        public Set<Method> getMethods() {
            return this.methods;
        }
    }
}

