/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hadoop.$internal.org.apache.http.protocol;

import com.facebook.presto.hadoop.;
import com.facebook.presto.hadoop.$internal.org.apache.http.HttpConnection;
import com.facebook.presto.hadoop.$internal.org.apache.http.HttpException;
import com.facebook.presto.hadoop.$internal.org.apache.http.HttpHost;
import com.facebook.presto.hadoop.$internal.org.apache.http.HttpInetConnection;
import com.facebook.presto.hadoop.$internal.org.apache.http.HttpRequest;
import com.facebook.presto.hadoop.$internal.org.apache.http.HttpRequestInterceptor;
import com.facebook.presto.hadoop.$internal.org.apache.http.HttpVersion;
import com.facebook.presto.hadoop.$internal.org.apache.http.ProtocolException;
import com.facebook.presto.hadoop.$internal.org.apache.http.ProtocolVersion;
import com.facebook.presto.hadoop.$internal.org.apache.http.protocol.HttpContext;
import java.io.IOException;
import java.net.InetAddress;

@.Immutable
public class RequestTargetHost
implements HttpRequestInterceptor {
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targethost = (HttpHost)context.getAttribute("http.target_host");
            if (targethost == null) {
                HttpConnection conn = (HttpConnection)context.getAttribute("http.connection");
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targethost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targethost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targethost.toHostString());
        }
    }
}

