/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.session;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;

public final class PropertyMetadata<T> {
    private final String name;
    private final String description;
    private final Type sqlType;
    private final Class<T> javaType;
    private final T defaultValue;
    private final boolean hidden;
    private final Function<Object, T> decoder;
    private final Function<T, Object> encoder;

    public PropertyMetadata(String name, String description, Type sqlType, Class<T> javaType, T defaultValue, boolean hidden, Function<Object, T> decoder, Function<T, Object> encoder) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(description, "description is null");
        Objects.requireNonNull(sqlType, "type is null");
        Objects.requireNonNull(javaType, "javaType is null");
        Objects.requireNonNull(decoder, "decoder is null");
        Objects.requireNonNull(encoder, "encoder is null");
        if (name.isEmpty() || !name.trim().toLowerCase(Locale.ENGLISH).equals(name)) {
            throw new IllegalArgumentException(String.format("Invalid property name '%s'", name));
        }
        if (description.isEmpty() || !description.trim().equals(description)) {
            throw new IllegalArgumentException(String.format("Invalid property description '%s'", description));
        }
        this.name = name;
        this.description = description;
        this.javaType = javaType;
        this.sqlType = sqlType;
        this.defaultValue = defaultValue;
        this.hidden = hidden;
        this.decoder = decoder;
        this.encoder = encoder;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Type getSqlType() {
        return this.sqlType;
    }

    public Class<T> getJavaType() {
        return this.javaType;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public T decode(Object value) {
        return this.decoder.apply(value);
    }

    public Object encode(T value) {
        return this.encoder.apply(value);
    }

    public static PropertyMetadata<Boolean> booleanProperty(String name, String description, Boolean defaultValue, boolean hidden) {
        return new PropertyMetadata<Boolean>(name, description, (Type)BooleanType.BOOLEAN, Boolean.class, defaultValue, hidden, Boolean.class::cast, object -> object);
    }

    public static PropertyMetadata<Integer> integerProperty(String name, String description, Integer defaultValue, boolean hidden) {
        return new PropertyMetadata<Integer>(name, description, (Type)IntegerType.INTEGER, Integer.class, defaultValue, hidden, value -> ((Number)value).intValue(), object -> object);
    }

    public static PropertyMetadata<Long> longProperty(String name, String description, Long defaultValue, boolean hidden) {
        return new PropertyMetadata<Long>(name, description, (Type)BigintType.BIGINT, Long.class, defaultValue, hidden, value -> ((Number)value).longValue(), object -> object);
    }

    public static PropertyMetadata<Double> doubleProperty(String name, String description, Double defaultValue, boolean hidden) {
        return new PropertyMetadata<Double>(name, description, (Type)DoubleType.DOUBLE, Double.class, defaultValue, hidden, value -> ((Number)value).doubleValue(), object -> object);
    }

    public static PropertyMetadata<String> stringProperty(String name, String description, String defaultValue, boolean hidden) {
        return new PropertyMetadata<String>(name, description, (Type)VarcharType.VARCHAR, String.class, defaultValue, hidden, String.class::cast, object -> object);
    }
}

