/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.thrift;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.drift.transport.netty.client.DriftNettyClientModule;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.connector.thrift.ThriftConnector;
import com.facebook.presto.connector.thrift.ThriftHandleResolver;
import com.facebook.presto.connector.thrift.ThriftModule;
import com.facebook.presto.connector.thrift.util.RebindSafeMBeanServer;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorContext;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.google.common.base.Throwables;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.Objects;
import javax.management.MBeanServer;
import org.weakref.jmx.guice.MBeanModule;

public class ThriftConnectorFactory
implements ConnectorFactory {
    private final String name;
    private final Module locationModule;

    public ThriftConnectorFactory(String name, Module locationModule) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.locationModule = Objects.requireNonNull(locationModule, "locationModule is null");
    }

    public String getName() {
        return this.name;
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new ThriftHandleResolver();
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        try {
            Bootstrap app = new Bootstrap(new Module[]{new MBeanModule(), new DriftNettyClientModule(), binder -> {
                binder.bind(MBeanServer.class).toInstance((Object)new RebindSafeMBeanServer(ManagementFactory.getPlatformMBeanServer()));
                binder.bind(TypeManager.class).toInstance((Object)context.getTypeManager());
            }, this.locationModule, new ThriftModule(catalogName)});
            Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            return (Connector)injector.getInstance(ThriftConnector.class);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

