/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.presto.common.block.ArrayBlockEncoding;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockEncoding;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.block.ByteArrayBlockEncoding;
import com.facebook.presto.common.block.DictionaryBlockEncoding;
import com.facebook.presto.common.block.Int128ArrayBlockEncoding;
import com.facebook.presto.common.block.IntArrayBlockEncoding;
import com.facebook.presto.common.block.LazyBlockEncoding;
import com.facebook.presto.common.block.LongArrayBlockEncoding;
import com.facebook.presto.common.block.MapBlockEncoding;
import com.facebook.presto.common.block.RowBlockEncoding;
import com.facebook.presto.common.block.RunLengthBlockEncoding;
import com.facebook.presto.common.block.ShortArrayBlockEncoding;
import com.facebook.presto.common.block.SingleMapBlockEncoding;
import com.facebook.presto.common.block.SingleRowBlockEncoding;
import com.facebook.presto.common.block.VariableWidthBlockEncoding;
import com.facebook.presto.common.type.TypeManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;

public final class BlockEncodingManager
implements BlockEncodingSerde {
    private final ConcurrentMap<String, BlockEncoding> blockEncodings = new ConcurrentHashMap<String, BlockEncoding>();

    public BlockEncodingManager(TypeManager typeManager, BlockEncoding ... blockEncodings) {
        this(typeManager, (Set<BlockEncoding>)ImmutableSet.copyOf((Object[])blockEncodings));
    }

    @Inject
    public BlockEncodingManager(TypeManager typeManager, Set<BlockEncoding> blockEncodings) {
        this.addBlockEncoding((BlockEncoding)new VariableWidthBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new ByteArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new ShortArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new IntArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new LongArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new Int128ArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new DictionaryBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new ArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new MapBlockEncoding(typeManager));
        this.addBlockEncoding((BlockEncoding)new SingleMapBlockEncoding(typeManager));
        this.addBlockEncoding((BlockEncoding)new RowBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new SingleRowBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new RunLengthBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new LazyBlockEncoding());
        for (BlockEncoding blockEncoding : Objects.requireNonNull(blockEncodings, "blockEncodings is null")) {
            this.addBlockEncoding(blockEncoding);
        }
    }

    public void addBlockEncoding(BlockEncoding blockEncoding) {
        Objects.requireNonNull(blockEncoding, "blockEncoding is null");
        BlockEncoding existingEntry = this.blockEncodings.putIfAbsent(blockEncoding.getName(), blockEncoding);
        Preconditions.checkArgument((existingEntry == null ? 1 : 0) != 0, (String)"Encoding %s is already registered", (Object)blockEncoding.getName());
    }

    public Block readBlock(SliceInput input) {
        String encodingName = BlockEncodingManager.readLengthPrefixedString(input);
        BlockEncoding blockEncoding = (BlockEncoding)this.blockEncodings.get(encodingName);
        Preconditions.checkArgument((blockEncoding != null ? 1 : 0) != 0, (String)"Unknown block encoding %s", (Object)encodingName);
        return blockEncoding.readBlock((BlockEncodingSerde)this, input);
    }

    public void writeBlock(SliceOutput output, Block block) {
        String encodingName;
        BlockEncoding blockEncoding;
        Optional replacementBlock;
        while ((replacementBlock = (blockEncoding = (BlockEncoding)this.blockEncodings.get(encodingName = block.getEncodingName())).replacementBlockForWrite(block)).isPresent()) {
            block = (Block)replacementBlock.get();
        }
        BlockEncodingManager.writeLengthPrefixedString(output, encodingName);
        blockEncoding.writeBlock((BlockEncodingSerde)this, output, block);
    }

    private static String readLengthPrefixedString(SliceInput input) {
        int length = input.readInt();
        byte[] bytes = new byte[length];
        input.readBytes(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static void writeLengthPrefixedString(SliceOutput output, String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        output.writeInt(bytes.length);
        output.writeBytes(bytes);
    }
}

