/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.dispatcher;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.http.client.HttpUriBuilder;
import com.facebook.airlift.http.server.AsyncResponseHandler;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.client.QueryError;
import com.facebook.presto.client.QueryResults;
import com.facebook.presto.client.StatementStats;
import com.facebook.presto.dispatcher.CoordinatorLocation;
import com.facebook.presto.dispatcher.DispatchExecutor;
import com.facebook.presto.dispatcher.DispatchInfo;
import com.facebook.presto.dispatcher.DispatchManager;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.server.HttpRequestSessionContext;
import com.facebook.presto.server.SessionContext;
import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/")
public class QueuedStatementResource {
    private static final Logger log = Logger.get(QueuedStatementResource.class);
    private static final Duration MAX_WAIT_TIME = new Duration(1.0, TimeUnit.SECONDS);
    private static final Ordering<Comparable<Duration>> WAIT_ORDERING = Ordering.natural().nullsLast();
    private static final Duration NO_DURATION = new Duration(0.0, TimeUnit.MILLISECONDS);
    private final DispatchManager dispatchManager;
    private final Executor responseExecutor;
    private final ScheduledExecutorService timeoutExecutor;
    private final ConcurrentMap<QueryId, Query> queries = new ConcurrentHashMap<QueryId, Query>();
    private final ScheduledExecutorService queryPurger = Executors.newSingleThreadScheduledExecutor(Threads.threadsNamed((String)"dispatch-query-purger"));

    @Inject
    public QueuedStatementResource(DispatchManager dispatchManager, DispatchExecutor executor) {
        this.dispatchManager = Objects.requireNonNull(dispatchManager, "dispatchManager is null");
        Objects.requireNonNull(dispatchManager, "dispatchManager is null");
        this.responseExecutor = Objects.requireNonNull(executor, "responseExecutor is null").getExecutor();
        this.timeoutExecutor = Objects.requireNonNull(executor, "timeoutExecutor is null").getScheduledExecutor();
        this.queryPurger.scheduleWithFixedDelay(() -> {
            try {
                for (Map.Entry entry : ImmutableSet.copyOf(this.queries.entrySet())) {
                    if (!((Query)entry.getValue()).isSubmissionFinished() || dispatchManager.isQueryPresent((QueryId)entry.getKey())) continue;
                    this.queries.remove(entry.getKey());
                }
            }
            catch (Throwable e) {
                log.warn(e, "Error removing old queries");
            }
        }, 200L, 200L, TimeUnit.MILLISECONDS);
    }

    @PreDestroy
    public void stop() {
        this.queryPurger.shutdownNow();
    }

    @POST
    @Path(value="/v1/statement")
    @Produces(value={"application/json"})
    public Response postStatement(String statement, @HeaderParam(value="X-Forwarded-Proto") String xForwardedProto, @Context HttpServletRequest servletRequest, @Context UriInfo uriInfo) {
        if (Strings.isNullOrEmpty((String)statement)) {
            throw QueuedStatementResource.badRequest(Response.Status.BAD_REQUEST, "SQL statement is empty");
        }
        HttpRequestSessionContext sessionContext = new HttpRequestSessionContext(servletRequest);
        Query query = new Query(statement, sessionContext, this.dispatchManager);
        this.queries.put(query.getQueryId(), query);
        return Response.ok((Object)query.getQueryResults(query.getLastToken(), uriInfo, xForwardedProto)).build();
    }

    @GET
    @Path(value="/v1/statement/queued/{queryId}/{token}")
    @Produces(value={"application/json"})
    public void getStatus(@PathParam(value="queryId") QueryId queryId, @PathParam(value="token") long token, @QueryParam(value="slug") String slug, @QueryParam(value="maxWait") Duration maxWait, @HeaderParam(value="X-Forwarded-Proto") String xForwardedProto, @Context UriInfo uriInfo, @Suspended AsyncResponse asyncResponse) {
        Query query = this.getQuery(queryId, slug);
        ListenableFuture futureStateChange = MoreFutures.addTimeout((ListenableFuture)query.waitForDispatched(), () -> null, (Duration)((Duration)WAIT_ORDERING.min((Object)MAX_WAIT_TIME, (Object)maxWait)), (ScheduledExecutorService)this.timeoutExecutor);
        ListenableFuture queryResultsFuture = Futures.transform((ListenableFuture)futureStateChange, ignored -> query.getQueryResults(token, uriInfo, xForwardedProto), (Executor)this.responseExecutor);
        ListenableFuture response = Futures.transform((ListenableFuture)queryResultsFuture, queryResults -> Response.ok((Object)queryResults).build(), (Executor)MoreExecutors.directExecutor());
        AsyncResponseHandler.bindAsyncResponse((AsyncResponse)asyncResponse, (ListenableFuture)response, (Executor)this.responseExecutor);
    }

    @DELETE
    @Path(value="/v1/statement/queued/{queryId}/{token}")
    @Produces(value={"application/json"})
    public Response cancelQuery(@PathParam(value="queryId") QueryId queryId, @PathParam(value="token") long token, @QueryParam(value="slug") String slug) {
        this.getQuery(queryId, slug).cancel();
        return Response.noContent().build();
    }

    private Query getQuery(QueryId queryId, String slug) {
        Query query = (Query)this.queries.get(queryId);
        if (query == null || !query.getSlug().equals(slug)) {
            throw QueuedStatementResource.badRequest(Response.Status.NOT_FOUND, "Query not found");
        }
        return query;
    }

    private static URI getQueryHtmlUri(QueryId queryId, UriInfo uriInfo, String xForwardedProto) {
        return uriInfo.getRequestUriBuilder().scheme(QueuedStatementResource.getScheme(xForwardedProto, uriInfo)).replacePath("ui/query.html").replaceQuery(queryId.toString()).build(new Object[0]);
    }

    private static URI getQueuedUri(QueryId queryId, String slug, long token, UriInfo uriInfo, String xForwardedProto) {
        return uriInfo.getBaseUriBuilder().scheme(QueuedStatementResource.getScheme(xForwardedProto, uriInfo)).replacePath("/v1/statement/queued/").path(queryId.toString()).path(String.valueOf(token)).replaceQuery("").queryParam("slug", new Object[]{slug}).build(new Object[0]);
    }

    private static String getScheme(String xForwardedProto, @Context UriInfo uriInfo) {
        return Strings.isNullOrEmpty((String)xForwardedProto) ? uriInfo.getRequestUri().getScheme() : xForwardedProto;
    }

    private static QueryResults createQueryResults(QueryId queryId, URI nextUri, Optional<QueryError> queryError, UriInfo uriInfo, String xForwardedProto, Duration elapsedTime, Duration queuedTime) {
        QueryState state = queryError.map(error -> QueryState.FAILED).orElse(QueryState.QUEUED);
        return new QueryResults(queryId.toString(), QueuedStatementResource.getQueryHtmlUri(queryId, uriInfo, xForwardedProto), null, nextUri, null, null, StatementStats.builder().setState(state.toString()).setQueued(state == QueryState.QUEUED).setElapsedTimeMillis(elapsedTime.toMillis()).setQueuedTimeMillis(queuedTime.toMillis()).build(), (QueryError)queryError.orElse(null), (List)ImmutableList.of(), null, null);
    }

    private static WebApplicationException badRequest(Response.Status status, String message) {
        throw new WebApplicationException(Response.status((Response.Status)status).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)message).build());
    }

    private static final class Query {
        private final String query;
        private final SessionContext sessionContext;
        private final DispatchManager dispatchManager;
        private final QueryId queryId;
        private final String slug = "x" + UUID.randomUUID().toString().toLowerCase(Locale.ENGLISH).replace("-", "");
        private final AtomicLong lastToken = new AtomicLong();
        @GuardedBy(value="this")
        private ListenableFuture<?> querySubmissionFuture;

        public Query(String query, SessionContext sessionContext, DispatchManager dispatchManager) {
            this.query = Objects.requireNonNull(query, "query is null");
            this.sessionContext = Objects.requireNonNull(sessionContext, "sessionContext is null");
            this.dispatchManager = Objects.requireNonNull(dispatchManager, "dispatchManager is null");
            this.queryId = dispatchManager.createQueryId();
        }

        public QueryId getQueryId() {
            return this.queryId;
        }

        public String getSlug() {
            return this.slug;
        }

        public long getLastToken() {
            return this.lastToken.get();
        }

        public synchronized boolean isSubmissionFinished() {
            return this.querySubmissionFuture != null && this.querySubmissionFuture.isDone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ListenableFuture<?> waitForDispatched() {
            Query query = this;
            synchronized (query) {
                if (this.querySubmissionFuture == null) {
                    this.querySubmissionFuture = this.dispatchManager.createQuery(this.queryId, this.slug, this.sessionContext, this.query);
                }
                if (!this.querySubmissionFuture.isDone()) {
                    return this.querySubmissionFuture;
                }
            }
            return this.dispatchManager.waitForDispatched(this.queryId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public QueryResults getQueryResults(long token, UriInfo uriInfo, String xForwardedProto) {
            long lastToken = this.lastToken.get();
            if (token != lastToken && token != lastToken + 1L) {
                throw new WebApplicationException(Response.Status.GONE);
            }
            this.lastToken.compareAndSet(lastToken, token);
            Query query = this;
            synchronized (query) {
                if (this.querySubmissionFuture == null || !this.querySubmissionFuture.isDone()) {
                    return this.createQueryResults(token + 1L, uriInfo, xForwardedProto, DispatchInfo.queued(NO_DURATION, NO_DURATION));
                }
            }
            Optional<DispatchInfo> dispatchInfo = this.dispatchManager.getDispatchInfo(this.queryId);
            if (!dispatchInfo.isPresent()) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).build());
            }
            return this.createQueryResults(token + 1L, uriInfo, xForwardedProto, dispatchInfo.get());
        }

        public synchronized void cancel() {
            this.querySubmissionFuture.addListener(() -> this.dispatchManager.cancelQuery(this.queryId), MoreExecutors.directExecutor());
        }

        private QueryResults createQueryResults(long token, UriInfo uriInfo, String xForwardedProto, DispatchInfo dispatchInfo) {
            URI nextUri = this.getNextUri(token, uriInfo, xForwardedProto, dispatchInfo);
            Optional<QueryError> queryError = dispatchInfo.getFailureInfo().map(this::toQueryError);
            return QueuedStatementResource.createQueryResults(this.queryId, nextUri, queryError, uriInfo, xForwardedProto, dispatchInfo.getElapsedTime(), dispatchInfo.getQueuedTime());
        }

        private URI getNextUri(long token, UriInfo uriInfo, String xForwardedProto, DispatchInfo dispatchInfo) {
            if (dispatchInfo.getFailureInfo().isPresent()) {
                return null;
            }
            return dispatchInfo.getCoordinatorLocation().map(coordinatorLocation -> this.getRedirectUri((CoordinatorLocation)coordinatorLocation, uriInfo, xForwardedProto)).orElseGet(() -> QueuedStatementResource.getQueuedUri(this.queryId, this.slug, token, uriInfo, xForwardedProto));
        }

        private URI getRedirectUri(CoordinatorLocation coordinatorLocation, UriInfo uriInfo, String xForwardedProto) {
            URI coordinatorUri = coordinatorLocation.getUri(uriInfo, xForwardedProto);
            return HttpUriBuilder.uriBuilderFrom((URI)coordinatorUri).appendPath("/v1/statement/executing").appendPath(this.queryId.toString()).appendPath("0").addParameter("slug", new String[]{this.slug}).build();
        }

        private QueryError toQueryError(ExecutionFailureInfo executionFailureInfo) {
            ErrorCode errorCode;
            if (executionFailureInfo.getErrorCode() != null) {
                errorCode = executionFailureInfo.getErrorCode();
            } else {
                errorCode = StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode();
                log.warn("Failed query %s has no error code", new Object[]{this.queryId});
            }
            return new QueryError((String)MoreObjects.firstNonNull((Object)executionFailureInfo.getMessage(), (Object)"Internal error"), null, errorCode.getCode(), errorCode.getName(), errorCode.getType().toString(), executionFailureInfo.getErrorLocation(), executionFailureInfo.toFailureInfo());
        }
    }
}

