/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.TaskState;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class TaskStatus {
    public static final long STARTING_VERSION = 1L;
    private static final long MIN_VERSION = 0L;
    private static final long MAX_VERSION = Long.MAX_VALUE;
    private final long taskInstanceIdLeastSignificantBits;
    private final long taskInstanceIdMostSignificantBits;
    private final long version;
    private final TaskState state;
    private final URI self;
    private final Set<Lifespan> completedDriverGroups;
    private final int queuedPartitionedDrivers;
    private final int runningPartitionedDrivers;
    private final double outputBufferUtilization;
    private final boolean outputBufferOverutilized;
    private final long physicalWrittenDataSizeInBytes;
    private final long memoryReservationInBytes;
    private final long systemMemoryReservationInBytes;
    private final long fullGcCount;
    private final long fullGcTimeInMillis;
    private final List<ExecutionFailureInfo> failures;

    @JsonCreator
    public TaskStatus(@JsonProperty(value="taskInstanceIdLeastSignificantBits") long taskInstanceIdLeastSignificantBits, @JsonProperty(value="taskInstanceIdMostSignificantBits") long taskInstanceIdMostSignificantBits, @JsonProperty(value="version") long version, @JsonProperty(value="state") TaskState state, @JsonProperty(value="self") URI self, @JsonProperty(value="completedDriverGroups") Set<Lifespan> completedDriverGroups, @JsonProperty(value="failures") List<ExecutionFailureInfo> failures, @JsonProperty(value="queuedPartitionedDrivers") int queuedPartitionedDrivers, @JsonProperty(value="runningPartitionedDrivers") int runningPartitionedDrivers, @JsonProperty(value="outputBufferUtilization") double outputBufferUtilization, @JsonProperty(value="outputBufferOverutilized") boolean outputBufferOverutilized, @JsonProperty(value="physicalWrittenDataSizeInBytes") long physicalWrittenDataSizeInBytes, @JsonProperty(value="memoryReservationInBytes") long memoryReservationInBytes, @JsonProperty(value="systemMemoryReservationInBytes") long systemMemoryReservationInBytes, @JsonProperty(value="fullGcCount") long fullGcCount, @JsonProperty(value="fullGcTimeInMillis") long fullGcTimeInMillis) {
        this.taskInstanceIdLeastSignificantBits = taskInstanceIdLeastSignificantBits;
        this.taskInstanceIdMostSignificantBits = taskInstanceIdMostSignificantBits;
        Preconditions.checkState((version >= 0L ? 1 : 0) != 0, (Object)"version must be >= MIN_VERSION");
        this.version = version;
        this.state = Objects.requireNonNull(state, "state is null");
        this.self = Objects.requireNonNull(self, "self is null");
        this.completedDriverGroups = Objects.requireNonNull(completedDriverGroups, "completedDriverGroups is null");
        Preconditions.checkArgument((queuedPartitionedDrivers >= 0 ? 1 : 0) != 0, (Object)"queuedPartitionedDrivers must be positive");
        this.queuedPartitionedDrivers = queuedPartitionedDrivers;
        Preconditions.checkArgument((runningPartitionedDrivers >= 0 ? 1 : 0) != 0, (Object)"runningPartitionedDrivers must be positive");
        this.runningPartitionedDrivers = runningPartitionedDrivers;
        this.outputBufferUtilization = outputBufferUtilization;
        this.outputBufferOverutilized = outputBufferOverutilized;
        this.physicalWrittenDataSizeInBytes = physicalWrittenDataSizeInBytes;
        this.memoryReservationInBytes = memoryReservationInBytes;
        this.systemMemoryReservationInBytes = systemMemoryReservationInBytes;
        this.failures = ImmutableList.copyOf((Collection)Objects.requireNonNull(failures, "failures is null"));
        Preconditions.checkArgument((fullGcCount >= 0L ? 1 : 0) != 0, (Object)"fullGcCount is negative");
        this.fullGcCount = fullGcCount;
        this.fullGcTimeInMillis = fullGcTimeInMillis;
    }

    @JsonProperty
    public long getTaskInstanceIdLeastSignificantBits() {
        return this.taskInstanceIdLeastSignificantBits;
    }

    @JsonProperty
    public long getTaskInstanceIdMostSignificantBits() {
        return this.taskInstanceIdMostSignificantBits;
    }

    @JsonProperty
    public long getVersion() {
        return this.version;
    }

    @JsonProperty
    public TaskState getState() {
        return this.state;
    }

    @JsonProperty
    public URI getSelf() {
        return this.self;
    }

    @JsonProperty
    public Set<Lifespan> getCompletedDriverGroups() {
        return this.completedDriverGroups;
    }

    @JsonProperty
    public List<ExecutionFailureInfo> getFailures() {
        return this.failures;
    }

    @JsonProperty
    public int getQueuedPartitionedDrivers() {
        return this.queuedPartitionedDrivers;
    }

    @JsonProperty
    public int getRunningPartitionedDrivers() {
        return this.runningPartitionedDrivers;
    }

    @JsonProperty
    public double getOutputBufferUtilization() {
        return this.outputBufferUtilization;
    }

    @JsonProperty
    public boolean isOutputBufferOverutilized() {
        return this.outputBufferOverutilized;
    }

    @JsonProperty
    public long getPhysicalWrittenDataSizeInBytes() {
        return this.physicalWrittenDataSizeInBytes;
    }

    @JsonProperty
    public long getMemoryReservationInBytes() {
        return this.memoryReservationInBytes;
    }

    @JsonProperty
    public long getSystemMemoryReservationInBytes() {
        return this.systemMemoryReservationInBytes;
    }

    @JsonProperty
    public long getFullGcCount() {
        return this.fullGcCount;
    }

    @JsonProperty
    public long getFullGcTimeInMillis() {
        return this.fullGcTimeInMillis;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("state", (Object)this.state).toString();
    }

    public static TaskStatus initialTaskStatus(URI location) {
        return new TaskStatus(0L, 0L, 0L, TaskState.PLANNED, location, (Set<Lifespan>)ImmutableSet.of(), (List<ExecutionFailureInfo>)ImmutableList.of(), 0, 0, 0.0, false, 0L, 0L, 0L, 0L, 0L);
    }

    public static TaskStatus failWith(TaskStatus taskStatus, TaskState state, List<ExecutionFailureInfo> exceptions) {
        return new TaskStatus(taskStatus.getTaskInstanceIdLeastSignificantBits(), taskStatus.getTaskInstanceIdMostSignificantBits(), Long.MAX_VALUE, state, taskStatus.getSelf(), taskStatus.getCompletedDriverGroups(), exceptions, taskStatus.getQueuedPartitionedDrivers(), taskStatus.getRunningPartitionedDrivers(), taskStatus.getOutputBufferUtilization(), taskStatus.isOutputBufferOverutilized(), taskStatus.getPhysicalWrittenDataSizeInBytes(), taskStatus.getMemoryReservationInBytes(), taskStatus.getSystemMemoryReservationInBytes(), taskStatus.getFullGcCount(), taskStatus.getFullGcTimeInMillis());
    }
}

