/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.QualifiedTablePrefix;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.security.GrantInfo;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public final class MetadataListing {
    private MetadataListing() {
    }

    public static SortedMap<String, ConnectorId> listCatalogs(Session session, Metadata metadata, AccessControl accessControl) {
        Map<String, ConnectorId> catalogNames = metadata.getCatalogNames(session);
        Set<String> allowedCatalogs = accessControl.filterCatalogs(session.getIdentity(), session.getAccessControlContext(), catalogNames.keySet());
        ImmutableSortedMap.Builder result = ImmutableSortedMap.naturalOrder();
        for (Map.Entry<String, ConnectorId> entry : catalogNames.entrySet()) {
            if (!allowedCatalogs.contains(entry.getKey())) continue;
            result.put(entry);
        }
        return result.build();
    }

    public static SortedSet<String> listSchemas(Session session, Metadata metadata, AccessControl accessControl, String catalogName) {
        ImmutableSet schemaNames = ImmutableSet.copyOf(metadata.listSchemaNames(session, catalogName));
        return ImmutableSortedSet.copyOf(accessControl.filterSchemas(session.getRequiredTransactionId(), session.getIdentity(), session.getAccessControlContext(), catalogName, (Set<String>)schemaNames));
    }

    public static Set<SchemaTableName> listTables(Session session, Metadata metadata, AccessControl accessControl, QualifiedTablePrefix prefix) {
        Set tableNames = (Set)metadata.listTables(session, prefix).stream().map(QualifiedObjectName::asSchemaTableName).collect(ImmutableSet.toImmutableSet());
        return accessControl.filterTables(session.getRequiredTransactionId(), session.getIdentity(), session.getAccessControlContext(), prefix.getCatalogName(), tableNames);
    }

    public static Set<SchemaTableName> listViews(Session session, Metadata metadata, AccessControl accessControl, QualifiedTablePrefix prefix) {
        Set tableNames = (Set)metadata.listViews(session, prefix).stream().map(QualifiedObjectName::asSchemaTableName).collect(ImmutableSet.toImmutableSet());
        return accessControl.filterTables(session.getRequiredTransactionId(), session.getIdentity(), session.getAccessControlContext(), prefix.getCatalogName(), tableNames);
    }

    public static Set<GrantInfo> listTablePrivileges(Session session, Metadata metadata, AccessControl accessControl, QualifiedTablePrefix prefix) {
        List<GrantInfo> grants = metadata.listTablePrivileges(session, prefix);
        Set<SchemaTableName> allowedTables = accessControl.filterTables(session.getRequiredTransactionId(), session.getIdentity(), session.getAccessControlContext(), prefix.getCatalogName(), (Set)grants.stream().map(GrantInfo::getSchemaTableName).collect(ImmutableSet.toImmutableSet()));
        return (Set)grants.stream().filter(grantInfo -> allowedTables.contains(grantInfo.getSchemaTableName())).collect(ImmutableSet.toImmutableSet());
    }

    public static Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(Session session, Metadata metadata, AccessControl accessControl, QualifiedTablePrefix prefix) {
        Map tableColumns = (Map)metadata.listTableColumns(session, prefix).entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((QualifiedObjectName)entry.getKey()).asSchemaTableName(), Map.Entry::getValue));
        Set<SchemaTableName> allowedTables = accessControl.filterTables(session.getRequiredTransactionId(), session.getIdentity(), session.getAccessControlContext(), prefix.getCatalogName(), tableColumns.keySet());
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Map.Entry entry2 : tableColumns.entrySet()) {
            if (!allowedTables.contains(entry2.getKey())) continue;
            result.put(entry2);
        }
        return result.build();
    }
}

