/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.http.client.HttpUriBuilder;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.operator.PageBufferClientStatus;
import com.facebook.presto.operator.PageTransportTimeoutException;
import com.facebook.presto.operator.RpcShuffleClient;
import com.facebook.presto.server.remotetask.Backoff;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.page.SerializedPage;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.DateTime;

@ThreadSafe
public final class PageBufferClient
implements Closeable {
    private static final Logger log = Logger.get(PageBufferClient.class);
    private final RpcShuffleClient resultClient;
    private final boolean acknowledgePages;
    private final URI location;
    private final Optional<URI> asyncPageTransportLocation;
    private final ClientCallback clientCallback;
    private final ScheduledExecutorService scheduler;
    private final Backoff backoff;
    @GuardedBy(value="this")
    private boolean closed;
    @GuardedBy(value="this")
    private ListenableFuture<?> future;
    @GuardedBy(value="this")
    private DateTime lastUpdate = DateTime.now();
    @GuardedBy(value="this")
    private long token;
    @GuardedBy(value="this")
    private boolean scheduled;
    @GuardedBy(value="this")
    private boolean completed;
    @GuardedBy(value="this")
    private String taskInstanceId;
    private final AtomicLong rowsReceived = new AtomicLong();
    private final AtomicInteger pagesReceived = new AtomicInteger();
    private final AtomicLong rowsRejected = new AtomicLong();
    private final AtomicInteger pagesRejected = new AtomicInteger();
    private final AtomicInteger requestsScheduled = new AtomicInteger();
    private final AtomicInteger requestsCompleted = new AtomicInteger();
    private final AtomicInteger requestsFailed = new AtomicInteger();
    private final Executor pageBufferClientCallbackExecutor;

    public PageBufferClient(RpcShuffleClient resultClient, Duration maxErrorDuration, boolean acknowledgePages, URI location, Optional<URI> asyncPageTransportLocation, ClientCallback clientCallback, ScheduledExecutorService scheduler, Executor pageBufferClientCallbackExecutor) {
        this(resultClient, maxErrorDuration, acknowledgePages, location, asyncPageTransportLocation, clientCallback, scheduler, Ticker.systemTicker(), pageBufferClientCallbackExecutor);
    }

    public PageBufferClient(RpcShuffleClient resultClient, Duration maxErrorDuration, boolean acknowledgePages, URI location, Optional<URI> asyncPageTransportLocation, ClientCallback clientCallback, ScheduledExecutorService scheduler, Ticker ticker, Executor pageBufferClientCallbackExecutor) {
        this.resultClient = Objects.requireNonNull(resultClient, "resultClient is null");
        this.acknowledgePages = acknowledgePages;
        this.location = Objects.requireNonNull(location, "location is null");
        this.asyncPageTransportLocation = Objects.requireNonNull(asyncPageTransportLocation, "asyncPageTransportLocation is null");
        this.clientCallback = Objects.requireNonNull(clientCallback, "clientCallback is null");
        this.scheduler = Objects.requireNonNull(scheduler, "scheduler is null");
        this.pageBufferClientCallbackExecutor = Objects.requireNonNull(pageBufferClientCallbackExecutor, "pageBufferClientCallbackExecutor is null");
        Objects.requireNonNull(maxErrorDuration, "maxErrorDuration is null");
        Objects.requireNonNull(ticker, "ticker is null");
        this.backoff = new Backoff(maxErrorDuration, ticker);
    }

    public synchronized PageBufferClientStatus getStatus() {
        String state = this.closed ? "closed" : (this.future != null ? "running" : (this.scheduled ? "scheduled" : (this.completed ? "completed" : "queued")));
        long rejectedRows = this.rowsRejected.get();
        int rejectedPages = this.pagesRejected.get();
        return new PageBufferClientStatus(this.location, state, this.lastUpdate, this.rowsReceived.get(), this.pagesReceived.get(), rejectedRows == 0L ? OptionalLong.empty() : OptionalLong.of(rejectedRows), rejectedPages == 0 ? OptionalInt.empty() : OptionalInt.of(rejectedPages), this.requestsScheduled.get(), this.requestsCompleted.get(), this.requestsFailed.get(), this.future == null ? "not scheduled" : "processing request");
    }

    public synchronized boolean isRunning() {
        return this.future != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ListenableFuture<?> future;
        boolean shouldSendDelete;
        PageBufferClient pageBufferClient = this;
        synchronized (pageBufferClient) {
            shouldSendDelete = !this.closed;
            this.closed = true;
            future = this.future;
            this.future = null;
            this.lastUpdate = DateTime.now();
        }
        if (future != null && !future.isDone()) {
            future.cancel(false);
        }
        if (shouldSendDelete) {
            this.sendDelete();
        }
    }

    public synchronized void scheduleRequest(DataSize maxResponseSize) {
        if (this.closed || this.future != null || this.scheduled) {
            return;
        }
        this.scheduled = true;
        this.backoff.startRequest();
        long delayNanos = this.backoff.getBackoffDelayNanos();
        this.scheduler.schedule(() -> {
            try {
                this.initiateRequest(maxResponseSize);
            }
            catch (Throwable t) {
                this.clientCallback.clientFailed(this, t);
            }
        }, delayNanos, TimeUnit.NANOSECONDS);
        this.lastUpdate = DateTime.now();
        this.requestsScheduled.incrementAndGet();
    }

    private synchronized void initiateRequest(DataSize maxResponseSize) {
        this.scheduled = false;
        if (this.closed || this.future != null) {
            return;
        }
        if (this.completed) {
            this.sendDelete();
        } else {
            this.sendGetResults(maxResponseSize);
        }
        this.lastUpdate = DateTime.now();
    }

    private synchronized void sendGetResults(DataSize maxResponseSize) {
        URI uriBase = this.asyncPageTransportLocation.orElse(this.location);
        final URI uri = HttpUriBuilder.uriBuilderFrom((URI)uriBase).appendPath(String.valueOf(this.token)).build();
        final ListenableFuture<PagesResponse> resultFuture = this.resultClient.getResults(this.token, maxResponseSize);
        this.future = resultFuture;
        Futures.addCallback(resultFuture, (FutureCallback)new FutureCallback<PagesResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(PagesResponse result) {
                Object pages;
                PageBufferClient.checkNotHoldsLock(this);
                PageBufferClient.this.backoff.success();
                try {
                    boolean shouldAcknowledge = false;
                    PageBufferClient pageBufferClient = PageBufferClient.this;
                    synchronized (pageBufferClient) {
                        if (PageBufferClient.this.taskInstanceId == null) {
                            PageBufferClient.this.taskInstanceId = result.getTaskInstanceId();
                        }
                        if (!Strings.isNullOrEmpty((String)PageBufferClient.this.taskInstanceId) && !result.getTaskInstanceId().equals(PageBufferClient.this.taskInstanceId)) {
                            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.REMOTE_TASK_MISMATCH, String.format("%s (%s)", "Could not communicate with the remote task. The node may have crashed or be under too much load. This is probably a transient issue, so please retry your query in a few minutes.", HostAddress.fromUri((URI)uri)));
                        }
                        if (result.getToken() == PageBufferClient.this.token) {
                            pages = result.getPages();
                            PageBufferClient.this.token = result.getNextToken();
                            shouldAcknowledge = pages.size() > 0;
                        } else {
                            pages = ImmutableList.of();
                        }
                    }
                    if (shouldAcknowledge && PageBufferClient.this.acknowledgePages) {
                        PageBufferClient.this.resultClient.acknowledgeResultsAsync(result.getNextToken());
                    }
                }
                catch (PrestoException e) {
                    PageBufferClient.this.handleFailure(e, resultFuture);
                    return;
                }
                if (PageBufferClient.this.clientCallback.addPages(PageBufferClient.this, (List<SerializedPage>)pages)) {
                    PageBufferClient.this.pagesReceived.addAndGet(pages.size());
                    PageBufferClient.this.rowsReceived.addAndGet(pages.stream().mapToLong(SerializedPage::getPositionCount).sum());
                } else {
                    PageBufferClient.this.pagesRejected.addAndGet(pages.size());
                    PageBufferClient.this.rowsRejected.addAndGet(pages.stream().mapToLong(SerializedPage::getPositionCount).sum());
                }
                PageBufferClient pageBufferClient = PageBufferClient.this;
                synchronized (pageBufferClient) {
                    if (result.isClientComplete()) {
                        PageBufferClient.this.completed = true;
                    }
                    if (PageBufferClient.this.future == resultFuture) {
                        PageBufferClient.this.future = null;
                    }
                    PageBufferClient.this.lastUpdate = DateTime.now();
                }
                PageBufferClient.this.requestsCompleted.incrementAndGet();
                PageBufferClient.this.clientCallback.requestComplete(PageBufferClient.this);
            }

            public void onFailure(Throwable t) {
                log.debug("Request to %s failed %s", new Object[]{uri, t});
                PageBufferClient.checkNotHoldsLock(this);
                t = PageBufferClient.this.resultClient.rewriteException((Throwable)t);
                if (!(t instanceof PrestoException) && PageBufferClient.this.backoff.failure()) {
                    String message = String.format("%s (%s - %s failures, failure duration %s, total failed request time %s)", "Encountered too many errors talking to a worker node. The node may have crashed or be under too much load. This is probably a transient issue, so please retry your query in a few minutes.", uri, PageBufferClient.this.backoff.getFailureCount(), PageBufferClient.this.backoff.getFailureDuration().convertTo(TimeUnit.SECONDS), PageBufferClient.this.backoff.getFailureRequestTimeTotal().convertTo(TimeUnit.SECONDS));
                    t = new PageTransportTimeoutException(HostAddress.fromUri((URI)uri), message, (Throwable)t);
                }
                PageBufferClient.this.handleFailure(t, resultFuture);
            }
        }, (Executor)this.pageBufferClientCallbackExecutor);
    }

    private synchronized void sendDelete() {
        final ListenableFuture<?> resultFuture = this.resultClient.abortResults();
        this.future = resultFuture;
        Futures.addCallback(resultFuture, (FutureCallback)new FutureCallback<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(@Nullable Object result) {
                PageBufferClient.checkNotHoldsLock(this);
                PageBufferClient.this.backoff.success();
                PageBufferClient pageBufferClient = PageBufferClient.this;
                synchronized (pageBufferClient) {
                    PageBufferClient.this.closed = true;
                    if (PageBufferClient.this.future == resultFuture) {
                        PageBufferClient.this.future = null;
                    }
                    PageBufferClient.this.lastUpdate = DateTime.now();
                }
                PageBufferClient.this.requestsCompleted.incrementAndGet();
                PageBufferClient.this.clientCallback.clientFinished(PageBufferClient.this);
            }

            public void onFailure(Throwable t) {
                PageBufferClient.checkNotHoldsLock(this);
                log.error("Request to delete %s failed %s", new Object[]{PageBufferClient.this.location, t});
                if (!(t instanceof PrestoException) && PageBufferClient.this.backoff.failure()) {
                    String message = String.format("Error closing remote buffer (%s - %s failures, failure duration %s, total failed request time %s)", PageBufferClient.this.location, PageBufferClient.this.backoff.getFailureCount(), PageBufferClient.this.backoff.getFailureDuration().convertTo(TimeUnit.SECONDS), PageBufferClient.this.backoff.getFailureRequestTimeTotal().convertTo(TimeUnit.SECONDS));
                    t = new PrestoException((ErrorCodeSupplier)StandardErrorCode.REMOTE_BUFFER_CLOSE_FAILED, message, t);
                }
                PageBufferClient.this.handleFailure(t, resultFuture);
            }
        }, (Executor)this.pageBufferClientCallbackExecutor);
    }

    private static void checkNotHoldsLock(Object lock) {
        Preconditions.checkState((!Thread.holdsLock(lock) ? 1 : 0) != 0, (Object)"Cannot execute this method while holding a lock");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFailure(Throwable t, ListenableFuture<?> expectedFuture) {
        PageBufferClient.checkNotHoldsLock(this);
        this.requestsFailed.incrementAndGet();
        this.requestsCompleted.incrementAndGet();
        if (t instanceof PrestoException) {
            this.clientCallback.clientFailed(this, t);
        }
        PageBufferClient pageBufferClient = this;
        synchronized (pageBufferClient) {
            if (this.future == expectedFuture) {
                this.future = null;
            }
            this.lastUpdate = DateTime.now();
        }
        this.clientCallback.requestComplete(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageBufferClient that = (PageBufferClient)o;
        return this.location.equals(that.location);
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String state;
        PageBufferClient pageBufferClient = this;
        synchronized (pageBufferClient) {
            state = this.closed ? "CLOSED" : (this.future != null ? "RUNNING" : "QUEUED");
        }
        return MoreObjects.toStringHelper((Object)this).add("location", (Object)this.location).addValue((Object)state).toString();
    }

    public static class PagesResponse {
        private final String taskInstanceId;
        private final long token;
        private final long nextToken;
        private final List<SerializedPage> pages;
        private final boolean clientComplete;

        public static PagesResponse createPagesResponse(String taskInstanceId, long token, long nextToken, Iterable<SerializedPage> pages, boolean complete) {
            return new PagesResponse(taskInstanceId, token, nextToken, pages, complete);
        }

        public static PagesResponse createEmptyPagesResponse(String taskInstanceId, long token, long nextToken, boolean complete) {
            return new PagesResponse(taskInstanceId, token, nextToken, (Iterable<SerializedPage>)ImmutableList.of(), complete);
        }

        private PagesResponse(String taskInstanceId, long token, long nextToken, Iterable<SerializedPage> pages, boolean clientComplete) {
            this.taskInstanceId = taskInstanceId;
            this.token = token;
            this.nextToken = nextToken;
            this.pages = ImmutableList.copyOf(pages);
            this.clientComplete = clientComplete;
        }

        public long getToken() {
            return this.token;
        }

        public long getNextToken() {
            return this.nextToken;
        }

        public List<SerializedPage> getPages() {
            return this.pages;
        }

        public boolean isClientComplete() {
            return this.clientComplete;
        }

        public String getTaskInstanceId() {
            return this.taskInstanceId;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("token", this.token).add("nextToken", this.nextToken).add("pagesSize", this.pages.size()).add("clientComplete", this.clientComplete).toString();
        }
    }

    public static interface ClientCallback {
        public boolean addPages(PageBufferClient var1, List<SerializedPage> var2);

        public void requestComplete(PageBufferClient var1);

        public void clientFinished(PageBufferClient var1);

        public void clientFailed(PageBufferClient var1, Throwable var2);
    }
}

