/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.Session;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.AccumulatorFactory;
import com.facebook.presto.operator.aggregation.AccumulatorFactoryBinder;
import com.facebook.presto.operator.aggregation.AggregationMetadata;
import com.facebook.presto.operator.aggregation.GenericAccumulatorFactory;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.operator.aggregation.LambdaProvider;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class GenericAccumulatorFactoryBinder
implements AccumulatorFactoryBinder {
    private final List<AggregationMetadata.AccumulatorStateDescriptor> stateDescriptors;
    private final Constructor<? extends Accumulator> accumulatorConstructor;
    private final Constructor<? extends GroupedAccumulator> groupedAccumulatorConstructor;

    public GenericAccumulatorFactoryBinder(List<AggregationMetadata.AccumulatorStateDescriptor> stateDescriptors, Class<? extends Accumulator> accumulatorClass, Class<? extends GroupedAccumulator> groupedAccumulatorClass) {
        this.stateDescriptors = Objects.requireNonNull(stateDescriptors, "stateDescriptors is null");
        try {
            this.accumulatorConstructor = accumulatorClass.getConstructor(List.class, List.class, Optional.class, List.class);
            this.groupedAccumulatorConstructor = groupedAccumulatorClass.getConstructor(List.class, List.class, Optional.class, List.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public AccumulatorFactory bind(List<Integer> argumentChannels, Optional<Integer> maskChannel, List<Type> sourceTypes, List<Integer> orderByChannels, List<SortOrder> orderings, PagesIndex.Factory pagesIndexFactory, boolean distinct, JoinCompiler joinCompiler, List<LambdaProvider> lambdaProviders, Session session) {
        return new GenericAccumulatorFactory(this.stateDescriptors, this.accumulatorConstructor, this.groupedAccumulatorConstructor, lambdaProviders, argumentChannels, maskChannel, sourceTypes, orderByChannels, orderings, pagesIndexFactory, joinCompiler, session, distinct);
    }

    @VisibleForTesting
    public List<AggregationMetadata.AccumulatorStateDescriptor> getStateDescriptors() {
        return this.stateDescriptors;
    }
}

