/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.annotations;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.metadata.SignatureBinder;
import com.facebook.presto.operator.annotations.ScalarImplementationDependency;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.InvocationConvention;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class OperatorImplementationDependency
extends ScalarImplementationDependency {
    private final OperatorType operator;
    private final List<TypeSignature> argumentTypes;

    public OperatorImplementationDependency(OperatorType operator, List<TypeSignature> argumentTypes, Optional<InvocationConvention> invocationConvention) {
        super(invocationConvention);
        this.operator = Objects.requireNonNull(operator, "operator is null");
        this.argumentTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
    }

    public OperatorType getOperator() {
        return this.operator;
    }

    public List<TypeSignature> getArgumentTypes() {
        return this.argumentTypes;
    }

    @Override
    protected FunctionHandle getFunctionHandle(BoundVariables boundVariables, FunctionManager functionManager) {
        return functionManager.resolveOperator(this.operator, TypeSignatureProvider.fromTypeSignatures(SignatureBinder.applyBoundVariables(this.argumentTypes, boundVariables)));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperatorImplementationDependency that = (OperatorImplementationDependency)o;
        return Objects.equals(this.operator, that.operator) && Objects.equals(this.argumentTypes, that.argumentTypes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.operator, this.argumentTypes);
    }
}

