/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.exchange;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.operator.PartitionFunction;
import com.facebook.presto.operator.exchange.LocalExchangeMemoryManager;
import com.facebook.presto.operator.exchange.LocalExchanger;
import com.facebook.presto.operator.exchange.PageReference;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

class PartitioningExchanger
implements LocalExchanger {
    private final List<Consumer<PageReference>> buffers;
    private final LocalExchangeMemoryManager memoryManager;
    private final PartitionFunction partitionFunction;
    private final List<Integer> partitioningChannels;
    private final Optional<Integer> hashChannel;
    private final IntArrayList[] partitionAssignments;

    public PartitioningExchanger(List<Consumer<PageReference>> partitions, LocalExchangeMemoryManager memoryManager, PartitionFunction partitionFunction, List<Integer> partitioningChannels, Optional<Integer> hashChannel) {
        this.buffers = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitions, "partitions is null"));
        this.memoryManager = Objects.requireNonNull(memoryManager, "memoryManager is null");
        this.partitionFunction = Objects.requireNonNull(partitionFunction, "partitionFunction is null");
        this.partitioningChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitioningChannels, "partitioningChannels is null"));
        this.hashChannel = Objects.requireNonNull(hashChannel, "hashChannel is null");
        this.partitionAssignments = new IntArrayList[partitions.size()];
        for (int i = 0; i < this.partitionAssignments.length; ++i) {
            this.partitionAssignments[i] = new IntArrayList();
        }
    }

    @Override
    public synchronized void accept(Page page) {
        int partition;
        for (IntArrayList partitionAssignment : this.partitionAssignments) {
            partitionAssignment.clear();
        }
        Page partitioningChannelsPage = this.extractPartitioningChannels(page);
        for (int position = 0; position < partitioningChannelsPage.getPositionCount(); ++position) {
            partition = this.partitionFunction.getPartition(partitioningChannelsPage, position);
            this.partitionAssignments[partition].add(position);
        }
        Block[] outputBlocks = new Block[page.getChannelCount()];
        for (partition = 0; partition < this.buffers.size(); ++partition) {
            IntArrayList positions = this.partitionAssignments[partition];
            if (positions.isEmpty()) continue;
            for (int i = 0; i < page.getChannelCount(); ++i) {
                outputBlocks[i] = page.getBlock(i).copyPositions(positions.elements(), 0, positions.size());
            }
            Page pageSplit = new Page(positions.size(), outputBlocks);
            this.memoryManager.updateMemoryUsage(pageSplit.getRetainedSizeInBytes());
            this.buffers.get(partition).accept(new PageReference(pageSplit, 1, () -> this.memoryManager.updateMemoryUsage(-pageSplit.getRetainedSizeInBytes())));
        }
    }

    private Page extractPartitioningChannels(Page inputPage) {
        if (this.hashChannel.isPresent()) {
            return new Page(new Block[]{inputPage.getBlock(this.hashChannel.get().intValue())});
        }
        Block[] blocks = new Block[this.partitioningChannels.size()];
        for (int i = 0; i < this.partitioningChannels.size(); ++i) {
            blocks[i] = inputPage.getBlock(this.partitioningChannels.get(i).intValue());
        }
        return new Page(inputPage.getPositionCount(), blocks);
    }

    @Override
    public ListenableFuture<?> waitForWriting() {
        return this.memoryManager.getNotFullFuture();
    }
}

