/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.repartition;

import com.facebook.presto.array.Arrays;
import com.facebook.presto.common.block.ArrayAllocator;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.operator.UncheckedByteArrays;
import com.facebook.presto.operator.repartition.AbstractBlockEncodingBuffer;
import com.facebook.presto.operator.repartition.DecodedBlockNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import io.airlift.slice.SliceOutput;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;
import sun.misc.Unsafe;

public class ShortArrayBlockEncodingBuffer
extends AbstractBlockEncodingBuffer {
    @VisibleForTesting
    static final int POSITION_SIZE = 3;
    private static final String NAME = "SHORT_ARRAY";
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ShortArrayBlockEncodingBuffer.class).instanceSize();
    private byte[] valuesBuffer;
    private int valuesBufferIndex;
    private int estimatedValueBufferMaxCapacity;

    public ShortArrayBlockEncodingBuffer(ArrayAllocator bufferAllocator, boolean isNested) {
        super(bufferAllocator, isNested);
    }

    @Override
    public void accumulateSerializedRowSizes(int[] serializedRowSizes) {
        throw new UnsupportedOperationException("accumulateSerializedRowSizes is not supported for fixed width types");
    }

    @Override
    public void appendDataInBatch() {
        if (this.batchSize == 0) {
            return;
        }
        this.appendValuesToBuffer();
        this.appendNulls();
        this.bufferedPositionCount += this.batchSize;
    }

    @Override
    public void serializeTo(SliceOutput output) {
        ShortArrayBlockEncodingBuffer.writeLengthPrefixedString(output, NAME);
        output.writeInt(this.bufferedPositionCount);
        this.serializeNullsTo(output);
        if (this.valuesBufferIndex > 0) {
            output.appendBytes(this.valuesBuffer, 0, this.valuesBufferIndex);
        }
    }

    @Override
    public void resetBuffers() {
        this.bufferedPositionCount = 0;
        this.valuesBufferIndex = 0;
        this.flushed = true;
        this.resetNullsBuffer();
    }

    @Override
    public void noMoreBatches() {
        super.noMoreBatches();
        if (this.flushed && this.valuesBuffer != null) {
            this.bufferAllocator.returnArray(this.valuesBuffer);
            this.valuesBuffer = null;
        }
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }

    @Override
    public long getSerializedSizeInBytes() {
        return (long)(NAME.length() + 4 + 4) + this.getNullsBufferSerializedSizeInBytes() + (long)this.valuesBufferIndex;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("super", (Object)super.toString()).add("estimatedValueBufferMaxCapacity", this.estimatedValueBufferMaxCapacity).add("valuesBufferCapacity", this.valuesBuffer == null ? 0 : this.valuesBuffer.length).add("valuesBufferIndex", this.valuesBufferIndex).toString();
    }

    @Override
    protected void setupDecodedBlockAndMapPositions(DecodedBlockNode decodedBlockNode, int partitionBufferCapacity, double decodedBlockPageSizeFraction) {
        Objects.requireNonNull(decodedBlockNode, "decodedBlockNode is null");
        this.decodedBlock = (Block)this.mapPositionsToNestedBlock(decodedBlockNode).getDecodedBlock();
        double targetBufferSize = (double)partitionBufferCapacity * decodedBlockPageSizeFraction;
        if (this.decodedBlock.mayHaveNull()) {
            this.setEstimatedNullsBufferMaxCapacity((int)(targetBufferSize * 1.0 / 3.0));
            this.estimatedValueBufferMaxCapacity = (int)(targetBufferSize * 1.0 / 3.0);
        } else {
            this.estimatedValueBufferMaxCapacity = (int)targetBufferSize;
        }
    }

    @Override
    protected void accumulateSerializedRowSizes(int[] positionOffsets, int positionCount, int[] serializedRowSizes) {
        for (int i = 0; i < positionCount; ++i) {
            int n = i;
            serializedRowSizes[n] = serializedRowSizes[n] + (positionOffsets[i + 1] - positionOffsets[i]) * 3;
        }
    }

    private void appendValuesToBuffer() {
        this.valuesBuffer = Arrays.ensureCapacity((byte[])this.valuesBuffer, (int)(this.valuesBufferIndex + this.batchSize * Unsafe.ARRAY_SHORT_INDEX_SCALE), (int)this.estimatedValueBufferMaxCapacity, (Arrays.ExpansionFactor)Arrays.ExpansionFactor.LARGE, (Arrays.ExpansionOption)Arrays.ExpansionOption.PRESERVE, (ArrayAllocator)this.bufferAllocator);
        int[] positions = this.getPositions();
        if (this.decodedBlock.mayHaveNull()) {
            for (int i = this.positionsOffset; i < this.positionsOffset + this.batchSize; ++i) {
                int position = positions[i];
                short value = this.decodedBlock.getShort(position);
                int newIndex = UncheckedByteArrays.setShortUnchecked(this.valuesBuffer, this.valuesBufferIndex, value);
                if (this.decodedBlock.isNull(position)) continue;
                this.valuesBufferIndex = newIndex;
            }
        } else {
            for (int i = this.positionsOffset; i < this.positionsOffset + this.batchSize; ++i) {
                short value = this.decodedBlock.getShort(positions[i]);
                this.valuesBufferIndex = UncheckedByteArrays.setShortUnchecked(this.valuesBuffer, this.valuesBufferIndex, value);
            }
        }
    }
}

