/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.NotSupportedException;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.DuplicateMapKeyException;
import com.facebook.presto.common.block.MapBlockBuilder;
import com.facebook.presto.common.block.SingleMapBlockWriter;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.function.QualifiedFunctionName;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.BuiltInFunctionNamespaceManager;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public final class MapConstructor
extends SqlScalarFunction {
    public static final MapConstructor MAP_CONSTRUCTOR = new MapConstructor();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(MapConstructor.class, "createMap", MapType.class, MethodHandle.class, MethodHandle.class, MethodHandle.class, State.class, SqlFunctionProperties.class, Block.class, Block.class);
    private static final String DESCRIPTION = "Constructs a map from the given key/value arrays";

    public MapConstructor() {
        super(new Signature(QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"map"), FunctionKind.SCALAR, (List)ImmutableList.of((Object)Signature.comparableTypeParameter((String)"K"), (Object)Signature.typeVariable((String)"V")), (List)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"map(K,V)"), (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"array(K)"), (Object)TypeSignature.parseTypeSignature((String)"array(V)")), false));
    }

    public SqlFunctionVisibility getVisibility() {
        return SqlFunctionVisibility.PUBLIC;
    }

    public boolean isDeterministic() {
        return true;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public BuiltInScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionManager functionManager) {
        Type keyType = boundVariables.getTypeVariable("K");
        Type valueType = boundVariables.getTypeVariable("V");
        Type mapType = typeManager.getParameterizedType("map", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)keyType.getTypeSignature()), (Object)TypeSignatureParameter.of((TypeSignature)valueType.getTypeSignature())));
        MethodHandle keyHashCode = functionManager.getBuiltInScalarFunctionImplementation(functionManager.resolveOperator(OperatorType.HASH_CODE, TypeSignatureProvider.fromTypes(keyType))).getMethodHandle();
        MethodHandle keyEqual = functionManager.getBuiltInScalarFunctionImplementation(functionManager.resolveOperator(OperatorType.EQUAL, TypeSignatureProvider.fromTypes(keyType, keyType))).getMethodHandle();
        MethodHandle keyIndeterminate = functionManager.getBuiltInScalarFunctionImplementation(functionManager.resolveOperator(OperatorType.INDETERMINATE, TypeSignatureProvider.fromTypeSignatures(keyType.getTypeSignature()))).getMethodHandle();
        MethodHandle instanceFactory = Reflection.constructorMethodHandle(State.class, MapType.class).bindTo(mapType);
        return new BuiltInScalarFunctionImplementation(false, (List<BuiltInScalarFunctionImplementation.ArgumentProperty>)ImmutableList.of((Object)BuiltInScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(BuiltInScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL), (Object)BuiltInScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(BuiltInScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL)), METHOD_HANDLE.bindTo(mapType).bindTo(keyEqual).bindTo(keyHashCode).bindTo(keyIndeterminate), Optional.of(instanceFactory));
    }

    @UsedByGeneratedCode
    public static Block createMap(MapType mapType, MethodHandle keyEqual, MethodHandle keyHashCode, MethodHandle keyIndeterminate, State state, SqlFunctionProperties properties, Block keyBlock, Block valueBlock) {
        Failures.checkCondition(keyBlock.getPositionCount() == valueBlock.getPositionCount(), (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Key and value arrays must be the same length", new Object[0]);
        PageBuilder pageBuilder = state.getPageBuilder();
        if (pageBuilder.isFull()) {
            pageBuilder.reset();
        }
        MapBlockBuilder mapBlockBuilder = (MapBlockBuilder)pageBuilder.getBlockBuilder(0);
        SingleMapBlockWriter blockBuilder = mapBlockBuilder.beginBlockEntry();
        for (int i = 0; i < keyBlock.getPositionCount(); ++i) {
            if (keyBlock.isNull(i)) {
                mapBlockBuilder.closeEntry();
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "map key cannot be null");
            }
            Object keyObject = TypeUtils.readNativeValue((Type)mapType.getKeyType(), (Block)keyBlock, (int)i);
            try {
                if (keyIndeterminate.invoke(keyObject, false)) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "map key cannot be indeterminate: " + mapType.getKeyType().getObjectValue(properties, keyBlock, i));
                }
            }
            catch (Throwable t) {
                mapBlockBuilder.closeEntry();
                throw Failures.internalError(t);
            }
            mapType.getKeyType().appendTo(keyBlock, i, (BlockBuilder)blockBuilder);
            mapType.getValueType().appendTo(valueBlock, i, (BlockBuilder)blockBuilder);
        }
        try {
            mapBlockBuilder.closeEntryStrict();
        }
        catch (DuplicateMapKeyException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, e.getDetailedMessage(mapType.getKeyType(), properties), (Throwable)e);
        }
        catch (NotSupportedException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, e.getMessage(), (Throwable)e);
        }
        finally {
            pageBuilder.declarePosition();
        }
        return mapType.getObject((Block)mapBlockBuilder, mapBlockBuilder.getPositionCount() - 1);
    }

    public static final class State {
        private final PageBuilder pageBuilder;

        public State(MapType mapType) {
            this.pageBuilder = new PageBuilder((List)ImmutableList.of((Object)mapType));
        }

        public PageBuilder getPageBuilder() {
            return this.pageBuilder;
        }
    }
}

