/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.tdigest.TDigest;
import io.airlift.slice.Slice;

public final class TDigestFunctions {
    public static final double DEFAULT_COMPRESSION = 100.0;

    private TDigestFunctions() {
    }

    @ScalarFunction(value="value_at_quantile", visibility=SqlFunctionVisibility.EXPERIMENTAL)
    @Description(value="Given an input q between [0, 1], find the value whose rank in the sorted sequence of the n values represented by the tdigest is qn.")
    @SqlType(value="double")
    public static double valueAtQuantileDouble(@SqlType(value="tdigest(double)") Slice input, @SqlType(value="double") double quantile) {
        return TDigest.createTDigest(input).getQuantile(quantile);
    }

    @ScalarFunction(value="values_at_quantiles", visibility=SqlFunctionVisibility.EXPERIMENTAL)
    @Description(value="For each input q between [0, 1], find the value whose rank in the sorted sequence of the n values represented by the tdigest is qn.")
    @SqlType(value="array(double)")
    public static Block valuesAtQuantilesDouble(@SqlType(value="tdigest(double)") Slice input, @SqlType(value="array(double)") Block percentilesArrayBlock) {
        TDigest tDigest = TDigest.createTDigest(input);
        BlockBuilder output = DoubleType.DOUBLE.createBlockBuilder(null, percentilesArrayBlock.getPositionCount());
        for (int i = 0; i < percentilesArrayBlock.getPositionCount(); ++i) {
            DoubleType.DOUBLE.writeDouble(output, tDigest.getQuantile(DoubleType.DOUBLE.getDouble(percentilesArrayBlock, i)));
        }
        return output.build();
    }

    @ScalarFunction(value="quantile_at_value", visibility=SqlFunctionVisibility.EXPERIMENTAL)
    @Description(value="Given an input x between min/max values of t-digest, find which quantile is represented by that value")
    @SqlType(value="double")
    public static double quantileAtValueDouble(@SqlType(value="tdigest(double)") Slice input, @SqlType(value="double") double value) {
        return TDigest.createTDigest(input).getCdf(value);
    }

    @ScalarFunction(value="quantiles_at_values", visibility=SqlFunctionVisibility.EXPERIMENTAL)
    @Description(value="For each input x between min/max values of t-digest, find which quantile is represented by that value")
    @SqlType(value="array(double)")
    public static Block quantilesAtValuesDouble(@SqlType(value="tdigest(double)") Slice input, @SqlType(value="array(double)") Block valuesArrayBlock) {
        TDigest tDigest = TDigest.createTDigest(input);
        BlockBuilder output = DoubleType.DOUBLE.createBlockBuilder(null, valuesArrayBlock.getPositionCount());
        for (int i = 0; i < valuesArrayBlock.getPositionCount(); ++i) {
            DoubleType.DOUBLE.writeDouble(output, tDigest.getCdf(DoubleType.DOUBLE.getDouble(valuesArrayBlock, i)));
        }
        return output.build();
    }
}

