/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.log.Logger;
import com.facebook.airlift.node.NodeInfo;
import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.common.block.BlockEncoding;
import com.facebook.presto.common.type.ParametricType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.connector.ConnectorManager;
import com.facebook.presto.eventlistener.EventListenerManager;
import com.facebook.presto.execution.resourceGroups.ResourceGroupManager;
import com.facebook.presto.metadata.FunctionExtractor;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.security.AccessControlManager;
import com.facebook.presto.server.PluginClassLoader;
import com.facebook.presto.server.PluginDiscovery;
import com.facebook.presto.server.PluginManagerConfig;
import com.facebook.presto.server.SessionPropertyDefaults;
import com.facebook.presto.server.security.PasswordAuthenticatorManager;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.eventlistener.EventListenerFactory;
import com.facebook.presto.spi.function.FunctionNamespaceManagerFactory;
import com.facebook.presto.spi.resourceGroups.ResourceGroupConfigurationManagerFactory;
import com.facebook.presto.spi.security.PasswordAuthenticatorFactory;
import com.facebook.presto.spi.security.SystemAccessControlFactory;
import com.facebook.presto.spi.session.SessionPropertyConfigurationManagerFactory;
import com.facebook.presto.type.TypeRegistry;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import io.airlift.resolver.ArtifactResolver;
import io.airlift.resolver.DefaultArtifact;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.sonatype.aether.artifact.Artifact;

@ThreadSafe
public class PluginManager {
    private static final ImmutableList<String> SPI_PACKAGES = ImmutableList.builder().add((Object)"com.facebook.presto.spi.").add((Object)"com.fasterxml.jackson.annotation.").add((Object)"com.fasterxml.jackson.module.afterburner.").add((Object)"io.airlift.slice.").add((Object)"io.airlift.units.").add((Object)"org.openjdk.jol.").add((Object)"com.facebook.presto.common").build();
    private static final Logger log = Logger.get(PluginManager.class);
    private final ConnectorManager connectorManager;
    private final Metadata metadata;
    private final ResourceGroupManager<?> resourceGroupManager;
    private final AccessControlManager accessControlManager;
    private final PasswordAuthenticatorManager passwordAuthenticatorManager;
    private final EventListenerManager eventListenerManager;
    private final BlockEncodingManager blockEncodingManager;
    private final SessionPropertyDefaults sessionPropertyDefaults;
    private final TypeRegistry typeRegistry;
    private final ArtifactResolver resolver;
    private final File installedPluginsDir;
    private final List<String> plugins;
    private final AtomicBoolean pluginsLoading = new AtomicBoolean();
    private final AtomicBoolean pluginsLoaded = new AtomicBoolean();

    @Inject
    public PluginManager(NodeInfo nodeInfo, PluginManagerConfig config, ConnectorManager connectorManager, Metadata metadata, ResourceGroupManager<?> resourceGroupManager, AccessControlManager accessControlManager, PasswordAuthenticatorManager passwordAuthenticatorManager, EventListenerManager eventListenerManager, BlockEncodingManager blockEncodingManager, SessionPropertyDefaults sessionPropertyDefaults, TypeRegistry typeRegistry) {
        Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        Objects.requireNonNull(config, "config is null");
        this.installedPluginsDir = config.getInstalledPluginsDir();
        this.plugins = config.getPlugins() == null ? ImmutableList.of() : ImmutableList.copyOf(config.getPlugins());
        this.resolver = new ArtifactResolver(config.getMavenLocalRepository(), config.getMavenRemoteRepository());
        this.connectorManager = Objects.requireNonNull(connectorManager, "connectorManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.resourceGroupManager = Objects.requireNonNull(resourceGroupManager, "resourceGroupManager is null");
        this.accessControlManager = Objects.requireNonNull(accessControlManager, "accessControlManager is null");
        this.passwordAuthenticatorManager = Objects.requireNonNull(passwordAuthenticatorManager, "passwordAuthenticatorManager is null");
        this.eventListenerManager = Objects.requireNonNull(eventListenerManager, "eventListenerManager is null");
        this.blockEncodingManager = Objects.requireNonNull(blockEncodingManager, "blockEncodingManager is null");
        this.sessionPropertyDefaults = Objects.requireNonNull(sessionPropertyDefaults, "sessionPropertyDefaults is null");
        this.typeRegistry = Objects.requireNonNull(typeRegistry, "typeRegistry is null");
    }

    public void loadPlugins() throws Exception {
        if (!this.pluginsLoading.compareAndSet(false, true)) {
            return;
        }
        for (File file : PluginManager.listFiles(this.installedPluginsDir)) {
            if (!file.isDirectory()) continue;
            this.loadPlugin(file.getAbsolutePath());
        }
        for (String plugin : this.plugins) {
            this.loadPlugin(plugin);
        }
        this.metadata.verifyComparableOrderableContract();
        this.pluginsLoaded.set(true);
    }

    private void loadPlugin(String plugin) throws Exception {
        log.info("-- Loading plugin %s --", new Object[]{plugin});
        URLClassLoader pluginClassLoader = this.buildClassLoader(plugin);
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader((ClassLoader)pluginClassLoader);){
            this.loadPlugin(pluginClassLoader);
        }
        log.info("-- Finished loading plugin %s --", new Object[]{plugin});
    }

    private void loadPlugin(URLClassLoader pluginClassLoader) {
        ServiceLoader<Plugin> serviceLoader = ServiceLoader.load(Plugin.class, pluginClassLoader);
        ImmutableList plugins = ImmutableList.copyOf(serviceLoader);
        if (plugins.isEmpty()) {
            log.warn("No service providers of type %s", new Object[]{Plugin.class.getName()});
        }
        for (Plugin plugin : plugins) {
            log.info("Installing %s", new Object[]{plugin.getClass().getName()});
            this.installPlugin(plugin);
        }
    }

    public void installPlugin(Plugin plugin) {
        for (BlockEncoding blockEncoding : plugin.getBlockEncodings()) {
            log.info("Registering block encoding %s", new Object[]{blockEncoding.getName()});
            this.blockEncodingManager.addBlockEncoding(blockEncoding);
        }
        for (Type type : plugin.getTypes()) {
            log.info("Registering type %s", new Object[]{type.getTypeSignature()});
            this.typeRegistry.addType(type);
        }
        for (ParametricType parametricType : plugin.getParametricTypes()) {
            log.info("Registering parametric type %s", new Object[]{parametricType.getName()});
            this.typeRegistry.addParametricType(parametricType);
        }
        for (ConnectorFactory connectorFactory : plugin.getConnectorFactories()) {
            log.info("Registering connector %s", new Object[]{connectorFactory.getName()});
            this.connectorManager.addConnectorFactory(connectorFactory);
        }
        for (Class functionClass : plugin.getFunctions()) {
            log.info("Registering functions from %s", new Object[]{functionClass.getName()});
            this.metadata.registerBuiltInFunctions(FunctionExtractor.extractFunctions(functionClass));
        }
        for (FunctionNamespaceManagerFactory functionNamespaceManagerFactory : plugin.getFunctionNamespaceManagerFactories()) {
            log.info("Registering function namespace manager %s", new Object[]{functionNamespaceManagerFactory.getName()});
            this.metadata.getFunctionManager().addFunctionNamespaceFactory(functionNamespaceManagerFactory);
        }
        for (SessionPropertyConfigurationManagerFactory sessionConfigFactory : plugin.getSessionPropertyConfigurationManagerFactories()) {
            log.info("Registering session property configuration manager %s", new Object[]{sessionConfigFactory.getName()});
            this.sessionPropertyDefaults.addConfigurationManagerFactory(sessionConfigFactory);
        }
        for (ResourceGroupConfigurationManagerFactory configurationManagerFactory : plugin.getResourceGroupConfigurationManagerFactories()) {
            log.info("Registering resource group configuration manager %s", new Object[]{configurationManagerFactory.getName()});
            this.resourceGroupManager.addConfigurationManagerFactory(configurationManagerFactory);
        }
        for (SystemAccessControlFactory accessControlFactory : plugin.getSystemAccessControlFactories()) {
            log.info("Registering system access control %s", new Object[]{accessControlFactory.getName()});
            this.accessControlManager.addSystemAccessControlFactory(accessControlFactory);
        }
        for (PasswordAuthenticatorFactory authenticatorFactory : plugin.getPasswordAuthenticatorFactories()) {
            log.info("Registering password authenticator %s", new Object[]{authenticatorFactory.getName()});
            this.passwordAuthenticatorManager.addPasswordAuthenticatorFactory(authenticatorFactory);
        }
        for (EventListenerFactory eventListenerFactory : plugin.getEventListenerFactories()) {
            log.info("Registering event listener %s", new Object[]{eventListenerFactory.getName()});
            this.eventListenerManager.addEventListenerFactory(eventListenerFactory);
        }
    }

    private URLClassLoader buildClassLoader(String plugin) throws Exception {
        File file = new File(plugin);
        if (file.isFile() && (file.getName().equals("pom.xml") || file.getName().endsWith(".pom"))) {
            return this.buildClassLoaderFromPom(file);
        }
        if (file.isDirectory()) {
            return this.buildClassLoaderFromDirectory(file);
        }
        return this.buildClassLoaderFromCoordinates(plugin);
    }

    private URLClassLoader buildClassLoaderFromPom(File pomFile) throws Exception {
        List artifacts = this.resolver.resolvePom(pomFile);
        URLClassLoader classLoader = this.createClassLoader(artifacts, pomFile.getPath());
        Artifact artifact = (Artifact)artifacts.get(0);
        Set<String> plugins = PluginDiscovery.discoverPlugins(artifact, classLoader);
        if (!plugins.isEmpty()) {
            PluginDiscovery.writePluginServices(plugins, artifact.getFile());
        }
        return classLoader;
    }

    private URLClassLoader buildClassLoaderFromDirectory(File dir) throws Exception {
        log.debug("Classpath for %s:", new Object[]{dir.getName()});
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : PluginManager.listFiles(dir)) {
            log.debug("    %s", new Object[]{file});
            urls.add(file.toURI().toURL());
        }
        return this.createClassLoader(urls);
    }

    private URLClassLoader buildClassLoaderFromCoordinates(String coordinates) throws Exception {
        DefaultArtifact rootArtifact = new DefaultArtifact(coordinates);
        List artifacts = this.resolver.resolveArtifacts(new Artifact[]{rootArtifact});
        return this.createClassLoader(artifacts, rootArtifact.toString());
    }

    private URLClassLoader createClassLoader(List<Artifact> artifacts, String name) throws IOException {
        log.debug("Classpath for %s:", new Object[]{name});
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Artifact artifact : PluginManager.sortedArtifacts(artifacts)) {
            if (artifact.getFile() == null) {
                throw new RuntimeException("Could not resolve artifact: " + artifact);
            }
            File file = artifact.getFile().getCanonicalFile();
            log.debug("    %s", new Object[]{file});
            urls.add(file.toURI().toURL());
        }
        return this.createClassLoader(urls);
    }

    private URLClassLoader createClassLoader(List<URL> urls) {
        ClassLoader parent = this.getClass().getClassLoader();
        return new PluginClassLoader(urls, parent, (Iterable<String>)SPI_PACKAGES);
    }

    private static List<File> listFiles(File installedPluginsDir) {
        Object[] files;
        if (installedPluginsDir != null && installedPluginsDir.isDirectory() && (files = installedPluginsDir.listFiles()) != null) {
            Arrays.sort(files);
            return ImmutableList.copyOf((Object[])files);
        }
        return ImmutableList.of();
    }

    private static List<Artifact> sortedArtifacts(List<Artifact> artifacts) {
        ArrayList<Artifact> list = new ArrayList<Artifact>(artifacts);
        Collections.sort(list, Ordering.natural().nullsLast().onResultOf(Artifact::getFile));
        return list;
    }
}

