/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.bytecode.instruction.LabelNode;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.PageWithPositionComparator;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.PagesIndexComparator;
import com.facebook.presto.operator.PagesIndexOrdering;
import com.facebook.presto.operator.SimplePageWithPositionComparator;
import com.facebook.presto.operator.SimplePagesIndexComparator;
import com.facebook.presto.operator.SyntheticAddress;
import com.facebook.presto.sql.gen.CacheStatsMBean;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.SqlTypeBytecodeExpression;
import com.facebook.presto.util.CompilerUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class OrderingCompiler {
    private static final Logger log = Logger.get(OrderingCompiler.class);
    private final LoadingCache<PagesIndexComparatorCacheKey, PagesIndexOrdering> pagesIndexOrderings = CacheBuilder.newBuilder().recordStats().maximumSize(1000L).build(CacheLoader.from(key -> this.internalCompilePagesIndexOrdering(key.getSortTypes(), key.getSortChannels(), key.getSortOrders())));
    private final LoadingCache<PagesIndexComparatorCacheKey, PageWithPositionComparator> pageWithPositionComparators = CacheBuilder.newBuilder().recordStats().maximumSize(1000L).build(CacheLoader.from(key -> this.internalCompilePageWithPositionComparator(key.getSortTypes(), key.getSortChannels(), key.getSortOrders())));

    @Managed
    @Nested
    public CacheStatsMBean getPagesIndexOrderingsStats() {
        return new CacheStatsMBean(this.pagesIndexOrderings);
    }

    @Managed
    @Nested
    public CacheStatsMBean getPageWithPositionsComparatorsStats() {
        return new CacheStatsMBean(this.pageWithPositionComparators);
    }

    public PagesIndexOrdering compilePagesIndexOrdering(List<Type> sortTypes, List<Integer> sortChannels, List<SortOrder> sortOrders) {
        Objects.requireNonNull(sortTypes, "sortTypes is null");
        Objects.requireNonNull(sortChannels, "sortChannels is null");
        Objects.requireNonNull(sortOrders, "sortOrders is null");
        return (PagesIndexOrdering)this.pagesIndexOrderings.getUnchecked((Object)new PagesIndexComparatorCacheKey(sortTypes, sortChannels, sortOrders));
    }

    @VisibleForTesting
    public PagesIndexOrdering internalCompilePagesIndexOrdering(List<Type> sortTypes, List<Integer> sortChannels, List<SortOrder> sortOrders) {
        PagesIndexComparator comparator;
        Objects.requireNonNull(sortChannels, "sortChannels is null");
        Objects.requireNonNull(sortOrders, "sortOrders is null");
        try {
            Class<? extends PagesIndexComparator> pagesHashStrategyClass = this.compilePagesIndexComparator(sortTypes, sortChannels, sortOrders);
            comparator = pagesHashStrategyClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            log.error(e, "Error compiling comparator for channels %s with order %s", new Object[]{sortChannels, sortOrders});
            comparator = new SimplePagesIndexComparator(sortTypes, sortChannels, sortOrders);
        }
        return new PagesIndexOrdering(comparator);
    }

    private Class<? extends PagesIndexComparator> compilePagesIndexComparator(List<Type> sortTypes, List<Integer> sortChannels, List<SortOrder> sortOrders) {
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        ClassDefinition classDefinition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName("PagesIndexComparator"), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(PagesIndexComparator.class)});
        classDefinition.declareDefaultConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}));
        OrderingCompiler.generatePageIndexCompareTo(classDefinition, callSiteBinder, sortTypes, sortChannels, sortOrders);
        return CompilerUtils.defineClass(classDefinition, PagesIndexComparator.class, callSiteBinder.getBindings(), this.getClass().getClassLoader());
    }

    private static void generatePageIndexCompareTo(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> sortTypes, List<Integer> sortChannels, List<SortOrder> sortOrders) {
        Parameter pagesIndex = Parameter.arg((String)"pagesIndex", PagesIndex.class);
        Parameter leftPosition = Parameter.arg((String)"leftPosition", Integer.TYPE);
        Parameter rightPosition = Parameter.arg((String)"rightPosition", Integer.TYPE);
        MethodDefinition compareToMethod = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "compareTo", ParameterizedType.type(Integer.TYPE), new Parameter[]{pagesIndex, leftPosition, rightPosition});
        Scope scope = compareToMethod.getScope();
        Variable valueAddresses = scope.declareVariable(LongArrayList.class, "valueAddresses");
        compareToMethod.getBody().comment("LongArrayList valueAddresses = pagesIndex.valueAddresses").append((BytecodeNode)valueAddresses.set(pagesIndex.invoke("getValueAddresses", LongArrayList.class, new BytecodeExpression[0])));
        Variable leftPageAddress = scope.declareVariable(Long.TYPE, "leftPageAddress");
        compareToMethod.getBody().comment("long leftPageAddress = valueAddresses.getLong(leftPosition)").append((BytecodeNode)leftPageAddress.set(valueAddresses.invoke("getLong", Long.TYPE, new BytecodeExpression[]{leftPosition})));
        Variable leftBlockIndex = scope.declareVariable(Integer.TYPE, "leftBlockIndex");
        compareToMethod.getBody().comment("int leftBlockIndex = decodeSliceIndex(leftPageAddress)").append((BytecodeNode)leftBlockIndex.set(BytecodeExpressions.invokeStatic(SyntheticAddress.class, (String)"decodeSliceIndex", Integer.TYPE, (BytecodeExpression[])new BytecodeExpression[]{leftPageAddress})));
        Variable leftBlockPosition = scope.declareVariable(Integer.TYPE, "leftBlockPosition");
        compareToMethod.getBody().comment("int leftBlockPosition = decodePosition(leftPageAddress)").append((BytecodeNode)leftBlockPosition.set(BytecodeExpressions.invokeStatic(SyntheticAddress.class, (String)"decodePosition", Integer.TYPE, (BytecodeExpression[])new BytecodeExpression[]{leftPageAddress})));
        Variable rightPageAddress = scope.declareVariable(Long.TYPE, "rightPageAddress");
        compareToMethod.getBody().comment("long rightPageAddress = valueAddresses.getLong(rightPosition);").append((BytecodeNode)rightPageAddress.set(valueAddresses.invoke("getLong", Long.TYPE, new BytecodeExpression[]{rightPosition})));
        Variable rightBlockIndex = scope.declareVariable(Integer.TYPE, "rightBlockIndex");
        compareToMethod.getBody().comment("int rightBlockIndex = decodeSliceIndex(rightPageAddress)").append((BytecodeNode)rightBlockIndex.set(BytecodeExpressions.invokeStatic(SyntheticAddress.class, (String)"decodeSliceIndex", Integer.TYPE, (BytecodeExpression[])new BytecodeExpression[]{rightPageAddress})));
        Variable rightBlockPosition = scope.declareVariable(Integer.TYPE, "rightBlockPosition");
        compareToMethod.getBody().comment("int rightBlockPosition = decodePosition(rightPageAddress)").append((BytecodeNode)rightBlockPosition.set(BytecodeExpressions.invokeStatic(SyntheticAddress.class, (String)"decodePosition", Integer.TYPE, (BytecodeExpression[])new BytecodeExpression[]{rightPageAddress})));
        for (int i = 0; i < sortChannels.size(); ++i) {
            int sortChannel = sortChannels.get(i);
            SortOrder sortOrder = sortOrders.get(i);
            BytecodeBlock block = new BytecodeBlock().setDescription("compare channel " + sortChannel + " " + sortOrder);
            Type sortType = sortTypes.get(i);
            BytecodeExpression leftBlock = pagesIndex.invoke("getChannel", ObjectArrayList.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)sortChannel)}).invoke("get", Object.class, new BytecodeExpression[]{leftBlockIndex}).cast(Block.class);
            BytecodeExpression rightBlock = pagesIndex.invoke("getChannel", ObjectArrayList.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)sortChannel)}).invoke("get", Object.class, new BytecodeExpression[]{rightBlockIndex}).cast(Block.class);
            block.append((BytecodeNode)BytecodeExpressions.getStatic(SortOrder.class, (String)sortOrder.name()).invoke("compareBlockValue", Integer.TYPE, (Iterable)ImmutableList.of(Type.class, Block.class, Integer.TYPE, Block.class, Integer.TYPE), new BytecodeExpression[]{SqlTypeBytecodeExpression.constantType(callSiteBinder, sortType), leftBlock, leftBlockPosition, rightBlock, rightBlockPosition}));
            LabelNode equal = new LabelNode("equal");
            block.comment("if (compare != 0) return compare").dup().ifZeroGoto(equal).retInt().visitLabel(equal).pop(Integer.TYPE);
            compareToMethod.getBody().append((BytecodeNode)block);
        }
        compareToMethod.getBody().push(0).retInt();
    }

    public PageWithPositionComparator compilePageWithPositionComparator(List<Type> sortTypes, List<Integer> sortChannels, List<SortOrder> sortOrders) {
        Objects.requireNonNull(sortTypes, "sortTypes is null");
        Objects.requireNonNull(sortChannels, "sortChannels is null");
        Objects.requireNonNull(sortOrders, "sortOrders is null");
        return (PageWithPositionComparator)this.pageWithPositionComparators.getUnchecked((Object)new PagesIndexComparatorCacheKey(sortTypes, sortChannels, sortOrders));
    }

    private PageWithPositionComparator internalCompilePageWithPositionComparator(List<Type> types, List<Integer> sortChannels, List<SortOrder> sortOrders) {
        PageWithPositionComparator comparator;
        try {
            Class<? extends PageWithPositionComparator> pageWithPositionsComparatorClass = this.generatePageWithPositionComparatorClass(types, sortChannels, sortOrders);
            comparator = pageWithPositionsComparatorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable t) {
            log.error(t, "Error compiling merge sort comparator for channels %s with order %s", new Object[]{sortChannels, sortChannels});
            comparator = new SimplePageWithPositionComparator(types, sortChannels, sortOrders);
        }
        return comparator;
    }

    private Class<? extends PageWithPositionComparator> generatePageWithPositionComparatorClass(List<Type> sortTypes, List<Integer> sortChannels, List<SortOrder> sortOrders) {
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        ClassDefinition classDefinition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName("PageWithPositionComparator"), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(PageWithPositionComparator.class)});
        classDefinition.declareDefaultConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}));
        this.generateMergeSortCompareTo(classDefinition, callSiteBinder, sortTypes, sortChannels, sortOrders);
        return CompilerUtils.defineClass(classDefinition, PageWithPositionComparator.class, callSiteBinder.getBindings(), this.getClass().getClassLoader());
    }

    private void generateMergeSortCompareTo(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> types, List<Integer> sortChannels, List<SortOrder> sortOrders) {
        Parameter leftPage = Parameter.arg((String)"leftPage", Page.class);
        Parameter leftPosition = Parameter.arg((String)"leftPosition", Integer.TYPE);
        Parameter rightPage = Parameter.arg((String)"rightPage", Page.class);
        Parameter rightPosition = Parameter.arg((String)"rightPosition", Integer.TYPE);
        MethodDefinition compareToMethod = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "compareTo", ParameterizedType.type(Integer.TYPE), new Parameter[]{leftPage, leftPosition, rightPage, rightPosition});
        for (int i = 0; i < sortChannels.size(); ++i) {
            int sortChannel = sortChannels.get(i);
            SortOrder sortOrder = sortOrders.get(i);
            BytecodeBlock block = new BytecodeBlock().setDescription("compare channel " + sortChannel + " " + sortOrder);
            Type sortType = types.get(sortChannel);
            BytecodeExpression leftBlock = leftPage.invoke("getBlock", Block.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)sortChannel)});
            BytecodeExpression rightBlock = rightPage.invoke("getBlock", Block.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)sortChannel)});
            block.append((BytecodeNode)BytecodeExpressions.getStatic(SortOrder.class, (String)sortOrder.name()).invoke("compareBlockValue", Integer.TYPE, (Iterable)ImmutableList.of(Type.class, Block.class, Integer.TYPE, Block.class, Integer.TYPE), new BytecodeExpression[]{SqlTypeBytecodeExpression.constantType(callSiteBinder, sortType), leftBlock, leftPosition, rightBlock, rightPosition}));
            LabelNode equal = new LabelNode("equal");
            block.comment("if (compare != 0) return compare").dup().ifZeroGoto(equal).retInt().visitLabel(equal).pop(Integer.TYPE);
            compareToMethod.getBody().append((BytecodeNode)block);
        }
        compareToMethod.getBody().push(0).retInt();
    }

    private static final class PagesIndexComparatorCacheKey {
        private final List<Type> sortTypes;
        private final List<Integer> sortChannels;
        private final List<SortOrder> sortOrders;

        private PagesIndexComparatorCacheKey(List<Type> sortTypes, List<Integer> sortChannels, List<SortOrder> sortOrders) {
            this.sortTypes = ImmutableList.copyOf(sortTypes);
            this.sortChannels = ImmutableList.copyOf(sortChannels);
            this.sortOrders = ImmutableList.copyOf(sortOrders);
        }

        public List<Type> getSortTypes() {
            return this.sortTypes;
        }

        public List<Integer> getSortChannels() {
            return this.sortChannels;
        }

        public List<SortOrder> getSortOrders() {
            return this.sortOrders;
        }

        public int hashCode() {
            return Objects.hash(this.sortTypes, this.sortChannels, this.sortOrders);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PagesIndexComparatorCacheKey other = (PagesIndexComparatorCacheKey)obj;
            return Objects.equals(this.sortTypes, other.sortTypes) && Objects.equals(this.sortChannels, other.sortChannels) && Objects.equals(this.sortOrders, other.sortOrders);
        }
    }
}

