/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.esri.core.geometry.ogc.OGCGeometry;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.function.QualifiedFunctionName;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.execution.ExplainAnalyzeContext;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.StageExecutionId;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.buffer.OutputBuffer;
import com.facebook.presto.execution.buffer.PagesSerdeFactory;
import com.facebook.presto.execution.scheduler.ExecutionWriterTarget;
import com.facebook.presto.execution.scheduler.TableWriteInfo;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.expressions.RowExpressionNodeInliner;
import com.facebook.presto.geospatial.SphericalGeographyUtils;
import com.facebook.presto.index.IndexManager;
import com.facebook.presto.metadata.AnalyzeTableHandle;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.AggregationOperator;
import com.facebook.presto.operator.AssignUniqueIdOperator;
import com.facebook.presto.operator.DeleteOperator;
import com.facebook.presto.operator.DevNullOperator;
import com.facebook.presto.operator.DistinctLimitOperator;
import com.facebook.presto.operator.DriverFactory;
import com.facebook.presto.operator.EnforceSingleRowOperator;
import com.facebook.presto.operator.ExplainAnalyzeOperator;
import com.facebook.presto.operator.FilterAndProjectOperator;
import com.facebook.presto.operator.GroupIdOperator;
import com.facebook.presto.operator.HashAggregationOperator;
import com.facebook.presto.operator.HashBuilderOperator;
import com.facebook.presto.operator.HashSemiJoinOperator;
import com.facebook.presto.operator.JoinBridgeManager;
import com.facebook.presto.operator.JoinOperatorFactory;
import com.facebook.presto.operator.LimitOperator;
import com.facebook.presto.operator.LocalPlannerAware;
import com.facebook.presto.operator.LookupJoinOperators;
import com.facebook.presto.operator.LookupOuterOperator;
import com.facebook.presto.operator.LookupSourceFactory;
import com.facebook.presto.operator.MarkDistinctOperator;
import com.facebook.presto.operator.MetadataDeleteOperator;
import com.facebook.presto.operator.NestedLoopBuildOperator;
import com.facebook.presto.operator.NestedLoopJoinBridge;
import com.facebook.presto.operator.NestedLoopJoinOperator;
import com.facebook.presto.operator.NestedLoopJoinPagesSupplier;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.OrderByOperator;
import com.facebook.presto.operator.OutputFactory;
import com.facebook.presto.operator.PageSinkCommitStrategy;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.PagesSpatialIndexFactory;
import com.facebook.presto.operator.PartitionFunction;
import com.facebook.presto.operator.PartitionedLookupSourceFactory;
import com.facebook.presto.operator.PipelineExecutionStrategy;
import com.facebook.presto.operator.RowNumberOperator;
import com.facebook.presto.operator.ScanFilterAndProjectOperator;
import com.facebook.presto.operator.SetBuilderOperator;
import com.facebook.presto.operator.SpatialIndexBuilderOperator;
import com.facebook.presto.operator.SpatialJoinOperator;
import com.facebook.presto.operator.StageExecutionDescriptor;
import com.facebook.presto.operator.StatisticsWriterOperator;
import com.facebook.presto.operator.StreamingAggregationOperator;
import com.facebook.presto.operator.TableCommitContext;
import com.facebook.presto.operator.TableFinishOperator;
import com.facebook.presto.operator.TableScanOperator;
import com.facebook.presto.operator.TableWriterMergeOperator;
import com.facebook.presto.operator.TableWriterOperator;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.TaskOutputOperator;
import com.facebook.presto.operator.TopNOperator;
import com.facebook.presto.operator.TopNRowNumberOperator;
import com.facebook.presto.operator.ValuesOperator;
import com.facebook.presto.operator.WindowFunctionDefinition;
import com.facebook.presto.operator.WindowOperator;
import com.facebook.presto.operator.aggregation.AccumulatorFactory;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.LambdaProvider;
import com.facebook.presto.operator.exchange.LocalExchange;
import com.facebook.presto.operator.exchange.LocalExchangeSinkOperator;
import com.facebook.presto.operator.exchange.LocalExchangeSourceOperator;
import com.facebook.presto.operator.exchange.LocalMergeSourceOperator;
import com.facebook.presto.operator.exchange.PageChannelSelector;
import com.facebook.presto.operator.index.DynamicTupleFilterFactory;
import com.facebook.presto.operator.index.FieldSetFilteringRecordSet;
import com.facebook.presto.operator.index.IndexBuildDriverFactoryProvider;
import com.facebook.presto.operator.index.IndexJoinLookupStats;
import com.facebook.presto.operator.index.IndexLookupSourceFactory;
import com.facebook.presto.operator.index.IndexSourceOperator;
import com.facebook.presto.operator.project.CursorProcessor;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.operator.repartition.OptimizedPartitionedOutputOperator;
import com.facebook.presto.operator.repartition.PartitionedOutputOperator;
import com.facebook.presto.operator.unnest.UnnestOperator;
import com.facebook.presto.operator.window.FrameInfo;
import com.facebook.presto.operator.window.WindowFunctionSupplier;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorIndex;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.MarkDistinctNode;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.ExpressionOptimizer;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spiller.PartitioningSpillerFactory;
import com.facebook.presto.spiller.SingleStreamSpillerFactory;
import com.facebook.presto.spiller.SpillerFactory;
import com.facebook.presto.split.MappedRecordSet;
import com.facebook.presto.split.PageSinkManager;
import com.facebook.presto.split.PageSourceProvider;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.sql.gen.JoinFilterFunctionCompiler;
import com.facebook.presto.sql.gen.LambdaBytecodeGenerator;
import com.facebook.presto.sql.gen.OrderingCompiler;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.planner.NodePartitioningManager;
import com.facebook.presto.sql.planner.OutputPartitioning;
import com.facebook.presto.sql.planner.PartitioningProviderManager;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.RemoteSourceFactory;
import com.facebook.presto.sql.planner.RowExpressionInterpreter;
import com.facebook.presto.sql.planner.SortExpressionContext;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.optimizations.IndexJoinOptimizer;
import com.facebook.presto.sql.planner.plan.AssignUniqueId;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.MetadataDeleteNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.SpatialJoinNode;
import com.facebook.presto.sql.planner.plan.StatisticAggregationsDescriptor;
import com.facebook.presto.sql.planner.plan.StatisticsWriterNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableWriterMergeNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.VariableToChannelTranslator;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.util.Reflection;
import com.facebook.presto.util.SpatialJoinUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import com.google.common.collect.SetMultimap;
import com.google.common.primitives.Ints;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;

public class LocalExecutionPlanner {
    private final Metadata metadata;
    private final Optional<ExplainAnalyzeContext> explainAnalyzeContext;
    private final PageSourceProvider pageSourceProvider;
    private final IndexManager indexManager;
    private final PartitioningProviderManager partitioningProviderManager;
    private final NodePartitioningManager nodePartitioningManager;
    private final PageSinkManager pageSinkManager;
    private final ExpressionCompiler expressionCompiler;
    private final PageFunctionCompiler pageFunctionCompiler;
    private final JoinFilterFunctionCompiler joinFilterFunctionCompiler;
    private final DataSize maxIndexMemorySize;
    private final IndexJoinLookupStats indexJoinLookupStats;
    private final DataSize maxPartialAggregationMemorySize;
    private final DataSize maxPagePartitioningBufferSize;
    private final DataSize maxLocalExchangeBufferSize;
    private final SpillerFactory spillerFactory;
    private final SingleStreamSpillerFactory singleStreamSpillerFactory;
    private final PartitioningSpillerFactory partitioningSpillerFactory;
    private final BlockEncodingSerde blockEncodingSerde;
    private final PagesIndex.Factory pagesIndexFactory;
    private final JoinCompiler joinCompiler;
    private final LookupJoinOperators lookupJoinOperators;
    private final OrderingCompiler orderingCompiler;
    private final JsonCodec<TableCommitContext> tableCommitContextCodec;
    private static final TypeSignature SPHERICAL_GEOGRAPHY_TYPE_SIGNATURE = TypeSignature.parseTypeSignature((String)"SphericalGeography");

    @Inject
    public LocalExecutionPlanner(Metadata metadata, Optional<ExplainAnalyzeContext> explainAnalyzeContext, PageSourceProvider pageSourceProvider, IndexManager indexManager, PartitioningProviderManager partitioningProviderManager, NodePartitioningManager nodePartitioningManager, PageSinkManager pageSinkManager, ExpressionCompiler expressionCompiler, PageFunctionCompiler pageFunctionCompiler, JoinFilterFunctionCompiler joinFilterFunctionCompiler, IndexJoinLookupStats indexJoinLookupStats, TaskManagerConfig taskManagerConfig, SpillerFactory spillerFactory, SingleStreamSpillerFactory singleStreamSpillerFactory, PartitioningSpillerFactory partitioningSpillerFactory, BlockEncodingSerde blockEncodingSerde, PagesIndex.Factory pagesIndexFactory, JoinCompiler joinCompiler, LookupJoinOperators lookupJoinOperators, OrderingCompiler orderingCompiler, JsonCodec<TableCommitContext> tableCommitContextCodec) {
        this.explainAnalyzeContext = Objects.requireNonNull(explainAnalyzeContext, "explainAnalyzeContext is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.indexManager = Objects.requireNonNull(indexManager, "indexManager is null");
        this.partitioningProviderManager = Objects.requireNonNull(partitioningProviderManager, "partitioningProviderManager is null");
        this.nodePartitioningManager = Objects.requireNonNull(nodePartitioningManager, "nodePartitioningManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.pageSinkManager = Objects.requireNonNull(pageSinkManager, "pageSinkManager is null");
        this.expressionCompiler = Objects.requireNonNull(expressionCompiler, "compiler is null");
        this.pageFunctionCompiler = Objects.requireNonNull(pageFunctionCompiler, "pageFunctionCompiler is null");
        this.joinFilterFunctionCompiler = Objects.requireNonNull(joinFilterFunctionCompiler, "compiler is null");
        this.indexJoinLookupStats = Objects.requireNonNull(indexJoinLookupStats, "indexJoinLookupStats is null");
        this.maxIndexMemorySize = Objects.requireNonNull(taskManagerConfig, "taskManagerConfig is null").getMaxIndexMemoryUsage();
        this.spillerFactory = Objects.requireNonNull(spillerFactory, "spillerFactory is null");
        this.singleStreamSpillerFactory = Objects.requireNonNull(singleStreamSpillerFactory, "singleStreamSpillerFactory is null");
        this.partitioningSpillerFactory = Objects.requireNonNull(partitioningSpillerFactory, "partitioningSpillerFactory is null");
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        this.maxPartialAggregationMemorySize = taskManagerConfig.getMaxPartialAggregationMemoryUsage();
        this.maxPagePartitioningBufferSize = taskManagerConfig.getMaxPagePartitioningBufferSize();
        this.maxLocalExchangeBufferSize = taskManagerConfig.getMaxLocalExchangeBufferSize();
        this.pagesIndexFactory = Objects.requireNonNull(pagesIndexFactory, "pagesIndexFactory is null");
        this.joinCompiler = Objects.requireNonNull(joinCompiler, "joinCompiler is null");
        this.lookupJoinOperators = Objects.requireNonNull(lookupJoinOperators, "lookupJoinOperators is null");
        this.orderingCompiler = Objects.requireNonNull(orderingCompiler, "orderingCompiler is null");
        this.tableCommitContextCodec = Objects.requireNonNull(tableCommitContextCodec, "tableCommitContextCodec is null");
    }

    public LocalExecutionPlan plan(TaskContext taskContext, PlanNode plan, PartitioningScheme partitioningScheme, StageExecutionDescriptor stageExecutionDescriptor, List<PlanNodeId> partitionedSourceOrder, OutputBuffer outputBuffer, RemoteSourceFactory remoteSourceFactory, TableWriteInfo tableWriteInfo) {
        return this.plan(taskContext, plan, partitioningScheme, stageExecutionDescriptor, partitionedSourceOrder, this.createOutputFactory(taskContext, partitioningScheme, outputBuffer), remoteSourceFactory, tableWriteInfo, false);
    }

    public LocalExecutionPlan plan(TaskContext taskContext, PlanNode plan, PartitioningScheme partitioningScheme, StageExecutionDescriptor stageExecutionDescriptor, List<PlanNodeId> partitionedSourceOrder, OutputFactory outputFactory, RemoteSourceFactory remoteSourceFactory, TableWriteInfo tableWriteInfo, boolean pageSinkCommitRequired) {
        return this.plan(taskContext, stageExecutionDescriptor, plan, partitioningScheme.getOutputLayout(), partitionedSourceOrder, outputFactory, this.createOutputPartitioning(taskContext, partitioningScheme), remoteSourceFactory, tableWriteInfo, pageSinkCommitRequired);
    }

    private OutputFactory createOutputFactory(TaskContext taskContext, PartitioningScheme partitioningScheme, OutputBuffer outputBuffer) {
        if (partitioningScheme.getPartitioning().getHandle().equals(SystemPartitioningHandle.FIXED_BROADCAST_DISTRIBUTION) || partitioningScheme.getPartitioning().getHandle().equals(SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION) || partitioningScheme.getPartitioning().getHandle().equals(SystemPartitioningHandle.SCALED_WRITER_DISTRIBUTION) || partitioningScheme.getPartitioning().getHandle().equals(SystemPartitioningHandle.SINGLE_DISTRIBUTION) || partitioningScheme.getPartitioning().getHandle().equals(SystemPartitioningHandle.COORDINATOR_DISTRIBUTION)) {
            return new TaskOutputOperator.TaskOutputFactory(outputBuffer);
        }
        if (SystemSessionProperties.isOptimizedRepartitioningEnabled(taskContext.getSession())) {
            return new OptimizedPartitionedOutputOperator.OptimizedPartitionedOutputFactory(outputBuffer, this.maxPagePartitioningBufferSize);
        }
        return new PartitionedOutputOperator.PartitionedOutputFactory(outputBuffer, this.maxPagePartitioningBufferSize);
    }

    private Optional<OutputPartitioning> createOutputPartitioning(TaskContext taskContext, PartitioningScheme partitioningScheme) {
        Object partitionChannelTypes;
        Object partitionConstants;
        Object partitionChannels;
        if (partitioningScheme.getPartitioning().getHandle().equals(SystemPartitioningHandle.FIXED_BROADCAST_DISTRIBUTION) || partitioningScheme.getPartitioning().getHandle().equals(SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION) || partitioningScheme.getPartitioning().getHandle().equals(SystemPartitioningHandle.SCALED_WRITER_DISTRIBUTION) || partitioningScheme.getPartitioning().getHandle().equals(SystemPartitioningHandle.SINGLE_DISTRIBUTION) || partitioningScheme.getPartitioning().getHandle().equals(SystemPartitioningHandle.COORDINATOR_DISTRIBUTION)) {
            return Optional.empty();
        }
        List<VariableReferenceExpression> outputLayout = partitioningScheme.getOutputLayout();
        if (partitioningScheme.getHashColumn().isPresent()) {
            partitionChannels = ImmutableList.of((Object)outputLayout.indexOf(partitioningScheme.getHashColumn().get()));
            partitionConstants = ImmutableList.of(Optional.empty());
            partitionChannelTypes = ImmutableList.of((Object)BigintType.BIGINT);
        } else {
            Preconditions.checkArgument((boolean)partitioningScheme.getPartitioning().getArguments().stream().allMatch(argument -> argument instanceof ConstantExpression || argument instanceof VariableReferenceExpression), (Object)String.format("Expect all partitioning arguments to be either ConstantExpression or VariableReferenceExpression, but get %s", partitioningScheme.getPartitioning().getArguments()));
            partitionChannels = (List)partitioningScheme.getPartitioning().getArguments().stream().map(argument -> {
                if (argument instanceof ConstantExpression) {
                    return -1;
                }
                return outputLayout.indexOf(argument);
            }).collect(ImmutableList.toImmutableList());
            partitionConstants = (List)partitioningScheme.getPartitioning().getArguments().stream().map(argument -> {
                if (argument instanceof ConstantExpression) {
                    return Optional.of((ConstantExpression)argument);
                }
                return Optional.empty();
            }).collect(ImmutableList.toImmutableList());
            partitionChannelTypes = (List)partitioningScheme.getPartitioning().getArguments().stream().map(RowExpression::getType).collect(ImmutableList.toImmutableList());
        }
        PartitionFunction partitionFunction = this.nodePartitioningManager.getPartitionFunction(taskContext.getSession(), partitioningScheme, (List<Type>)partitionChannelTypes);
        OptionalInt nullChannel = OptionalInt.empty();
        Set<VariableReferenceExpression> partitioningColumns = partitioningScheme.getPartitioning().getVariableReferences();
        Preconditions.checkArgument((!partitioningScheme.isReplicateNullsAndAny() || partitioningColumns.size() <= 1 ? 1 : 0) != 0);
        if (partitioningScheme.isReplicateNullsAndAny() && partitioningColumns.size() == 1) {
            nullChannel = OptionalInt.of(outputLayout.indexOf(Iterables.getOnlyElement(partitioningColumns)));
        }
        return Optional.of(new OutputPartitioning(partitionFunction, (List<Integer>)partitionChannels, (List<Optional<ConstantExpression>>)partitionConstants, partitioningScheme.isReplicateNullsAndAny(), nullChannel));
    }

    @VisibleForTesting
    public LocalExecutionPlan plan(TaskContext taskContext, StageExecutionDescriptor stageExecutionDescriptor, PlanNode plan, List<VariableReferenceExpression> outputLayout, List<PlanNodeId> partitionedSourceOrder, OutputFactory outputOperatorFactory, Optional<OutputPartitioning> outputPartitioning, RemoteSourceFactory remoteSourceFactory, TableWriteInfo tableWriteInfo, boolean pageSinkCommitRequired) {
        Session session = taskContext.getSession();
        LocalExecutionPlanContext context = new LocalExecutionPlanContext(taskContext, tableWriteInfo);
        PhysicalOperation physicalOperation = (PhysicalOperation)plan.accept((PlanVisitor)new Visitor(session, stageExecutionDescriptor, remoteSourceFactory, pageSinkCommitRequired), (Object)context);
        Function<Page, Page> pagePreprocessor = LocalExecutionPlanner.enforceLayoutProcessor(outputLayout, physicalOperation.getLayout());
        List outputTypes = (List)outputLayout.stream().map(VariableReferenceExpression::getType).collect(ImmutableList.toImmutableList());
        context.addDriverFactory(context.isInputDriver(), true, (List<OperatorFactory>)ImmutableList.builder().addAll((Iterable)physicalOperation.getOperatorFactories()).add((Object)outputOperatorFactory.createOutputOperator(context.getNextOperatorId(), plan.getId(), outputTypes, pagePreprocessor, outputPartitioning, new PagesSerdeFactory(this.blockEncodingSerde, SystemSessionProperties.isExchangeCompressionEnabled(session)))).build(), context.getDriverInstanceCount(), physicalOperation.getPipelineExecutionStrategy());
        LocalExecutionPlanner.addLookupOuterDrivers(context);
        context.getDriverFactories().stream().map(DriverFactory::getOperatorFactories).flatMap(Collection::stream).filter(LocalPlannerAware.class::isInstance).map(LocalPlannerAware.class::cast).forEach(LocalPlannerAware::localPlannerComplete);
        return new LocalExecutionPlan(context.getDriverFactories(), partitionedSourceOrder, stageExecutionDescriptor);
    }

    private static void addLookupOuterDrivers(LocalExecutionPlanContext context) {
        for (DriverFactory factory : context.getDriverFactories()) {
            List<OperatorFactory> operatorFactories = factory.getOperatorFactories();
            for (int i = 0; i < operatorFactories.size(); ++i) {
                JoinOperatorFactory lookupJoin;
                Optional<JoinOperatorFactory.OuterOperatorFactoryResult> outerOperatorFactoryResult;
                OperatorFactory operatorFactory = operatorFactories.get(i);
                if (!(operatorFactory instanceof JoinOperatorFactory) || !(outerOperatorFactoryResult = (lookupJoin = (JoinOperatorFactory)operatorFactory).createOuterOperatorFactory()).isPresent()) continue;
                ImmutableList.Builder newOperators = ImmutableList.builder();
                newOperators.add((Object)outerOperatorFactoryResult.get().getOuterOperatorFactory());
                operatorFactories.subList(i + 1, operatorFactories.size()).stream().map(OperatorFactory::duplicate).forEach(arg_0 -> ((ImmutableList.Builder)newOperators).add(arg_0));
                context.addDriverFactory(false, factory.isOutputDriver(), (List<OperatorFactory>)newOperators.build(), OptionalInt.of(1), outerOperatorFactoryResult.get().getBuildExecutionStrategy());
            }
        }
    }

    private static TableFinishOperator.TableFinisher createTableFinisher(Session session, Metadata metadata, ExecutionWriterTarget target) {
        return (fragments, statistics) -> {
            if (target instanceof ExecutionWriterTarget.CreateHandle) {
                return metadata.finishCreateTable(session, ((ExecutionWriterTarget.CreateHandle)target).getHandle(), fragments, statistics);
            }
            if (target instanceof ExecutionWriterTarget.InsertHandle) {
                return metadata.finishInsert(session, ((ExecutionWriterTarget.InsertHandle)target).getHandle(), fragments, statistics);
            }
            if (target instanceof ExecutionWriterTarget.DeleteHandle) {
                metadata.finishDelete(session, ((ExecutionWriterTarget.DeleteHandle)target).getHandle(), fragments);
                return Optional.empty();
            }
            throw new AssertionError((Object)("Unhandled target type: " + target.getClass().getName()));
        };
    }

    private static TableFinishOperator.PageSinkCommitter createPageSinkCommitter(Session session, Metadata metadata, ExecutionWriterTarget target) {
        return fragments -> {
            if (target instanceof ExecutionWriterTarget.CreateHandle) {
                return metadata.commitPageSinkAsync(session, ((ExecutionWriterTarget.CreateHandle)target).getHandle(), (Collection<Slice>)fragments);
            }
            if (target instanceof ExecutionWriterTarget.InsertHandle) {
                return metadata.commitPageSinkAsync(session, ((ExecutionWriterTarget.InsertHandle)target).getHandle(), (Collection<Slice>)fragments);
            }
            throw new AssertionError((Object)("Unhandled target type: " + target.getClass().getName()));
        };
    }

    private static Function<Page, Page> enforceLayoutProcessor(List<VariableReferenceExpression> expectedLayout, Map<VariableReferenceExpression, Integer> inputLayout) {
        int[] channels = expectedLayout.stream().peek(variable -> Preconditions.checkArgument((boolean)inputLayout.containsKey(variable), (String)"channel not found for variable: %s", (Object)variable)).mapToInt(inputLayout::get).toArray();
        if (Arrays.equals(channels, IntStream.range(0, inputLayout.size()).toArray())) {
            return Function.identity();
        }
        return new PageChannelSelector(channels);
    }

    private static List<Integer> getChannelsForVariables(Collection<VariableReferenceExpression> variables, Map<VariableReferenceExpression, Integer> layout) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (VariableReferenceExpression variable : variables) {
            Preconditions.checkArgument((boolean)layout.containsKey(variable));
            builder.add((Object)layout.get(variable));
        }
        return builder.build();
    }

    private static Function<VariableReferenceExpression, Integer> variableChannelGetter(PhysicalOperation source) {
        return input -> {
            Preconditions.checkArgument((boolean)source.getLayout().containsKey(input));
            return source.getLayout().get(input);
        };
    }

    private static List<SortOrder> getOrderingList(OrderingScheme orderingScheme) {
        return (List)orderingScheme.getOrderByVariables().stream().map(orderingScheme.getOrderingsMap()::get).collect(ImmutableList.toImmutableList());
    }

    private static class DriverFactoryParameters {
        private final LocalExecutionPlanContext subContext;
        private final PhysicalOperation source;

        public DriverFactoryParameters(LocalExecutionPlanContext subContext, PhysicalOperation source) {
            this.subContext = subContext;
            this.source = source;
        }

        public LocalExecutionPlanContext getSubContext() {
            return this.subContext;
        }

        public PhysicalOperation getSource() {
            return this.source;
        }
    }

    private static class PhysicalOperation {
        private final List<OperatorFactory> operatorFactories;
        private final Map<VariableReferenceExpression, Integer> layout;
        private final List<Type> types;
        private final PipelineExecutionStrategy pipelineExecutionStrategy;

        public PhysicalOperation(OperatorFactory operatorFactory, Map<VariableReferenceExpression, Integer> layout, LocalExecutionPlanContext context, PipelineExecutionStrategy pipelineExecutionStrategy) {
            this(operatorFactory, layout, context, Optional.empty(), pipelineExecutionStrategy);
        }

        public PhysicalOperation(OperatorFactory operatorFactory, Map<VariableReferenceExpression, Integer> layout, LocalExecutionPlanContext context, PhysicalOperation source) {
            this(operatorFactory, layout, context, Optional.of(Objects.requireNonNull(source, "source is null")), source.getPipelineExecutionStrategy());
        }

        private PhysicalOperation(OperatorFactory operatorFactory, Map<VariableReferenceExpression, Integer> layout, LocalExecutionPlanContext context, Optional<PhysicalOperation> source, PipelineExecutionStrategy pipelineExecutionStrategy) {
            Objects.requireNonNull(operatorFactory, "operatorFactory is null");
            Objects.requireNonNull(layout, "layout is null");
            Objects.requireNonNull(context, "context is null");
            Objects.requireNonNull(source, "source is null");
            Objects.requireNonNull(pipelineExecutionStrategy, "pipelineExecutionStrategy is null");
            this.operatorFactories = ImmutableList.builder().addAll((Iterable)source.map(PhysicalOperation::getOperatorFactories).orElse((List)ImmutableList.of())).add((Object)operatorFactory).build();
            this.layout = ImmutableMap.copyOf(layout);
            this.types = PhysicalOperation.toTypes(layout);
            this.pipelineExecutionStrategy = pipelineExecutionStrategy;
        }

        private static List<Type> toTypes(Map<VariableReferenceExpression, Integer> layout) {
            int channelCount = layout.values().stream().mapToInt(Integer::intValue).max().orElse(-1) + 1;
            Preconditions.checkArgument((layout.size() == channelCount && ImmutableSet.copyOf(layout.values()).containsAll((Collection)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(channelCount)), (DiscreteDomain)DiscreteDomain.integers())) ? 1 : 0) != 0, (String)"Layout does not have a variable for every output channel: %s", layout);
            ImmutableBiMap channelLayout = ImmutableBiMap.copyOf(layout).inverse();
            return (List)IntStream.range(0, channelCount).mapToObj(((Map)channelLayout)::get).map(VariableReferenceExpression::getType).collect(ImmutableList.toImmutableList());
        }

        private int variableToChannel(VariableReferenceExpression input) {
            Preconditions.checkArgument((boolean)this.layout.containsKey(input));
            return this.layout.get(input);
        }

        public List<Type> getTypes() {
            return this.types;
        }

        public Map<VariableReferenceExpression, Integer> getLayout() {
            return this.layout;
        }

        private List<OperatorFactory> getOperatorFactories() {
            return this.operatorFactories;
        }

        public PipelineExecutionStrategy getPipelineExecutionStrategy() {
            return this.pipelineExecutionStrategy;
        }
    }

    private class Visitor
    extends InternalPlanVisitor<PhysicalOperation, LocalExecutionPlanContext> {
        private final Session session;
        private final StageExecutionDescriptor stageExecutionDescriptor;
        private final RemoteSourceFactory remoteSourceFactory;
        private final boolean pageSinkCommitRequired;

        private Visitor(Session session, StageExecutionDescriptor stageExecutionDescriptor, RemoteSourceFactory remoteSourceFactory, boolean pageSinkCommitRequired) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.stageExecutionDescriptor = Objects.requireNonNull(stageExecutionDescriptor, "stageExecutionDescriptor is null");
            this.remoteSourceFactory = Objects.requireNonNull(remoteSourceFactory, "remoteSourceFactory is null");
            this.pageSinkCommitRequired = pageSinkCommitRequired;
        }

        @Override
        public PhysicalOperation visitRemoteSource(RemoteSourceNode node, LocalExecutionPlanContext context) {
            if (node.getOrderingScheme().isPresent()) {
                return this.createMergeSource(node, context);
            }
            return this.createRemoteSource(node, context);
        }

        private PhysicalOperation createMergeSource(RemoteSourceNode node, LocalExecutionPlanContext context) {
            Preconditions.checkArgument((boolean)node.getOrderingScheme().isPresent(), (Object)"orderingScheme is absent");
            context.setDriverInstanceCount(1);
            OrderingScheme orderingScheme = node.getOrderingScheme().get();
            ImmutableMap<VariableReferenceExpression, Integer> layout = this.makeLayout(node);
            List sortChannels = LocalExecutionPlanner.getChannelsForVariables(orderingScheme.getOrderByVariables(), layout);
            List sortOrder = LocalExecutionPlanner.getOrderingList(orderingScheme);
            List<Type> types = this.getSourceOperatorTypes(node);
            ImmutableList outputChannels = (ImmutableList)IntStream.range(0, types.size()).boxed().collect(ImmutableList.toImmutableList());
            OperatorFactory operatorFactory = this.remoteSourceFactory.createMergeRemoteSource(this.session, context.getNextOperatorId(), node.getId(), types, (List<Integer>)outputChannels, sortChannels, sortOrder);
            return new PhysicalOperation(operatorFactory, (Map<VariableReferenceExpression, Integer>)this.makeLayout(node), context, PipelineExecutionStrategy.UNGROUPED_EXECUTION);
        }

        private PhysicalOperation createRemoteSource(RemoteSourceNode node, LocalExecutionPlanContext context) {
            if (node.isEnsureSourceOrdering()) {
                context.setDriverInstanceCount(1);
            } else if (!context.getDriverInstanceCount().isPresent()) {
                context.setDriverInstanceCount(SystemSessionProperties.getTaskConcurrency(this.session));
            }
            OperatorFactory operatorFactory = this.remoteSourceFactory.createRemoteSource(this.session, context.getNextOperatorId(), node.getId(), this.getSourceOperatorTypes(node));
            return new PhysicalOperation(operatorFactory, (Map<VariableReferenceExpression, Integer>)this.makeLayout(node), context, PipelineExecutionStrategy.UNGROUPED_EXECUTION);
        }

        @Override
        public PhysicalOperation visitExplainAnalyze(ExplainAnalyzeNode node, LocalExecutionPlanContext context) {
            ExplainAnalyzeContext analyzeContext = (ExplainAnalyzeContext)LocalExecutionPlanner.this.explainAnalyzeContext.orElseThrow(() -> new IllegalStateException("ExplainAnalyze can only run on coordinator"));
            PhysicalOperation source = (PhysicalOperation)node.getSource().accept((PlanVisitor)this, (Object)context);
            ExplainAnalyzeOperator.ExplainAnalyzeOperatorFactory operatorFactory = new ExplainAnalyzeOperator.ExplainAnalyzeOperatorFactory(context.getNextOperatorId(), node.getId(), analyzeContext.getQueryPerformanceFetcher(), LocalExecutionPlanner.this.metadata.getFunctionManager(), node.isVerbose());
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<VariableReferenceExpression, Integer>)this.makeLayout(node), context, source);
        }

        @Override
        public PhysicalOperation visitOutput(OutputNode node, LocalExecutionPlanContext context) {
            return (PhysicalOperation)node.getSource().accept((PlanVisitor)this, (Object)context);
        }

        @Override
        public PhysicalOperation visitRowNumber(RowNumberNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = (PhysicalOperation)node.getSource().accept((PlanVisitor)this, (Object)context);
            List partitionChannels = LocalExecutionPlanner.getChannelsForVariables(node.getPartitionBy(), source.getLayout());
            List partitionTypes = (List)partitionChannels.stream().map(channel -> source.getTypes().get((int)channel)).collect(ImmutableList.toImmutableList());
            ImmutableList.Builder outputChannels = ImmutableList.builder();
            for (int i = 0; i < source.getTypes().size(); ++i) {
                outputChannels.add((Object)i);
            }
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            outputMappings.putAll(source.getLayout());
            int channel2 = source.getTypes().size();
            outputMappings.put((Object)node.getRowNumberVariable(), (Object)channel2);
            Optional<Integer> hashChannel = node.getHashVariable().map(LocalExecutionPlanner.variableChannelGetter(source));
            RowNumberOperator.RowNumberOperatorFactory operatorFactory = new RowNumberOperator.RowNumberOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), (List<Integer>)outputChannels.build(), partitionChannels, partitionTypes, node.getMaxRowCountPerPartition(), hashChannel, 10000, LocalExecutionPlanner.this.joinCompiler);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<VariableReferenceExpression, Integer>)outputMappings.build(), context, source);
        }

        @Override
        public PhysicalOperation visitTopNRowNumber(TopNRowNumberNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = (PhysicalOperation)node.getSource().accept((PlanVisitor)this, (Object)context);
            List partitionChannels = LocalExecutionPlanner.getChannelsForVariables(node.getPartitionBy(), source.getLayout());
            List partitionTypes = (List)partitionChannels.stream().map(channel -> source.getTypes().get((int)channel)).collect(ImmutableList.toImmutableList());
            List orderByVariables = node.getOrderingScheme().getOrderByVariables();
            List sortChannels = LocalExecutionPlanner.getChannelsForVariables(orderByVariables, source.getLayout());
            List sortOrder = (List)orderByVariables.stream().map(variable -> node.getOrderingScheme().getOrdering(variable)).collect(ImmutableList.toImmutableList());
            ImmutableList.Builder outputChannels = ImmutableList.builder();
            for (int i = 0; i < source.getTypes().size(); ++i) {
                outputChannels.add((Object)i);
            }
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            outputMappings.putAll(source.getLayout());
            if (!node.isPartial() || !partitionChannels.isEmpty()) {
                int channel2 = source.getTypes().size();
                outputMappings.put((Object)node.getRowNumberVariable(), (Object)channel2);
            }
            Optional<Integer> hashChannel = node.getHashVariable().map(LocalExecutionPlanner.variableChannelGetter(source));
            TopNRowNumberOperator.TopNRowNumberOperatorFactory operatorFactory = new TopNRowNumberOperator.TopNRowNumberOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), (List<Integer>)outputChannels.build(), partitionChannels, partitionTypes, sortChannels, sortOrder, node.getMaxRowCountPerPartition(), node.isPartial(), hashChannel, 1000, LocalExecutionPlanner.this.joinCompiler);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<VariableReferenceExpression, Integer>)this.makeLayout(node), context, source);
        }

        @Override
        public PhysicalOperation visitWindow(WindowNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = (PhysicalOperation)node.getSource().accept((PlanVisitor)this, (Object)context);
            ImmutableList partitionChannels = ImmutableList.copyOf((Collection)LocalExecutionPlanner.getChannelsForVariables(node.getPartitionBy(), source.getLayout()));
            ImmutableList preGroupedChannels = ImmutableList.copyOf((Collection)LocalExecutionPlanner.getChannelsForVariables(node.getPrePartitionedInputs(), source.getLayout()));
            Object sortChannels = ImmutableList.of();
            Object sortOrder = ImmutableList.of();
            if (node.getOrderingScheme().isPresent()) {
                OrderingScheme orderingScheme = node.getOrderingScheme().get();
                sortChannels = LocalExecutionPlanner.getChannelsForVariables(orderingScheme.getOrderByVariables(), source.getLayout());
                sortOrder = LocalExecutionPlanner.getOrderingList(orderingScheme);
            }
            ImmutableList.Builder outputChannels = ImmutableList.builder();
            for (int i = 0; i < source.getTypes().size(); ++i) {
                outputChannels.add((Object)i);
            }
            ImmutableList.Builder windowFunctionsBuilder = ImmutableList.builder();
            ImmutableList.Builder windowFunctionOutputVariablesBuilder = ImmutableList.builder();
            for (Map.Entry<VariableReferenceExpression, WindowNode.Function> entry : node.getWindowFunctions().entrySet()) {
                Optional<Integer> frameStartChannel = Optional.empty();
                Optional<Integer> frameEndChannel = Optional.empty();
                WindowNode.Frame frame = entry.getValue().getFrame();
                if (frame.getStartValue().isPresent()) {
                    frameStartChannel = Optional.of(source.getLayout().get(frame.getStartValue().get()));
                }
                if (frame.getEndValue().isPresent()) {
                    frameEndChannel = Optional.of(source.getLayout().get(frame.getEndValue().get()));
                }
                FrameInfo frameInfo = new FrameInfo(frame.getType(), frame.getStartType(), frameStartChannel, frame.getEndType(), frameEndChannel);
                WindowNode.Function function = entry.getValue();
                CallExpression call = function.getFunctionCall();
                FunctionHandle functionHandle = function.getFunctionHandle();
                ImmutableList.Builder arguments = ImmutableList.builder();
                for (RowExpression argument : call.getArguments()) {
                    Preconditions.checkState((boolean)(argument instanceof VariableReferenceExpression));
                    arguments.add((Object)source.getLayout().get(argument));
                }
                VariableReferenceExpression variable = entry.getKey();
                FunctionManager functionManager = LocalExecutionPlanner.this.metadata.getFunctionManager();
                WindowFunctionSupplier windowFunctionSupplier = functionManager.getWindowFunctionImplementation(functionHandle);
                Type type = LocalExecutionPlanner.this.metadata.getType(functionManager.getFunctionMetadata(functionHandle).getReturnType());
                windowFunctionsBuilder.add((Object)WindowFunctionDefinition.window(windowFunctionSupplier, type, frameInfo, function.isIgnoreNulls(), (List<Integer>)arguments.build()));
                windowFunctionOutputVariablesBuilder.add((Object)variable);
            }
            ImmutableList windowFunctionOutputVariables = windowFunctionOutputVariablesBuilder.build();
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            for (Object variable : node.getSource().getOutputVariables()) {
                outputMappings.put(variable, (Object)source.getLayout().get(variable));
            }
            int channel = source.getTypes().size();
            for (VariableReferenceExpression variable : windowFunctionOutputVariables) {
                outputMappings.put((Object)variable, (Object)channel);
                ++channel;
            }
            WindowOperator.WindowOperatorFactory operatorFactory = new WindowOperator.WindowOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), (List<Integer>)outputChannels.build(), (List<WindowFunctionDefinition>)windowFunctionsBuilder.build(), (List<Integer>)partitionChannels, (List<Integer>)preGroupedChannels, (List<Integer>)sortChannels, (List<SortOrder>)sortOrder, node.getPreSortedOrderPrefix(), 10000, LocalExecutionPlanner.this.pagesIndexFactory);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<VariableReferenceExpression, Integer>)outputMappings.build(), context, source);
        }

        public PhysicalOperation visitTopN(TopNNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = (PhysicalOperation)node.getSource().accept((PlanVisitor)this, (Object)context);
            List orderByVariables = node.getOrderingScheme().getOrderByVariables();
            ArrayList<Integer> sortChannels = new ArrayList<Integer>();
            ArrayList<SortOrder> sortOrders = new ArrayList<SortOrder>();
            for (VariableReferenceExpression variable : orderByVariables) {
                sortChannels.add(source.getLayout().get(variable));
                sortOrders.add(node.getOrderingScheme().getOrdering(variable));
            }
            TopNOperator.TopNOperatorFactory operator = new TopNOperator.TopNOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), (int)node.getCount(), sortChannels, sortOrders);
            return new PhysicalOperation((OperatorFactory)operator, source.getLayout(), context, source);
        }

        @Override
        public PhysicalOperation visitSort(SortNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = (PhysicalOperation)node.getSource().accept((PlanVisitor)this, (Object)context);
            List orderByVariables = node.getOrderingScheme().getOrderByVariables();
            List orderByChannels = LocalExecutionPlanner.getChannelsForVariables(orderByVariables, source.getLayout());
            ImmutableList.Builder sortOrder = ImmutableList.builder();
            for (VariableReferenceExpression variable : orderByVariables) {
                sortOrder.add((Object)node.getOrderingScheme().getOrdering(variable));
            }
            ImmutableList.Builder outputChannels = ImmutableList.builder();
            for (int i = 0; i < source.getTypes().size(); ++i) {
                outputChannels.add((Object)i);
            }
            OrderByOperator.OrderByOperatorFactory operator = new OrderByOperator.OrderByOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), (List<Integer>)outputChannels.build(), 10000, orderByChannels, (List<SortOrder>)sortOrder.build(), LocalExecutionPlanner.this.pagesIndexFactory);
            return new PhysicalOperation((OperatorFactory)operator, source.getLayout(), context, source);
        }

        public PhysicalOperation visitLimit(LimitNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = (PhysicalOperation)node.getSource().accept((PlanVisitor)this, (Object)context);
            LimitOperator.LimitOperatorFactory operatorFactory = new LimitOperator.LimitOperatorFactory(context.getNextOperatorId(), node.getId(), node.getCount());
            return new PhysicalOperation((OperatorFactory)operatorFactory, source.getLayout(), context, source);
        }

        @Override
        public PhysicalOperation visitDistinctLimit(DistinctLimitNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = (PhysicalOperation)node.getSource().accept((PlanVisitor)this, (Object)context);
            Optional<Integer> hashChannel = node.getHashVariable().map(LocalExecutionPlanner.variableChannelGetter(source));
            List distinctChannels = LocalExecutionPlanner.getChannelsForVariables(node.getDistinctVariables(), source.getLayout());
            DistinctLimitOperator.DistinctLimitOperatorFactory operatorFactory = new DistinctLimitOperator.DistinctLimitOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), distinctChannels, node.getLimit(), hashChannel, LocalExecutionPlanner.this.joinCompiler);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<VariableReferenceExpression, Integer>)this.makeLayout(node), context, source);
        }

        @Override
        public PhysicalOperation visitGroupId(GroupIdNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = (PhysicalOperation)node.getSource().accept((PlanVisitor)this, (Object)context);
            HashMap<VariableReferenceExpression, Integer> newLayout = new HashMap<VariableReferenceExpression, Integer>();
            ImmutableList.Builder outputTypes = ImmutableList.builder();
            int outputChannel = 0;
            for (Object output : node.getGroupingSets().stream().flatMap(Collection::stream).collect(Collectors.toSet())) {
                newLayout.put((VariableReferenceExpression)output, outputChannel++);
                outputTypes.add((Object)source.getTypes().get(source.getLayout().get(node.getGroupingColumns().get(output))));
            }
            HashMap<VariableReferenceExpression, Integer> argumentMappings = new HashMap<VariableReferenceExpression, Integer>();
            for (VariableReferenceExpression variableReferenceExpression : node.getAggregationArguments()) {
                int n = source.getLayout().get(variableReferenceExpression);
                newLayout.put(variableReferenceExpression, outputChannel++);
                outputTypes.add((Object)source.getTypes().get(n));
                argumentMappings.put(variableReferenceExpression, n);
            }
            ImmutableList.Builder mappings = ImmutableList.builder();
            for (List<VariableReferenceExpression> list : node.getGroupingSets()) {
                ImmutableMap.Builder setMapping = ImmutableMap.builder();
                for (VariableReferenceExpression output : list) {
                    setMapping.put(newLayout.get(output), (Object)source.getLayout().get(node.getGroupingColumns().get(output)));
                }
                for (VariableReferenceExpression output : argumentMappings.keySet()) {
                    setMapping.put(newLayout.get(output), argumentMappings.get(output));
                }
                mappings.add((Object)setMapping.build());
            }
            newLayout.put(node.getGroupIdVariable(), outputChannel);
            outputTypes.add((Object)BigintType.BIGINT);
            GroupIdOperator.GroupIdOperatorFactory groupIdOperatorFactory = new GroupIdOperator.GroupIdOperatorFactory(context.getNextOperatorId(), node.getId(), (List<? extends Type>)outputTypes.build(), (List<Map<Integer, Integer>>)mappings.build());
            return new PhysicalOperation((OperatorFactory)groupIdOperatorFactory, newLayout, context, source);
        }

        public PhysicalOperation visitAggregation(AggregationNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = (PhysicalOperation)node.getSource().accept((PlanVisitor)this, (Object)context);
            if (node.getGroupingKeys().isEmpty()) {
                return this.planGlobalAggregation(node, source, context);
            }
            boolean spillEnabled = SystemSessionProperties.isSpillEnabled(context.getSession());
            DataSize unspillMemoryLimit = SystemSessionProperties.getAggregationOperatorUnspillMemoryLimit(context.getSession());
            return this.planGroupByAggregation(node, source, spillEnabled, unspillMemoryLimit, context);
        }

        public PhysicalOperation visitMarkDistinct(MarkDistinctNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = (PhysicalOperation)node.getSource().accept((PlanVisitor)this, (Object)context);
            List channels = LocalExecutionPlanner.getChannelsForVariables(node.getDistinctVariables(), source.getLayout());
            Optional<Integer> hashChannel = node.getHashVariable().map(LocalExecutionPlanner.variableChannelGetter(source));
            MarkDistinctOperator.MarkDistinctOperatorFactory operator = new MarkDistinctOperator.MarkDistinctOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), channels, hashChannel, LocalExecutionPlanner.this.joinCompiler);
            return new PhysicalOperation((OperatorFactory)operator, (Map<VariableReferenceExpression, Integer>)this.makeLayout((PlanNode)node), context, source);
        }

        @Override
        public PhysicalOperation visitSample(SampleNode node, LocalExecutionPlanContext context) {
            if (node.getSampleType() == SampleNode.Type.SYSTEM) {
                return (PhysicalOperation)node.getSource().accept((PlanVisitor)this, (Object)context);
            }
            throw new UnsupportedOperationException("not yet implemented: " + (Object)((Object)node));
        }

        public PhysicalOperation visitFilter(FilterNode node, LocalExecutionPlanContext context) {
            PlanNode sourceNode = node.getSource();
            RowExpression filterExpression = node.getPredicate();
            List outputVariables = node.getOutputVariables();
            return this.visitScanFilterAndProject(context, node.getId(), sourceNode, Optional.of(filterExpression), AssignmentUtils.identityAssignments(outputVariables), outputVariables);
        }

        public PhysicalOperation visitProject(ProjectNode node, LocalExecutionPlanContext context) {
            PlanNode sourceNode;
            Optional<RowExpression> filterExpression = Optional.empty();
            if (node.getSource() instanceof FilterNode) {
                FilterNode filterNode = (FilterNode)node.getSource();
                sourceNode = filterNode.getSource();
                filterExpression = Optional.of(filterNode.getPredicate());
            } else {
                sourceNode = node.getSource();
            }
            return this.visitScanFilterAndProject(context, node.getId(), sourceNode, filterExpression, node.getAssignments(), node.getOutputVariables());
        }

        private PhysicalOperation visitScanFilterAndProject(LocalExecutionPlanContext context, PlanNodeId planNodeId, PlanNode sourceNode, Optional<RowExpression> filterExpression, Assignments assignments, List<VariableReferenceExpression> outputVariables) {
            Map<VariableReferenceExpression, Integer> sourceLayout;
            TableHandle table = null;
            ArrayList<ColumnHandle> columns = null;
            PhysicalOperation source = null;
            if (sourceNode instanceof TableScanNode) {
                TableScanNode tableScanNode = (TableScanNode)sourceNode;
                Optional<TableWriteInfo.DeleteScanInfo> deleteScanInfo = context.getTableWriteInfo().getDeleteScanInfo();
                table = deleteScanInfo.isPresent() && deleteScanInfo.get().getId() == tableScanNode.getId() ? deleteScanInfo.get().getTableHandle() : tableScanNode.getTable();
                sourceLayout = new LinkedHashMap<VariableReferenceExpression, Integer>();
                columns = new ArrayList<ColumnHandle>();
                int channel = 0;
                for (VariableReferenceExpression variable : tableScanNode.getOutputVariables()) {
                    columns.add((ColumnHandle)tableScanNode.getAssignments().get(variable));
                    Integer input = channel;
                    sourceLayout.put(variable, input);
                    ++channel;
                }
            } else {
                source = (PhysicalOperation)sourceNode.accept((PlanVisitor)this, (Object)context);
                sourceLayout = source.getLayout();
            }
            if (filterExpression.isPresent()) {
                filterExpression = Optional.of(this.bindChannels(filterExpression.get(), sourceLayout));
            }
            ImmutableMap.Builder outputMappingsBuilder = ImmutableMap.builder();
            for (int i = 0; i < outputVariables.size(); ++i) {
                VariableReferenceExpression variable = outputVariables.get(i);
                outputMappingsBuilder.put((Object)variable, (Object)i);
            }
            ImmutableMap outputMappings = outputMappingsBuilder.build();
            List projections = (List)outputVariables.stream().map(arg_0 -> ((Assignments)assignments).get(arg_0)).map(expression -> this.bindChannels((RowExpression)expression, sourceLayout)).collect(ImmutableList.toImmutableList());
            try {
                if (columns != null) {
                    Supplier<CursorProcessor> cursorProcessor = LocalExecutionPlanner.this.expressionCompiler.compileCursorProcessor(this.session.getSqlFunctionProperties(), filterExpression, projections, sourceNode.getId());
                    Supplier<PageProcessor> pageProcessor = LocalExecutionPlanner.this.expressionCompiler.compilePageProcessor(this.session.getSqlFunctionProperties(), filterExpression, (List<? extends RowExpression>)projections, SystemSessionProperties.isOptimizeCommonSubExpressions(this.session), Optional.of(context.getStageExecutionId() + "_" + planNodeId));
                    ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory operatorFactory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(context.getNextOperatorId(), planNodeId, sourceNode.getId(), LocalExecutionPlanner.this.pageSourceProvider, cursorProcessor, pageProcessor, table, columns, (List)projections.stream().map(RowExpression::getType).collect(ImmutableList.toImmutableList()), SystemSessionProperties.getFilterAndProjectMinOutputPageSize(this.session), SystemSessionProperties.getFilterAndProjectMinOutputPageRowCount(this.session));
                    return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<VariableReferenceExpression, Integer>)outputMappings, context, this.stageExecutionDescriptor.isScanGroupedExecution(sourceNode.getId()) ? PipelineExecutionStrategy.GROUPED_EXECUTION : PipelineExecutionStrategy.UNGROUPED_EXECUTION);
                }
                Supplier<PageProcessor> pageProcessor = LocalExecutionPlanner.this.expressionCompiler.compilePageProcessor(this.session.getSqlFunctionProperties(), filterExpression, (List<? extends RowExpression>)projections, SystemSessionProperties.isOptimizeCommonSubExpressions(this.session), Optional.of(context.getStageExecutionId() + "_" + planNodeId));
                FilterAndProjectOperator.FilterAndProjectOperatorFactory operatorFactory = new FilterAndProjectOperator.FilterAndProjectOperatorFactory(context.getNextOperatorId(), planNodeId, pageProcessor, (List)projections.stream().map(RowExpression::getType).collect(ImmutableList.toImmutableList()), SystemSessionProperties.getFilterAndProjectMinOutputPageSize(this.session), SystemSessionProperties.getFilterAndProjectMinOutputPageRowCount(this.session));
                return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<VariableReferenceExpression, Integer>)outputMappings, context, source);
            }
            catch (PrestoException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR, "Compiler failed", (Throwable)e);
            }
        }

        private RowExpression bindChannels(RowExpression expression, Map<VariableReferenceExpression, Integer> sourceLayout) {
            Type type = expression.getType();
            Object value = new RowExpressionInterpreter(expression, LocalExecutionPlanner.this.metadata, this.session.toConnectorSession(), ExpressionOptimizer.Level.OPTIMIZED).optimize();
            if (value instanceof RowExpression) {
                RowExpression optimized = (RowExpression)value;
                expression = VariableToChannelTranslator.translate(optimized, sourceLayout);
            } else {
                expression = Expressions.constant(value, type);
            }
            return expression;
        }

        public PhysicalOperation visitTableScan(TableScanNode node, LocalExecutionPlanContext context) {
            ArrayList<ColumnHandle> columns = new ArrayList<ColumnHandle>();
            for (VariableReferenceExpression variable : node.getOutputVariables()) {
                columns.add((ColumnHandle)node.getAssignments().get(variable));
            }
            Optional<TableWriteInfo.DeleteScanInfo> deleteScanInfo = context.getTableWriteInfo().getDeleteScanInfo();
            TableHandle tableHandle = deleteScanInfo.isPresent() && deleteScanInfo.get().getId() == node.getId() ? deleteScanInfo.get().getTableHandle() : node.getTable();
            TableScanOperator.TableScanOperatorFactory operatorFactory = new TableScanOperator.TableScanOperatorFactory(context.getNextOperatorId(), node.getId(), LocalExecutionPlanner.this.pageSourceProvider, tableHandle, columns);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<VariableReferenceExpression, Integer>)this.makeLayout((PlanNode)node), context, this.stageExecutionDescriptor.isScanGroupedExecution(node.getId()) ? PipelineExecutionStrategy.GROUPED_EXECUTION : PipelineExecutionStrategy.UNGROUPED_EXECUTION);
        }

        public PhysicalOperation visitValues(ValuesNode node, LocalExecutionPlanContext context) {
            context.setDriverInstanceCount(1);
            if (node.getRows().isEmpty()) {
                ValuesOperator.ValuesOperatorFactory operatorFactory = new ValuesOperator.ValuesOperatorFactory(context.getNextOperatorId(), node.getId(), (List<Page>)ImmutableList.of());
                return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<VariableReferenceExpression, Integer>)this.makeLayout((PlanNode)node), context, PipelineExecutionStrategy.UNGROUPED_EXECUTION);
            }
            List outputTypes = (List)node.getOutputVariables().stream().map(VariableReferenceExpression::getType).collect(ImmutableList.toImmutableList());
            PageBuilder pageBuilder = new PageBuilder(node.getRows().size(), outputTypes);
            for (List row : node.getRows()) {
                pageBuilder.declarePosition();
                for (int i = 0; i < row.size(); ++i) {
                    Object result = RowExpressionInterpreter.rowExpressionInterpreter((RowExpression)row.get(i), LocalExecutionPlanner.this.metadata, context.getSession().toConnectorSession()).evaluate();
                    TypeUtils.writeNativeValue((Type)((Type)outputTypes.get(i)), (BlockBuilder)pageBuilder.getBlockBuilder(i), (Object)result);
                }
            }
            ValuesOperator.ValuesOperatorFactory operatorFactory = new ValuesOperator.ValuesOperatorFactory(context.getNextOperatorId(), node.getId(), (List<Page>)ImmutableList.of((Object)pageBuilder.build()));
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<VariableReferenceExpression, Integer>)this.makeLayout((PlanNode)node), context, PipelineExecutionStrategy.UNGROUPED_EXECUTION);
        }

        @Override
        public PhysicalOperation visitUnnest(UnnestNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = (PhysicalOperation)node.getSource().accept((PlanVisitor)this, (Object)context);
            ImmutableList.Builder replicateTypes = ImmutableList.builder();
            for (VariableReferenceExpression variable : node.getReplicateVariables()) {
                replicateTypes.add((Object)variable.getType());
            }
            ImmutableList unnestVariables = ImmutableList.copyOf(node.getUnnestVariables().keySet());
            ImmutableList.Builder unnestTypes = ImmutableList.builder();
            for (VariableReferenceExpression variable : unnestVariables) {
                unnestTypes.add((Object)variable.getType());
            }
            Optional<VariableReferenceExpression> ordinalityVariable = node.getOrdinalityVariable();
            Optional<Type> ordinalityType = ordinalityVariable.map(VariableReferenceExpression::getType);
            ordinalityType.ifPresent(type -> Preconditions.checkState((boolean)type.equals(BigintType.BIGINT), (Object)"Type of ordinalityVariable must always be BIGINT."));
            List replicateChannels = LocalExecutionPlanner.getChannelsForVariables(node.getReplicateVariables(), source.getLayout());
            List unnestChannels = LocalExecutionPlanner.getChannelsForVariables((Collection)unnestVariables, source.getLayout());
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            int channel = 0;
            for (VariableReferenceExpression variable : node.getReplicateVariables()) {
                outputMappings.put((Object)variable, (Object)channel);
                ++channel;
            }
            for (VariableReferenceExpression variable : unnestVariables) {
                for (VariableReferenceExpression unnestedVariable : node.getUnnestVariables().get(variable)) {
                    outputMappings.put((Object)unnestedVariable, (Object)channel);
                    ++channel;
                }
            }
            if (ordinalityVariable.isPresent()) {
                outputMappings.put((Object)ordinalityVariable.get(), (Object)channel);
                ++channel;
            }
            UnnestOperator.UnnestOperatorFactory operatorFactory = new UnnestOperator.UnnestOperatorFactory(context.getNextOperatorId(), node.getId(), replicateChannels, (List<Type>)replicateTypes.build(), unnestChannels, (List<Type>)unnestTypes.build(), ordinalityType.isPresent());
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<VariableReferenceExpression, Integer>)outputMappings.build(), context, source);
        }

        private ImmutableMap<VariableReferenceExpression, Integer> makeLayout(PlanNode node) {
            return this.makeLayoutFromOutputVariables(node.getOutputVariables());
        }

        private ImmutableMap<VariableReferenceExpression, Integer> makeLayoutFromOutputVariables(List<VariableReferenceExpression> outputVariables) {
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            int channel = 0;
            for (VariableReferenceExpression variable : outputVariables) {
                outputMappings.put((Object)variable, (Object)channel);
                ++channel;
            }
            return outputMappings.build();
        }

        @Override
        public PhysicalOperation visitIndexSource(IndexSourceNode node, LocalExecutionPlanContext context) {
            Preconditions.checkState((boolean)context.getIndexSourceContext().isPresent(), (Object)"Must be in an index source context");
            IndexSourceContext indexSourceContext = context.getIndexSourceContext().get();
            SetMultimap indexLookupToProbeInput = indexSourceContext.getIndexLookupToProbeInput();
            Preconditions.checkState((boolean)indexLookupToProbeInput.keySet().equals(node.getLookupVariables()));
            ImmutableList lookupVariableSchema = ImmutableList.copyOf(node.getLookupVariables());
            ImmutableList.Builder remappedProbeKeyChannelsBuilder = ImmutableList.builder();
            ImmutableList.Builder overlappingFieldSetsBuilder = ImmutableList.builder();
            for (VariableReferenceExpression lookupVariable : node.getLookupVariables()) {
                Set potentialProbeInputs = indexLookupToProbeInput.get((Object)lookupVariable);
                Preconditions.checkState((!potentialProbeInputs.isEmpty() ? 1 : 0) != 0, (Object)"Must have at least one source from the probe input");
                if (potentialProbeInputs.size() > 1) {
                    overlappingFieldSetsBuilder.add(potentialProbeInputs.stream().collect(ImmutableSet.toImmutableSet()));
                }
                remappedProbeKeyChannelsBuilder.add(Iterables.getFirst((Iterable)potentialProbeInputs, null));
            }
            ImmutableList overlappingFieldSets = overlappingFieldSetsBuilder.build();
            ImmutableList remappedProbeKeyChannels = remappedProbeKeyChannelsBuilder.build();
            Function<RecordSet, RecordSet> probeKeyNormalizer = arg_0 -> this.lambda$visitIndexSource$6((List)overlappingFieldSets, (List)remappedProbeKeyChannels, arg_0);
            List lookupSchema = (List)lookupVariableSchema.stream().map(node.getAssignments()::get).collect(ImmutableList.toImmutableList());
            List outputSchema = (List)node.getAssignments().entrySet().stream().filter(entry -> node.getOutputVariables().contains(entry.getKey())).map(Map.Entry::getValue).collect(ImmutableList.toImmutableList());
            ConnectorIndex index = LocalExecutionPlanner.this.indexManager.getIndex(this.session, node.getIndexHandle(), lookupSchema, outputSchema);
            IndexSourceOperator.IndexSourceOperatorFactory operatorFactory = new IndexSourceOperator.IndexSourceOperatorFactory(context.getNextOperatorId(), node.getId(), index, probeKeyNormalizer);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<VariableReferenceExpression, Integer>)this.makeLayout(node), context, PipelineExecutionStrategy.UNGROUPED_EXECUTION);
        }

        private SetMultimap<VariableReferenceExpression, Integer> mapIndexSourceLookupVariableToProbeKeyInput(IndexJoinNode node, Map<VariableReferenceExpression, Integer> probeKeyLayout) {
            Set indexJoinVariables = (Set)node.getCriteria().stream().map(IndexJoinNode.EquiJoinClause::getIndex).collect(ImmutableSet.toImmutableSet());
            Map<VariableReferenceExpression, VariableReferenceExpression> indexKeyTrace = IndexJoinOptimizer.IndexKeyTracer.trace(node.getIndexSource(), indexJoinVariables);
            HashMultimap indexToProbeKeyInput = HashMultimap.create();
            for (IndexJoinNode.EquiJoinClause clause : node.getCriteria()) {
                indexToProbeKeyInput.put((Object)clause.getIndex(), (Object)probeKeyLayout.get(clause.getProbe()));
            }
            ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
            for (Map.Entry<VariableReferenceExpression, VariableReferenceExpression> entry : indexKeyTrace.entrySet()) {
                VariableReferenceExpression indexJoinVariable = entry.getKey();
                VariableReferenceExpression indexLookupVariable = entry.getValue();
                builder.putAll((Object)indexJoinVariable, (Iterable)indexToProbeKeyInput.get((Object)indexLookupVariable));
            }
            return builder.build();
        }

        @Override
        public PhysicalOperation visitIndexJoin(IndexJoinNode node, LocalExecutionPlanContext context) {
            OperatorFactory lookupJoinOperatorFactory;
            List<IndexJoinNode.EquiJoinClause> clauses = node.getCriteria();
            List probeVariables = (List)clauses.stream().map(IndexJoinNode.EquiJoinClause::getProbe).collect(ImmutableList.toImmutableList());
            List indexVariables = (List)clauses.stream().map(IndexJoinNode.EquiJoinClause::getIndex).collect(ImmutableList.toImmutableList());
            PhysicalOperation probeSource = (PhysicalOperation)node.getProbeSource().accept((PlanVisitor)this, (Object)context);
            List probeChannels = LocalExecutionPlanner.getChannelsForVariables(probeVariables, probeSource.getLayout());
            OptionalInt probeHashChannel = node.getProbeHashVariable().map(LocalExecutionPlanner.variableChannelGetter(probeSource)).map(OptionalInt::of).orElse(OptionalInt.empty());
            HashMap<VariableReferenceExpression, Integer> probeKeyLayout = new HashMap<VariableReferenceExpression, Integer>();
            for (int i = 0; i < probeVariables.size(); ++i) {
                probeKeyLayout.put((VariableReferenceExpression)probeVariables.get(i), i);
            }
            SetMultimap<VariableReferenceExpression, Integer> indexLookupToProbeInput = this.mapIndexSourceLookupVariableToProbeKeyInput(node, probeKeyLayout);
            LocalExecutionPlanContext indexContext = context.createIndexSourceSubContext(new IndexSourceContext(indexLookupToProbeInput));
            PhysicalOperation indexSource = (PhysicalOperation)node.getIndexSource().accept((PlanVisitor)this, (Object)indexContext);
            List indexOutputChannels = LocalExecutionPlanner.getChannelsForVariables(indexVariables, indexSource.getLayout());
            OptionalInt indexHashChannel = node.getIndexHashVariable().map(LocalExecutionPlanner.variableChannelGetter(indexSource)).map(OptionalInt::of).orElse(OptionalInt.empty());
            Set<VariableReferenceExpression> indexVariablesNeededBySource = IndexJoinOptimizer.IndexKeyTracer.trace(node.getIndexSource(), (Set<VariableReferenceExpression>)ImmutableSet.copyOf((Collection)indexVariables)).keySet();
            Set lookupSourceInputChannels = (Set)node.getCriteria().stream().filter(equiJoinClause -> indexVariablesNeededBySource.contains(equiJoinClause.getIndex())).map(IndexJoinNode.EquiJoinClause::getProbe).map(probeKeyLayout::get).collect(ImmutableSet.toImmutableSet());
            Optional<DynamicTupleFilterFactory> dynamicTupleFilterFactory = Optional.empty();
            if (lookupSourceInputChannels.size() < probeKeyLayout.values().size()) {
                int[] nonLookupInputChannels = Ints.toArray((Collection)((Collection)node.getCriteria().stream().filter(equiJoinClause -> !indexVariablesNeededBySource.contains(equiJoinClause.getIndex())).map(IndexJoinNode.EquiJoinClause::getProbe).map(probeKeyLayout::get).collect(ImmutableList.toImmutableList())));
                int[] nonLookupOutputChannels = Ints.toArray((Collection)((Collection)node.getCriteria().stream().filter(equiJoinClause -> !indexVariablesNeededBySource.contains(equiJoinClause.getIndex())).map(IndexJoinNode.EquiJoinClause::getIndex).map(variable -> indexSource.getLayout().get(variable)).collect(ImmutableList.toImmutableList())));
                int filterOperatorId = indexContext.getNextOperatorId();
                dynamicTupleFilterFactory = Optional.of(new DynamicTupleFilterFactory(filterOperatorId, node.getId(), nonLookupInputChannels, nonLookupOutputChannels, indexSource.getTypes(), this.session.getSqlFunctionProperties(), LocalExecutionPlanner.this.pageFunctionCompiler));
            }
            IndexBuildDriverFactoryProvider indexBuildDriverFactoryProvider = new IndexBuildDriverFactoryProvider(indexContext.getNextPipelineId(), indexContext.getNextOperatorId(), node.getId(), indexContext.isInputDriver(), indexSource.getTypes(), indexSource.getOperatorFactories(), dynamicTupleFilterFactory);
            IndexLookupSourceFactory indexLookupSourceFactory = new IndexLookupSourceFactory(lookupSourceInputChannels, indexOutputChannels, indexHashChannel, indexSource.getTypes(), indexSource.getLayout(), indexBuildDriverFactoryProvider, LocalExecutionPlanner.this.maxIndexMemorySize, LocalExecutionPlanner.this.indexJoinLookupStats, SystemSessionProperties.isShareIndexLoading(this.session), LocalExecutionPlanner.this.pagesIndexFactory, LocalExecutionPlanner.this.joinCompiler, SystemSessionProperties.getIndexLoaderTimeout(this.session));
            Verify.verify((probeSource.getPipelineExecutionStrategy() == PipelineExecutionStrategy.UNGROUPED_EXECUTION ? 1 : 0) != 0);
            Verify.verify((indexSource.getPipelineExecutionStrategy() == PipelineExecutionStrategy.UNGROUPED_EXECUTION ? 1 : 0) != 0);
            JoinBridgeManager<LookupSourceFactory> lookupSourceFactoryManager = new JoinBridgeManager<LookupSourceFactory>(false, PipelineExecutionStrategy.UNGROUPED_EXECUTION, PipelineExecutionStrategy.UNGROUPED_EXECUTION, lifespan -> indexLookupSourceFactory, indexLookupSourceFactory.getOutputTypes());
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            outputMappings.putAll(probeSource.getLayout());
            int offset = probeSource.getTypes().size();
            for (Map.Entry<VariableReferenceExpression, Integer> entry : indexSource.getLayout().entrySet()) {
                Integer input = entry.getValue();
                outputMappings.put((Object)entry.getKey(), (Object)(offset + input));
            }
            OptionalInt totalOperatorsCount = this.getJoinOperatorsCountForSpill(context, this.session);
            switch (node.getType()) {
                case INNER: {
                    lookupJoinOperatorFactory = LocalExecutionPlanner.this.lookupJoinOperators.innerJoin(context.getNextOperatorId(), node.getId(), lookupSourceFactoryManager, probeSource.getTypes(), probeChannels, probeHashChannel, Optional.empty(), totalOperatorsCount, LocalExecutionPlanner.this.partitioningSpillerFactory);
                    break;
                }
                case SOURCE_OUTER: {
                    lookupJoinOperatorFactory = LocalExecutionPlanner.this.lookupJoinOperators.probeOuterJoin(context.getNextOperatorId(), node.getId(), lookupSourceFactoryManager, probeSource.getTypes(), probeChannels, probeHashChannel, Optional.empty(), totalOperatorsCount, LocalExecutionPlanner.this.partitioningSpillerFactory);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown type: " + (Object)((Object)node.getType())));
                }
            }
            return new PhysicalOperation(lookupJoinOperatorFactory, (Map<VariableReferenceExpression, Integer>)outputMappings.build(), context, probeSource);
        }

        @Override
        public PhysicalOperation visitJoin(JoinNode node, LocalExecutionPlanContext context) {
            if (node.isCrossJoin()) {
                return this.createNestedLoopJoin(node, context);
            }
            List<JoinNode.EquiJoinClause> clauses = node.getCriteria();
            List leftVariables = Lists.transform(clauses, JoinNode.EquiJoinClause::getLeft);
            List rightVariables = Lists.transform(clauses, JoinNode.EquiJoinClause::getRight);
            switch (node.getType()) {
                case INNER: 
                case LEFT: 
                case RIGHT: 
                case FULL: {
                    return this.createLookupJoin(node, node.getLeft(), leftVariables, node.getLeftHashVariable(), node.getRight(), rightVariables, node.getRightHashVariable(), context);
                }
            }
            throw new UnsupportedOperationException("Unsupported join type: " + (Object)((Object)node.getType()));
        }

        @Override
        public PhysicalOperation visitSpatialJoin(SpatialJoinNode node, LocalExecutionPlanContext context) {
            RowExpression filterExpression = node.getFilter();
            List<CallExpression> spatialFunctions = SpatialJoinUtils.extractSupportedSpatialFunctions(filterExpression, LocalExecutionPlanner.this.metadata.getFunctionManager());
            for (CallExpression spatialFunction : spatialFunctions) {
                Optional<PhysicalOperation> operation = this.tryCreateSpatialJoin(context, node, this.removeExpressionFromFilter(filterExpression, (RowExpression)spatialFunction), spatialFunction, Optional.empty(), Optional.empty());
                if (!operation.isPresent()) continue;
                return operation.get();
            }
            List<CallExpression> spatialComparisons = SpatialJoinUtils.extractSupportedSpatialComparisons(filterExpression, LocalExecutionPlanner.this.metadata.getFunctionManager());
            for (CallExpression spatialComparison : spatialComparisons) {
                RowExpression radius;
                FunctionMetadata functionMetadata = LocalExecutionPlanner.this.metadata.getFunctionManager().getFunctionMetadata(spatialComparison.getFunctionHandle());
                Preconditions.checkArgument((functionMetadata.getOperatorType().isPresent() && ((OperatorType)functionMetadata.getOperatorType().get()).isComparisonOperator() ? 1 : 0) != 0);
                if (functionMetadata.getOperatorType().get() != OperatorType.LESS_THAN && functionMetadata.getOperatorType().get() != OperatorType.LESS_THAN_OR_EQUAL || !((radius = (RowExpression)spatialComparison.getArguments().get(1)) instanceof VariableReferenceExpression) || !node.getRight().getOutputVariables().contains(radius)) continue;
                CallExpression spatialFunction = (CallExpression)spatialComparison.getArguments().get(0);
                Optional<PhysicalOperation> operation = this.tryCreateSpatialJoin(context, node, this.removeExpressionFromFilter(filterExpression, (RowExpression)spatialComparison), spatialFunction, Optional.of((VariableReferenceExpression)radius), functionMetadata.getOperatorType());
                if (!operation.isPresent()) continue;
                return operation.get();
            }
            throw new VerifyException("No valid spatial relationship found for spatial join");
        }

        private Optional<PhysicalOperation> tryCreateSpatialJoin(LocalExecutionPlanContext context, SpatialJoinNode node, Optional<RowExpression> filterExpression, CallExpression spatialFunction, Optional<VariableReferenceExpression> radius, Optional<OperatorType> comparisonOperator) {
            List arguments = spatialFunction.getArguments();
            Verify.verify((arguments.size() == 2 ? 1 : 0) != 0);
            if (!(arguments.get(0) instanceof VariableReferenceExpression) || !(arguments.get(1) instanceof VariableReferenceExpression)) {
                return Optional.empty();
            }
            VariableReferenceExpression firstVariable = (VariableReferenceExpression)arguments.get(0);
            VariableReferenceExpression secondVariable = (VariableReferenceExpression)arguments.get(1);
            PlanNode probeNode = node.getLeft();
            Set<SymbolReference> probeSymbols = this.getSymbolReferences(probeNode.getOutputVariables());
            PlanNode buildNode = node.getRight();
            Set<SymbolReference> buildSymbols = this.getSymbolReferences(buildNode.getOutputVariables());
            if (probeSymbols.contains(new SymbolReference(firstVariable.getName())) && buildSymbols.contains(new SymbolReference(secondVariable.getName()))) {
                return Optional.of(this.createSpatialLookupJoin(node, probeNode, firstVariable, buildNode, secondVariable, radius, this.spatialTest(spatialFunction, true, comparisonOperator), filterExpression, context));
            }
            if (probeSymbols.contains(new SymbolReference(secondVariable.getName())) && buildSymbols.contains(new SymbolReference(firstVariable.getName()))) {
                return Optional.of(this.createSpatialLookupJoin(node, probeNode, secondVariable, buildNode, firstVariable, radius, this.spatialTest(spatialFunction, false, comparisonOperator), filterExpression, context));
            }
            return Optional.empty();
        }

        private Optional<RowExpression> removeExpressionFromFilter(RowExpression filter, RowExpression expression) {
            RowExpression updatedJoinFilter = RowExpressionNodeInliner.replaceExpression((RowExpression)filter, (Map)ImmutableMap.of((Object)expression, (Object)LogicalRowExpressions.TRUE_CONSTANT));
            return updatedJoinFilter == LogicalRowExpressions.TRUE_CONSTANT ? Optional.empty() : Optional.of(updatedJoinFilter);
        }

        private SpatialIndexBuilderOperator.SpatialPredicate spatialTest(CallExpression functionCall, boolean probeFirst, Optional<OperatorType> comparisonOperator) {
            FunctionMetadata functionMetadata = LocalExecutionPlanner.this.metadata.getFunctionManager().getFunctionMetadata(functionCall.getFunctionHandle());
            QualifiedFunctionName functionName = functionMetadata.getName();
            List argumentTypes = functionMetadata.getArgumentTypes();
            Predicate<TypeSignature> isSpherical = typeSignature -> typeSignature.equals((Object)SPHERICAL_GEOGRAPHY_TYPE_SIGNATURE);
            if (argumentTypes.stream().allMatch(isSpherical)) {
                return this.sphericalSpatialTest(functionName, comparisonOperator);
            }
            if (argumentTypes.stream().noneMatch(isSpherical)) {
                return this.euclideanSpatialTest(functionName, comparisonOperator, probeFirst);
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Mixing spherical and euclidean geometric types");
        }

        private SpatialIndexBuilderOperator.SpatialPredicate euclideanSpatialTest(QualifiedFunctionName functionName, Optional<OperatorType> comparisonOperator, boolean probeFirst) {
            if (functionName.equals((Object)SpatialJoinUtils.ST_CONTAINS)) {
                if (probeFirst) {
                    return (buildGeometry, probeGeometry, radius) -> probeGeometry.contains(buildGeometry);
                }
                return (buildGeometry, probeGeometry, radius) -> buildGeometry.contains(probeGeometry);
            }
            if (functionName.equals((Object)SpatialJoinUtils.ST_WITHIN)) {
                if (probeFirst) {
                    return (buildGeometry, probeGeometry, radius) -> probeGeometry.within(buildGeometry);
                }
                return (buildGeometry, probeGeometry, radius) -> buildGeometry.within(probeGeometry);
            }
            if (functionName.equals((Object)SpatialJoinUtils.ST_CROSSES)) {
                return (buildGeometry, probeGeometry, radius) -> buildGeometry.crosses(probeGeometry);
            }
            if (functionName.equals((Object)SpatialJoinUtils.ST_EQUALS)) {
                return (buildGeometry, probeGeometry, radius) -> buildGeometry.Equals(probeGeometry);
            }
            if (functionName.equals((Object)SpatialJoinUtils.ST_INTERSECTS)) {
                return (buildGeometry, probeGeometry, radius) -> buildGeometry.intersects(probeGeometry);
            }
            if (functionName.equals((Object)SpatialJoinUtils.ST_OVERLAPS)) {
                return (buildGeometry, probeGeometry, radius) -> buildGeometry.overlaps(probeGeometry);
            }
            if (functionName.equals((Object)SpatialJoinUtils.ST_TOUCHES)) {
                return (buildGeometry, probeGeometry, radius) -> buildGeometry.touches(probeGeometry);
            }
            if (functionName.equals((Object)SpatialJoinUtils.ST_DISTANCE)) {
                if (comparisonOperator.get() == OperatorType.LESS_THAN) {
                    return (buildGeometry, probeGeometry, radius) -> buildGeometry.distance(probeGeometry) < radius.getAsDouble();
                }
                if (comparisonOperator.get() == OperatorType.LESS_THAN_OR_EQUAL) {
                    return (buildGeometry, probeGeometry, radius) -> buildGeometry.distance(probeGeometry) <= radius.getAsDouble();
                }
                throw new UnsupportedOperationException("Unsupported comparison operator: " + comparisonOperator);
            }
            throw new UnsupportedOperationException("Unsupported spatial function: " + functionName);
        }

        private SpatialIndexBuilderOperator.SpatialPredicate sphericalSpatialTest(QualifiedFunctionName functionName, Optional<OperatorType> comparisonOperator) {
            if (functionName.equals((Object)SpatialJoinUtils.ST_DISTANCE)) {
                if (comparisonOperator.get() == OperatorType.LESS_THAN) {
                    return (buildGeometry, probeGeometry, radius) -> SphericalGeographyUtils.sphericalDistance((OGCGeometry)buildGeometry, (OGCGeometry)probeGeometry) < radius.getAsDouble();
                }
                if (comparisonOperator.get() == OperatorType.LESS_THAN_OR_EQUAL) {
                    return (buildGeometry, probeGeometry, radius) -> SphericalGeographyUtils.sphericalDistance((OGCGeometry)buildGeometry, (OGCGeometry)probeGeometry) <= radius.getAsDouble();
                }
                throw new UnsupportedOperationException("Unsupported spherical comparison operator: " + comparisonOperator);
            }
            throw new UnsupportedOperationException("Unsupported spherical spatial function: " + functionName);
        }

        private Set<SymbolReference> getSymbolReferences(Collection<VariableReferenceExpression> variables) {
            return (Set)variables.stream().map(VariableReferenceExpression::getName).map(SymbolReference::new).collect(ImmutableSet.toImmutableSet());
        }

        private PhysicalOperation createNestedLoopJoin(JoinNode node, LocalExecutionPlanContext context) {
            PhysicalOperation probeSource = (PhysicalOperation)node.getLeft().accept((PlanVisitor)this, (Object)context);
            LocalExecutionPlanContext buildContext = context.createSubContext();
            PhysicalOperation buildSource = (PhysicalOperation)node.getRight().accept((PlanVisitor)this, (Object)buildContext);
            Preconditions.checkState((buildSource.getPipelineExecutionStrategy() == PipelineExecutionStrategy.UNGROUPED_EXECUTION ? 1 : 0) != 0, (Object)"Build source of a nested loop join is expected to be GROUPED_EXECUTION.");
            Preconditions.checkArgument((node.getType() == JoinNode.Type.INNER ? 1 : 0) != 0, (Object)"NestedLoopJoin is only used for inner join");
            JoinBridgeManager<NestedLoopJoinBridge> nestedLoopJoinBridgeManager = new JoinBridgeManager<NestedLoopJoinBridge>(false, probeSource.getPipelineExecutionStrategy(), buildSource.getPipelineExecutionStrategy(), lifespan -> new NestedLoopJoinPagesSupplier(), buildSource.getTypes());
            NestedLoopBuildOperator.NestedLoopBuildOperatorFactory nestedLoopBuildOperatorFactory = new NestedLoopBuildOperator.NestedLoopBuildOperatorFactory(buildContext.getNextOperatorId(), node.getId(), nestedLoopJoinBridgeManager);
            Preconditions.checkArgument((buildContext.getDriverInstanceCount().orElse(1) == 1 ? 1 : 0) != 0, (Object)"Expected local execution to not be parallel");
            context.addDriverFactory(buildContext.isInputDriver(), false, (List<OperatorFactory>)ImmutableList.builder().addAll((Iterable)buildSource.getOperatorFactories()).add((Object)nestedLoopBuildOperatorFactory).build(), buildContext.getDriverInstanceCount(), buildSource.getPipelineExecutionStrategy());
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            outputMappings.putAll(probeSource.getLayout());
            int offset = probeSource.getTypes().size();
            for (Map.Entry<VariableReferenceExpression, Integer> entry : buildSource.getLayout().entrySet()) {
                outputMappings.put((Object)entry.getKey(), (Object)(offset + entry.getValue()));
            }
            NestedLoopJoinOperator.NestedLoopJoinOperatorFactory operatorFactory = new NestedLoopJoinOperator.NestedLoopJoinOperatorFactory(context.getNextOperatorId(), node.getId(), nestedLoopJoinBridgeManager);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<VariableReferenceExpression, Integer>)outputMappings.build(), context, probeSource);
        }

        private PhysicalOperation createSpatialLookupJoin(SpatialJoinNode node, PlanNode probeNode, VariableReferenceExpression probeVariable, PlanNode buildNode, VariableReferenceExpression buildVariable, Optional<VariableReferenceExpression> radiusVariable, SpatialIndexBuilderOperator.SpatialPredicate spatialRelationshipTest, Optional<RowExpression> joinFilter, LocalExecutionPlanContext context) {
            PhysicalOperation probeSource = (PhysicalOperation)probeNode.accept((PlanVisitor)this, (Object)context);
            PagesSpatialIndexFactory pagesSpatialIndexFactory = this.createPagesSpatialIndexFactory(node, buildNode, buildVariable, radiusVariable, probeSource.getLayout(), spatialRelationshipTest, joinFilter, context);
            OperatorFactory operator = this.createSpatialLookupJoin(node, probeNode, probeSource, probeVariable, pagesSpatialIndexFactory, context);
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            List<VariableReferenceExpression> outputVariables = node.getOutputVariables();
            for (int i = 0; i < outputVariables.size(); ++i) {
                outputMappings.put((Object)outputVariables.get(i), (Object)i);
            }
            return new PhysicalOperation(operator, (Map<VariableReferenceExpression, Integer>)outputMappings.build(), context, probeSource);
        }

        private OperatorFactory createSpatialLookupJoin(SpatialJoinNode node, PlanNode probeNode, PhysicalOperation probeSource, VariableReferenceExpression probeVariable, PagesSpatialIndexFactory pagesSpatialIndexFactory, LocalExecutionPlanContext context) {
            List<Type> probeTypes = probeSource.getTypes();
            List probeOutputVariables = (List)node.getOutputVariables().stream().filter(probeNode.getOutputVariables()::contains).collect(ImmutableList.toImmutableList());
            ImmutableList probeOutputChannels = ImmutableList.copyOf((Collection)LocalExecutionPlanner.getChannelsForVariables(probeOutputVariables, probeSource.getLayout()));
            Function probeChannelGetter = LocalExecutionPlanner.variableChannelGetter(probeSource);
            int probeChannel = (Integer)probeChannelGetter.apply(probeVariable);
            Optional<Integer> partitionChannel = node.getLeftPartitionVariable().map(probeChannelGetter);
            return new SpatialJoinOperator.SpatialJoinOperatorFactory(context.getNextOperatorId(), node.getId(), node.getType(), probeTypes, (List<Integer>)probeOutputChannels, probeChannel, partitionChannel, pagesSpatialIndexFactory);
        }

        private PagesSpatialIndexFactory createPagesSpatialIndexFactory(SpatialJoinNode node, PlanNode buildNode, VariableReferenceExpression buildVariable, Optional<VariableReferenceExpression> radiusVariable, Map<VariableReferenceExpression, Integer> probeLayout, SpatialIndexBuilderOperator.SpatialPredicate spatialRelationshipTest, Optional<RowExpression> joinFilter, LocalExecutionPlanContext context) {
            LocalExecutionPlanContext buildContext = context.createSubContext();
            PhysicalOperation buildSource = (PhysicalOperation)buildNode.accept((PlanVisitor)this, (Object)buildContext);
            List buildOutputVariables = (List)node.getOutputVariables().stream().filter(buildNode.getOutputVariables()::contains).collect(ImmutableList.toImmutableList());
            Map<VariableReferenceExpression, Integer> buildLayout = buildSource.getLayout();
            ImmutableList buildOutputChannels = ImmutableList.copyOf((Collection)LocalExecutionPlanner.getChannelsForVariables(buildOutputVariables, buildLayout));
            Function buildChannelGetter = LocalExecutionPlanner.variableChannelGetter(buildSource);
            Integer buildChannel = (Integer)buildChannelGetter.apply(buildVariable);
            Optional<Integer> radiusChannel = radiusVariable.map(buildChannelGetter::apply);
            Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory = joinFilter.map(filterExpression -> this.compileJoinFilterFunction(this.session.getSqlFunctionProperties(), (RowExpression)filterExpression, probeLayout, buildLayout));
            Optional<Integer> partitionChannel = node.getRightPartitionVariable().map(buildChannelGetter);
            SpatialIndexBuilderOperator.SpatialIndexBuilderOperatorFactory builderOperatorFactory = new SpatialIndexBuilderOperator.SpatialIndexBuilderOperatorFactory(buildContext.getNextOperatorId(), node.getId(), buildSource.getTypes(), (List<Integer>)buildOutputChannels, buildChannel, radiusChannel, partitionChannel, spatialRelationshipTest, node.getKdbTree(), filterFunctionFactory, 10000, LocalExecutionPlanner.this.pagesIndexFactory);
            context.addDriverFactory(buildContext.isInputDriver(), false, (List<OperatorFactory>)ImmutableList.builder().addAll((Iterable)buildSource.getOperatorFactories()).add((Object)builderOperatorFactory).build(), buildContext.getDriverInstanceCount(), buildSource.getPipelineExecutionStrategy());
            return builderOperatorFactory.getPagesSpatialIndexFactory();
        }

        private PhysicalOperation createLookupJoin(JoinNode node, PlanNode probeNode, List<VariableReferenceExpression> probeVariables, Optional<VariableReferenceExpression> probeHashVariable, PlanNode buildNode, List<VariableReferenceExpression> buildVariables, Optional<VariableReferenceExpression> buildHashVariable, LocalExecutionPlanContext context) {
            PhysicalOperation probeSource = (PhysicalOperation)probeNode.accept((PlanVisitor)this, (Object)context);
            JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = this.createLookupSourceFactory(node, buildNode, buildVariables, buildHashVariable, probeSource, context);
            OperatorFactory operator = this.createLookupJoin(node, probeSource, probeVariables, probeHashVariable, lookupSourceFactory, context);
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            List<VariableReferenceExpression> outputVariables = node.getOutputVariables();
            for (int i = 0; i < outputVariables.size(); ++i) {
                outputMappings.put((Object)outputVariables.get(i), (Object)i);
            }
            return new PhysicalOperation(operator, (Map<VariableReferenceExpression, Integer>)outputMappings.build(), context, probeSource);
        }

        private JoinBridgeManager<PartitionedLookupSourceFactory> createLookupSourceFactory(JoinNode node, PlanNode buildNode, List<VariableReferenceExpression> buildVariables, Optional<VariableReferenceExpression> buildHashVariable, PhysicalOperation probeSource, LocalExecutionPlanContext context) {
            Optional<JoinNode.DistributionType> distributionType = node.getDistributionType();
            boolean isBroadcastJoin = distributionType.isPresent() && distributionType.get() == JoinNode.DistributionType.REPLICATED;
            LocalExecutionPlanContext buildContext = context.createSubContext();
            PhysicalOperation buildSource = (PhysicalOperation)buildNode.accept((PlanVisitor)this, (Object)buildContext);
            if (buildSource.getPipelineExecutionStrategy() == PipelineExecutionStrategy.GROUPED_EXECUTION) {
                Preconditions.checkState((probeSource.getPipelineExecutionStrategy() == PipelineExecutionStrategy.GROUPED_EXECUTION ? 1 : 0) != 0, (Object)"Build execution is GROUPED_EXECUTION. Probe execution is expected be GROUPED_EXECUTION, but is UNGROUPED_EXECUTION.");
            }
            List buildOutputVariables = (List)node.getOutputVariables().stream().filter(node.getRight().getOutputVariables()::contains).collect(ImmutableList.toImmutableList());
            ImmutableList buildOutputChannels = ImmutableList.copyOf((Collection)LocalExecutionPlanner.getChannelsForVariables(buildOutputVariables, buildSource.getLayout()));
            ImmutableList buildChannels = ImmutableList.copyOf((Collection)LocalExecutionPlanner.getChannelsForVariables(buildVariables, buildSource.getLayout()));
            OptionalInt buildHashChannel = buildHashVariable.map(LocalExecutionPlanner.variableChannelGetter(buildSource)).map(OptionalInt::of).orElse(OptionalInt.empty());
            boolean spillEnabled = SystemSessionProperties.isSpillEnabled(context.getSession());
            boolean buildOuter = node.getType() == JoinNode.Type.RIGHT || node.getType() == JoinNode.Type.FULL;
            int partitionCount = buildContext.getDriverInstanceCount().orElse(1);
            Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory = node.getFilter().map(filterExpression -> this.compileJoinFilterFunction(this.session.getSqlFunctionProperties(), (RowExpression)filterExpression, probeSource.getLayout(), buildSource.getLayout()));
            Optional<SortExpressionContext> sortExpressionContext = node.getSortExpressionContext(LocalExecutionPlanner.this.metadata.getFunctionManager());
            Optional<Integer> sortChannel = sortExpressionContext.map(SortExpressionContext::getSortExpression).map(sortExpression -> this.sortExpressionAsSortChannel((RowExpression)sortExpression, probeSource.getLayout(), buildSource.getLayout()));
            List searchFunctionFactories = (List)sortExpressionContext.map(SortExpressionContext::getSearchExpressions).map(searchExpressions -> (ImmutableList)searchExpressions.stream().map(searchExpression -> this.compileJoinFilterFunction(this.session.getSqlFunctionProperties(), (RowExpression)searchExpression, probeSource.getLayout(), buildSource.getLayout())).collect(ImmutableList.toImmutableList())).orElse(ImmutableList.of());
            ImmutableList buildOutputTypes = (ImmutableList)buildOutputChannels.stream().map(buildSource.getTypes()::get).collect(ImmutableList.toImmutableList());
            JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactoryManager = new JoinBridgeManager<PartitionedLookupSourceFactory>(buildOuter, probeSource.getPipelineExecutionStrategy(), buildSource.getPipelineExecutionStrategy(), arg_0 -> Visitor.lambda$createLookupSourceFactory$33(buildSource, buildOutputTypes, (List)buildChannels, buildContext, buildOuter, arg_0), (List<Type>)buildOutputTypes);
            HashBuilderOperator.HashBuilderOperatorFactory hashBuilderOperatorFactory = new HashBuilderOperator.HashBuilderOperatorFactory(buildContext.getNextOperatorId(), node.getId(), lookupSourceFactoryManager, (List<Integer>)buildOutputChannels, (List<Integer>)buildChannels, buildHashChannel, filterFunctionFactory, sortChannel, searchFunctionFactories, 10000, LocalExecutionPlanner.this.pagesIndexFactory, spillEnabled && !buildOuter && partitionCount > 1, LocalExecutionPlanner.this.singleStreamSpillerFactory, isBroadcastJoin);
            context.addDriverFactory(buildContext.isInputDriver(), false, (List<OperatorFactory>)ImmutableList.builder().addAll((Iterable)buildSource.getOperatorFactories()).add((Object)hashBuilderOperatorFactory).build(), buildContext.getDriverInstanceCount(), buildSource.getPipelineExecutionStrategy());
            return lookupSourceFactoryManager;
        }

        private JoinFilterFunctionCompiler.JoinFilterFunctionFactory compileJoinFilterFunction(SqlFunctionProperties sqlFunctionProperties, RowExpression filterExpression, Map<VariableReferenceExpression, Integer> probeLayout, Map<VariableReferenceExpression, Integer> buildLayout) {
            Map<VariableReferenceExpression, Integer> joinSourcesLayout = this.createJoinSourcesLayout(buildLayout, probeLayout);
            return LocalExecutionPlanner.this.joinFilterFunctionCompiler.compileJoinFilterFunction(sqlFunctionProperties, this.bindChannels(filterExpression, joinSourcesLayout), buildLayout.size());
        }

        private int sortExpressionAsSortChannel(RowExpression sortExpression, Map<VariableReferenceExpression, Integer> probeLayout, Map<VariableReferenceExpression, Integer> buildLayout) {
            Map<VariableReferenceExpression, Integer> joinSourcesLayout = this.createJoinSourcesLayout(buildLayout, probeLayout);
            RowExpression rewrittenSortExpression = this.bindChannels(sortExpression, joinSourcesLayout);
            Preconditions.checkArgument((boolean)(rewrittenSortExpression instanceof InputReferenceExpression), (String)"Unsupported expression type [%s]", (Object)rewrittenSortExpression);
            return ((InputReferenceExpression)rewrittenSortExpression).getField();
        }

        private OperatorFactory createLookupJoin(JoinNode node, PhysicalOperation probeSource, List<VariableReferenceExpression> probeVariables, Optional<VariableReferenceExpression> probeHashVariable, JoinBridgeManager<? extends LookupSourceFactory> lookupSourceFactoryManager, LocalExecutionPlanContext context) {
            List<Type> probeTypes = probeSource.getTypes();
            List probeOutputVariables = (List)node.getOutputVariables().stream().filter(node.getLeft().getOutputVariables()::contains).collect(ImmutableList.toImmutableList());
            ImmutableList probeOutputChannels = ImmutableList.copyOf((Collection)LocalExecutionPlanner.getChannelsForVariables(probeOutputVariables, probeSource.getLayout()));
            ImmutableList probeJoinChannels = ImmutableList.copyOf((Collection)LocalExecutionPlanner.getChannelsForVariables(probeVariables, probeSource.getLayout()));
            OptionalInt probeHashChannel = probeHashVariable.map(LocalExecutionPlanner.variableChannelGetter(probeSource)).map(OptionalInt::of).orElse(OptionalInt.empty());
            OptionalInt totalOperatorsCount = this.getJoinOperatorsCountForSpill(context, this.session);
            switch (node.getType()) {
                case INNER: {
                    return LocalExecutionPlanner.this.lookupJoinOperators.innerJoin(context.getNextOperatorId(), node.getId(), lookupSourceFactoryManager, probeTypes, (List<Integer>)probeJoinChannels, probeHashChannel, Optional.of(probeOutputChannels), totalOperatorsCount, LocalExecutionPlanner.this.partitioningSpillerFactory);
                }
                case LEFT: {
                    return LocalExecutionPlanner.this.lookupJoinOperators.probeOuterJoin(context.getNextOperatorId(), node.getId(), lookupSourceFactoryManager, probeTypes, (List<Integer>)probeJoinChannels, probeHashChannel, Optional.of(probeOutputChannels), totalOperatorsCount, LocalExecutionPlanner.this.partitioningSpillerFactory);
                }
                case RIGHT: {
                    return LocalExecutionPlanner.this.lookupJoinOperators.lookupOuterJoin(context.getNextOperatorId(), node.getId(), lookupSourceFactoryManager, probeTypes, (List<Integer>)probeJoinChannels, probeHashChannel, Optional.of(probeOutputChannels), totalOperatorsCount, LocalExecutionPlanner.this.partitioningSpillerFactory);
                }
                case FULL: {
                    return LocalExecutionPlanner.this.lookupJoinOperators.fullOuterJoin(context.getNextOperatorId(), node.getId(), lookupSourceFactoryManager, probeTypes, (List<Integer>)probeJoinChannels, probeHashChannel, Optional.of(probeOutputChannels), totalOperatorsCount, LocalExecutionPlanner.this.partitioningSpillerFactory);
                }
            }
            throw new UnsupportedOperationException("Unsupported join type: " + (Object)((Object)node.getType()));
        }

        private OptionalInt getJoinOperatorsCountForSpill(LocalExecutionPlanContext context, Session session) {
            OptionalInt driverInstanceCount = context.getDriverInstanceCount();
            if (SystemSessionProperties.isSpillEnabled(session)) {
                Preconditions.checkState((boolean)driverInstanceCount.isPresent(), (Object)"A fixed distribution is required for JOIN when spilling is enabled");
            }
            return driverInstanceCount;
        }

        private Map<VariableReferenceExpression, Integer> createJoinSourcesLayout(Map<VariableReferenceExpression, Integer> lookupSourceLayout, Map<VariableReferenceExpression, Integer> probeSourceLayout) {
            ImmutableMap.Builder joinSourcesLayout = ImmutableMap.builder();
            joinSourcesLayout.putAll(lookupSourceLayout);
            for (Map.Entry<VariableReferenceExpression, Integer> probeLayoutEntry : probeSourceLayout.entrySet()) {
                joinSourcesLayout.put((Object)probeLayoutEntry.getKey(), (Object)(probeLayoutEntry.getValue() + lookupSourceLayout.size()));
            }
            return joinSourcesLayout.build();
        }

        @Override
        public PhysicalOperation visitSemiJoin(SemiJoinNode node, LocalExecutionPlanContext context) {
            PhysicalOperation probeSource = (PhysicalOperation)node.getSource().accept((PlanVisitor)this, (Object)context);
            LocalExecutionPlanContext buildContext = context.createSubContext();
            PhysicalOperation buildSource = (PhysicalOperation)node.getFilteringSource().accept((PlanVisitor)this, (Object)buildContext);
            Preconditions.checkState((buildSource.getPipelineExecutionStrategy() == probeSource.getPipelineExecutionStrategy() ? 1 : 0) != 0, (Object)"build and probe have different pipelineExecutionStrategy");
            Preconditions.checkArgument((buildContext.getDriverInstanceCount().orElse(1) == 1 ? 1 : 0) != 0, (Object)"Expected local execution to not be parallel");
            int probeChannel = probeSource.getLayout().get(node.getSourceJoinVariable());
            int buildChannel = buildSource.getLayout().get(node.getFilteringSourceJoinVariable());
            Optional<Integer> buildHashChannel = node.getFilteringSourceHashVariable().map(LocalExecutionPlanner.variableChannelGetter(buildSource));
            SetBuilderOperator.SetBuilderOperatorFactory setBuilderOperatorFactory = new SetBuilderOperator.SetBuilderOperatorFactory(buildContext.getNextOperatorId(), node.getId(), buildSource.getTypes().get(buildChannel), buildChannel, buildHashChannel, 10000, LocalExecutionPlanner.this.joinCompiler);
            SetBuilderOperator.SetSupplier setProvider = setBuilderOperatorFactory.getSetProvider();
            context.addDriverFactory(buildContext.isInputDriver(), false, (List<OperatorFactory>)ImmutableList.builder().addAll((Iterable)buildSource.getOperatorFactories()).add((Object)setBuilderOperatorFactory).build(), buildContext.getDriverInstanceCount(), buildSource.getPipelineExecutionStrategy());
            ImmutableMap outputMappings = ImmutableMap.builder().putAll(probeSource.getLayout()).put((Object)node.getSemiJoinOutput(), (Object)probeSource.getLayout().size()).build();
            HashSemiJoinOperator.HashSemiJoinOperatorFactory operator = new HashSemiJoinOperator.HashSemiJoinOperatorFactory(context.getNextOperatorId(), node.getId(), setProvider, probeSource.getTypes(), probeChannel);
            return new PhysicalOperation((OperatorFactory)operator, (Map<VariableReferenceExpression, Integer>)outputMappings, context, probeSource);
        }

        @Override
        public PhysicalOperation visitTableWriter(TableWriterNode node, LocalExecutionPlanContext context) {
            if (node.getTablePartitioningScheme().isPresent()) {
                context.setDriverInstanceCount(SystemSessionProperties.getTaskPartitionedWriterCount(this.session));
            } else {
                context.setDriverInstanceCount(SystemSessionProperties.getTaskWriterCount(this.session));
            }
            PhysicalOperation source = (PhysicalOperation)node.getSource().accept((PlanVisitor)this, (Object)context);
            ImmutableMap.Builder outputMapping = ImmutableMap.builder();
            outputMapping.put((Object)node.getRowCountVariable(), (Object)0);
            outputMapping.put((Object)node.getFragmentVariable(), (Object)1);
            outputMapping.put((Object)node.getTableCommitContextVariable(), (Object)2);
            OperatorFactory statisticsAggregation = node.getStatisticsAggregation().map(aggregation -> {
                List<VariableReferenceExpression> groupingVariables = aggregation.getGroupingVariables();
                if (groupingVariables.isEmpty()) {
                    return this.createAggregationOperatorFactory(node.getId(), aggregation.getAggregations(), AggregationNode.Step.PARTIAL, 3, (ImmutableMap.Builder<VariableReferenceExpression, Integer>)outputMapping, source, context, true);
                }
                return this.createHashAggregationOperatorFactory(node.getId(), aggregation.getAggregations(), (Set<Integer>)ImmutableSet.of(), groupingVariables, AggregationNode.Step.PARTIAL, Optional.empty(), Optional.empty(), source, false, false, false, new DataSize(0.0, DataSize.Unit.BYTE), context, 3, (ImmutableMap.Builder<VariableReferenceExpression, Integer>)outputMapping, 200, Optional.empty(), true);
            }).orElse(new DevNullOperator.DevNullOperatorFactory(context.getNextOperatorId(), node.getId()));
            List inputChannels = (List)node.getColumns().stream().map(x$0 -> source.variableToChannel(x$0)).collect(ImmutableList.toImmutableList());
            TableWriterOperator.TableWriterOperatorFactory operatorFactory = new TableWriterOperator.TableWriterOperatorFactory(context.getNextOperatorId(), node.getId(), LocalExecutionPlanner.this.pageSinkManager, context.getTableWriteInfo().getWriterTarget().orElseThrow(() -> new VerifyException("writerTarget is absent")), inputChannels, this.session, statisticsAggregation, this.getVariableTypes(node.getOutputVariables()), (JsonCodec<TableCommitContext>)LocalExecutionPlanner.this.tableCommitContextCodec, this.getPageSinkCommitStrategy());
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<VariableReferenceExpression, Integer>)outputMapping.build(), context, source);
        }

        private PageSinkCommitStrategy getPageSinkCommitStrategy() {
            if (this.stageExecutionDescriptor.isRecoverableGroupedExecution()) {
                return PageSinkCommitStrategy.LIFESPAN_COMMIT;
            }
            if (this.pageSinkCommitRequired) {
                return PageSinkCommitStrategy.TASK_COMMIT;
            }
            return PageSinkCommitStrategy.NO_COMMIT;
        }

        @Override
        public PhysicalOperation visitStatisticsWriterNode(StatisticsWriterNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = (PhysicalOperation)node.getSource().accept((PlanVisitor)this, (Object)context);
            StatisticAggregationsDescriptor<Integer> descriptor = node.getDescriptor().map(source.getLayout()::get);
            AnalyzeTableHandle analyzeTableHandle = context.getTableWriteInfo().getAnalyzeTableHandle().orElseThrow(() -> new VerifyException("analyzeTableHandle is absent"));
            StatisticsWriterOperator.StatisticsWriterOperatorFactory operatorFactory = new StatisticsWriterOperator.StatisticsWriterOperatorFactory(context.getNextOperatorId(), node.getId(), computedStatistics -> LocalExecutionPlanner.this.metadata.finishStatisticsCollection(this.session, analyzeTableHandle, computedStatistics), node.isRowCountEnabled(), descriptor);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<VariableReferenceExpression, Integer>)this.makeLayout(node), context, source);
        }

        @Override
        public PhysicalOperation visitTableWriteMerge(TableWriterMergeNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = (PhysicalOperation)node.getSource().accept((PlanVisitor)this, (Object)context);
            ImmutableMap.Builder outputMapping = ImmutableMap.builder();
            outputMapping.put((Object)node.getRowCountVariable(), (Object)0);
            outputMapping.put((Object)node.getFragmentVariable(), (Object)1);
            outputMapping.put((Object)node.getTableCommitContextVariable(), (Object)2);
            OperatorFactory statisticsAggregation = node.getStatisticsAggregation().map(aggregation -> {
                List<VariableReferenceExpression> groupingVariables = aggregation.getGroupingVariables();
                if (groupingVariables.isEmpty()) {
                    return this.createAggregationOperatorFactory(node.getId(), aggregation.getAggregations(), AggregationNode.Step.INTERMEDIATE, 3, (ImmutableMap.Builder<VariableReferenceExpression, Integer>)outputMapping, source, context, true);
                }
                return this.createHashAggregationOperatorFactory(node.getId(), aggregation.getAggregations(), (Set<Integer>)ImmutableSet.of(), groupingVariables, AggregationNode.Step.INTERMEDIATE, Optional.empty(), Optional.empty(), source, false, false, false, new DataSize(0.0, DataSize.Unit.BYTE), context, 3, (ImmutableMap.Builder<VariableReferenceExpression, Integer>)outputMapping, 200, Optional.empty(), true);
            }).orElse(new DevNullOperator.DevNullOperatorFactory(context.getNextOperatorId(), node.getId()));
            TableWriterMergeOperator.TableWriterMergeOperatorFactory operatorFactory = new TableWriterMergeOperator.TableWriterMergeOperatorFactory(context.getNextOperatorId(), node.getId(), statisticsAggregation, (JsonCodec<TableCommitContext>)LocalExecutionPlanner.this.tableCommitContextCodec, this.session, this.getVariableTypes(node.getOutputVariables()));
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<VariableReferenceExpression, Integer>)outputMapping.build(), context, source);
        }

        @Override
        public PhysicalOperation visitTableFinish(TableFinishNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = (PhysicalOperation)node.getSource().accept((PlanVisitor)this, (Object)context);
            ImmutableMap.Builder outputMapping = ImmutableMap.builder();
            OperatorFactory statisticsAggregation = node.getStatisticsAggregation().map(aggregation -> {
                List<VariableReferenceExpression> groupingVariables = aggregation.getGroupingVariables();
                if (groupingVariables.isEmpty()) {
                    return this.createAggregationOperatorFactory(node.getId(), aggregation.getAggregations(), AggregationNode.Step.FINAL, 0, (ImmutableMap.Builder<VariableReferenceExpression, Integer>)outputMapping, source, context, true);
                }
                return this.createHashAggregationOperatorFactory(node.getId(), aggregation.getAggregations(), (Set<Integer>)ImmutableSet.of(), groupingVariables, AggregationNode.Step.FINAL, Optional.empty(), Optional.empty(), source, false, false, false, new DataSize(0.0, DataSize.Unit.BYTE), context, 0, (ImmutableMap.Builder<VariableReferenceExpression, Integer>)outputMapping, 200, Optional.empty(), true);
            }).orElse(new DevNullOperator.DevNullOperatorFactory(context.getNextOperatorId(), node.getId()));
            ImmutableMap aggregationOutput = outputMapping.build();
            StatisticAggregationsDescriptor<Integer> descriptor = node.getStatisticsAggregationDescriptor().map(arg_0 -> Visitor.lambda$visitTableFinish$41((Map)aggregationOutput, arg_0)).orElse(StatisticAggregationsDescriptor.empty());
            ExecutionWriterTarget writerTarget = context.getTableWriteInfo().getWriterTarget().orElseThrow(() -> new VerifyException("writerTarget is absent"));
            TableFinishOperator.TableFinishOperatorFactory operatorFactory = new TableFinishOperator.TableFinishOperatorFactory(context.getNextOperatorId(), node.getId(), LocalExecutionPlanner.createTableFinisher(this.session, LocalExecutionPlanner.this.metadata, writerTarget), LocalExecutionPlanner.createPageSinkCommitter(this.session, LocalExecutionPlanner.this.metadata, writerTarget), statisticsAggregation, descriptor, this.session, (JsonCodec<TableCommitContext>)LocalExecutionPlanner.this.tableCommitContextCodec);
            ImmutableMap layout = ImmutableMap.of((Object)node.getOutputVariables().get(0), (Object)0);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<VariableReferenceExpression, Integer>)layout, context, source);
        }

        @Override
        public PhysicalOperation visitDelete(DeleteNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = (PhysicalOperation)node.getSource().accept((PlanVisitor)this, (Object)context);
            DeleteOperator.DeleteOperatorFactory operatorFactory = new DeleteOperator.DeleteOperatorFactory(context.getNextOperatorId(), node.getId(), source.getLayout().get(node.getRowId()), (JsonCodec<TableCommitContext>)LocalExecutionPlanner.this.tableCommitContextCodec);
            ImmutableMap layout = ImmutableMap.builder().put((Object)node.getOutputVariables().get(0), (Object)0).put((Object)node.getOutputVariables().get(1), (Object)1).build();
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<VariableReferenceExpression, Integer>)layout, context, source);
        }

        @Override
        public PhysicalOperation visitMetadataDelete(MetadataDeleteNode node, LocalExecutionPlanContext context) {
            MetadataDeleteOperator.MetadataDeleteOperatorFactory operatorFactory = new MetadataDeleteOperator.MetadataDeleteOperatorFactory(context.getNextOperatorId(), node.getId(), LocalExecutionPlanner.this.metadata, this.session, node.getTableHandle());
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<VariableReferenceExpression, Integer>)this.makeLayout(node), context, PipelineExecutionStrategy.UNGROUPED_EXECUTION);
        }

        public PhysicalOperation visitUnion(UnionNode node, LocalExecutionPlanContext context) {
            throw new UnsupportedOperationException("Union node should not be present in a local execution plan");
        }

        @Override
        public PhysicalOperation visitEnforceSingleRow(EnforceSingleRowNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = (PhysicalOperation)node.getSource().accept((PlanVisitor)this, (Object)context);
            EnforceSingleRowOperator.EnforceSingleRowOperatorFactory operatorFactory = new EnforceSingleRowOperator.EnforceSingleRowOperatorFactory(context.getNextOperatorId(), node.getId());
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<VariableReferenceExpression, Integer>)this.makeLayout(node), context, source);
        }

        @Override
        public PhysicalOperation visitAssignUniqueId(AssignUniqueId node, LocalExecutionPlanContext context) {
            PhysicalOperation source = (PhysicalOperation)node.getSource().accept((PlanVisitor)this, (Object)context);
            AssignUniqueIdOperator.AssignUniqueIdOperatorFactory operatorFactory = new AssignUniqueIdOperator.AssignUniqueIdOperatorFactory(context.getNextOperatorId(), node.getId());
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<VariableReferenceExpression, Integer>)this.makeLayout(node), context, source);
        }

        @Override
        public PhysicalOperation visitExchange(ExchangeNode node, LocalExecutionPlanContext context) {
            Preconditions.checkArgument((boolean)node.getScope().isLocal(), (Object)"Only local exchanges are supported in the local planner");
            if (node.getOrderingScheme().isPresent()) {
                return this.createLocalMerge(node, context);
            }
            return this.createLocalExchange(node, context);
        }

        private PhysicalOperation createLocalMerge(ExchangeNode node, LocalExecutionPlanContext context) {
            Preconditions.checkArgument((boolean)node.getOrderingScheme().isPresent(), (Object)"orderingScheme is absent");
            Preconditions.checkState((node.getSources().size() == 1 ? 1 : 0) != 0, (Object)"single source is expected");
            context.setDriverInstanceCount(1);
            PlanNode sourceNode = (PlanNode)Iterables.getOnlyElement(node.getSources());
            LocalExecutionPlanContext subContext = context.createSubContext();
            PhysicalOperation source = (PhysicalOperation)sourceNode.accept((PlanVisitor)this, (Object)subContext);
            int operatorsCount = subContext.getDriverInstanceCount().orElse(1);
            List<Type> types = this.getSourceOperatorTypes(node);
            LocalExchange.LocalExchangeFactory exchangeFactory = new LocalExchange.LocalExchangeFactory(LocalExecutionPlanner.this.partitioningProviderManager, this.session, node.getPartitioningScheme().getPartitioning().getHandle(), operatorsCount, types, (List<Integer>)ImmutableList.of(), Optional.empty(), source.getPipelineExecutionStrategy(), LocalExecutionPlanner.this.maxLocalExchangeBufferSize);
            ArrayList<OperatorFactory> operatorFactories = new ArrayList<OperatorFactory>(source.getOperatorFactories());
            List<VariableReferenceExpression> expectedLayout = node.getInputs().get(0);
            Function pagePreprocessor = LocalExecutionPlanner.enforceLayoutProcessor(expectedLayout, source.getLayout());
            operatorFactories.add(new LocalExchangeSinkOperator.LocalExchangeSinkOperatorFactory(exchangeFactory, subContext.getNextOperatorId(), node.getId(), exchangeFactory.newSinkFactoryId(), pagePreprocessor));
            context.addDriverFactory(subContext.isInputDriver(), false, operatorFactories, subContext.getDriverInstanceCount(), source.getPipelineExecutionStrategy());
            context.setInputDriver(false);
            OrderingScheme orderingScheme = node.getOrderingScheme().get();
            ImmutableMap<VariableReferenceExpression, Integer> layout = this.makeLayout(node);
            List sortChannels = LocalExecutionPlanner.getChannelsForVariables(orderingScheme.getOrderByVariables(), layout);
            List orderings = LocalExecutionPlanner.getOrderingList(orderingScheme);
            LocalMergeSourceOperator.LocalMergeSourceOperatorFactory operatorFactory = new LocalMergeSourceOperator.LocalMergeSourceOperatorFactory(context.getNextOperatorId(), node.getId(), exchangeFactory, types, LocalExecutionPlanner.this.orderingCompiler, sortChannels, orderings);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<VariableReferenceExpression, Integer>)layout, context, PipelineExecutionStrategy.UNGROUPED_EXECUTION);
        }

        private PhysicalOperation createLocalExchange(ExchangeNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source;
            int driverInstanceCount;
            if (node.getType() == ExchangeNode.Type.GATHER) {
                driverInstanceCount = 1;
                context.setDriverInstanceCount(1);
            } else if (context.getDriverInstanceCount().isPresent()) {
                driverInstanceCount = context.getDriverInstanceCount().getAsInt();
            } else {
                driverInstanceCount = SystemSessionProperties.getTaskConcurrency(this.session);
                context.setDriverInstanceCount(driverInstanceCount);
            }
            List<Type> types = this.getSourceOperatorTypes(node);
            List channels = (List)node.getPartitioningScheme().getPartitioning().getArguments().stream().map(argument -> {
                Preconditions.checkArgument((boolean)(argument instanceof VariableReferenceExpression), (Object)String.format("Expect VariableReferenceExpression but get %s", argument));
                return node.getOutputVariables().indexOf(argument);
            }).collect(ImmutableList.toImmutableList());
            Optional<Integer> hashChannel = node.getPartitioningScheme().getHashColumn().map(variable -> node.getOutputVariables().indexOf(variable));
            PipelineExecutionStrategy exchangeSourcePipelineExecutionStrategy = PipelineExecutionStrategy.GROUPED_EXECUTION;
            ArrayList<DriverFactoryParameters> driverFactoryParametersList = new ArrayList<DriverFactoryParameters>();
            for (int i = 0; i < node.getSources().size(); ++i) {
                PlanNode sourceNode = node.getSources().get(i);
                LocalExecutionPlanContext subContext = context.createSubContext();
                source = (PhysicalOperation)sourceNode.accept((PlanVisitor)this, (Object)subContext);
                driverFactoryParametersList.add(new DriverFactoryParameters(subContext, source));
                if (source.getPipelineExecutionStrategy() != PipelineExecutionStrategy.UNGROUPED_EXECUTION) continue;
                exchangeSourcePipelineExecutionStrategy = PipelineExecutionStrategy.UNGROUPED_EXECUTION;
            }
            LocalExchange.LocalExchangeFactory localExchangeFactory = new LocalExchange.LocalExchangeFactory(LocalExecutionPlanner.this.partitioningProviderManager, this.session, node.getPartitioningScheme().getPartitioning().getHandle(), driverInstanceCount, types, channels, hashChannel, exchangeSourcePipelineExecutionStrategy, LocalExecutionPlanner.this.maxLocalExchangeBufferSize);
            for (int i = 0; i < node.getSources().size(); ++i) {
                DriverFactoryParameters driverFactoryParameters = (DriverFactoryParameters)driverFactoryParametersList.get(i);
                source = driverFactoryParameters.getSource();
                LocalExecutionPlanContext subContext = driverFactoryParameters.getSubContext();
                List<VariableReferenceExpression> expectedLayout = node.getInputs().get(i);
                Function pagePreprocessor = LocalExecutionPlanner.enforceLayoutProcessor(expectedLayout, source.getLayout());
                ArrayList<OperatorFactory> operatorFactories = new ArrayList<OperatorFactory>(source.getOperatorFactories());
                operatorFactories.add(new LocalExchangeSinkOperator.LocalExchangeSinkOperatorFactory(localExchangeFactory, subContext.getNextOperatorId(), node.getId(), localExchangeFactory.newSinkFactoryId(), pagePreprocessor));
                context.addDriverFactory(subContext.isInputDriver(), false, operatorFactories, subContext.getDriverInstanceCount(), exchangeSourcePipelineExecutionStrategy);
            }
            context.setInputDriver(false);
            Verify.verify((context.getDriverInstanceCount().getAsInt() == localExchangeFactory.getBufferCount() ? 1 : 0) != 0, (String)"driver instance count must match the number of exchange partitions", (Object[])new Object[0]);
            return new PhysicalOperation((OperatorFactory)new LocalExchangeSourceOperator.LocalExchangeSourceOperatorFactory(context.getNextOperatorId(), node.getId(), localExchangeFactory), (Map<VariableReferenceExpression, Integer>)this.makeLayout(node), context, exchangeSourcePipelineExecutionStrategy);
        }

        public PhysicalOperation visitPlan(PlanNode node, LocalExecutionPlanContext context) {
            throw new UnsupportedOperationException("not yet implemented");
        }

        private List<Type> getSourceOperatorTypes(PlanNode node) {
            return this.getVariableTypes(node.getOutputVariables());
        }

        private List<Type> getVariableTypes(List<VariableReferenceExpression> variables) {
            return (List)variables.stream().map(VariableReferenceExpression::getType).collect(ImmutableList.toImmutableList());
        }

        private AccumulatorFactory buildAccumulatorFactory(PhysicalOperation source, AggregationNode.Aggregation aggregation) {
            FunctionManager functionManager = LocalExecutionPlanner.this.metadata.getFunctionManager();
            InternalAggregationFunction internalAggregationFunction = functionManager.getAggregateFunctionImplementation(aggregation.getFunctionHandle());
            ArrayList<Integer> valueChannels = new ArrayList<Integer>();
            for (RowExpression argument : aggregation.getArguments()) {
                if (argument instanceof LambdaDefinitionExpression) continue;
                Preconditions.checkArgument((boolean)(argument instanceof VariableReferenceExpression), (Object)"argument must be variable reference");
                valueChannels.add(source.getLayout().get(argument));
            }
            ArrayList<LambdaProvider> lambdaProviders = new ArrayList<LambdaProvider>();
            List lambdas = (List)aggregation.getArguments().stream().filter(LambdaDefinitionExpression.class::isInstance).map(LambdaDefinitionExpression.class::cast).collect(ImmutableList.toImmutableList());
            for (int i = 0; i < lambdas.size(); ++i) {
                List<Class> lambdaInterfaces = internalAggregationFunction.getLambdaInterfaces();
                Class<? extends LambdaProvider> lambdaProviderClass = LambdaBytecodeGenerator.compileLambdaProvider((LambdaDefinitionExpression)lambdas.get(i), LocalExecutionPlanner.this.metadata, this.session.getSqlFunctionProperties(), lambdaInterfaces.get(i));
                try {
                    lambdaProviders.add(Reflection.constructorMethodHandle(lambdaProviderClass, SqlFunctionProperties.class).invoke(this.session.getSqlFunctionProperties()));
                    continue;
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
            Optional<Integer> maskChannel = aggregation.getMask().map(value -> source.getLayout().get(value));
            Object sortOrders = ImmutableList.of();
            Object sortKeys = ImmutableList.of();
            if (aggregation.getOrderBy().isPresent()) {
                OrderingScheme orderBy = (OrderingScheme)aggregation.getOrderBy().get();
                sortKeys = orderBy.getOrderByVariables();
                sortOrders = LocalExecutionPlanner.getOrderingList(orderBy);
            }
            return internalAggregationFunction.bind(valueChannels, maskChannel, source.getTypes(), LocalExecutionPlanner.getChannelsForVariables((Collection)sortKeys, source.getLayout()), (List<SortOrder>)sortOrders, LocalExecutionPlanner.this.pagesIndexFactory, aggregation.isDistinct(), LocalExecutionPlanner.this.joinCompiler, lambdaProviders, this.session);
        }

        private PhysicalOperation planGlobalAggregation(AggregationNode node, PhysicalOperation source, LocalExecutionPlanContext context) {
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            AggregationOperator.AggregationOperatorFactory operatorFactory = this.createAggregationOperatorFactory(node.getId(), node.getAggregations(), node.getStep(), 0, (ImmutableMap.Builder<VariableReferenceExpression, Integer>)outputMappings, source, context, node.getStep().isOutputPartial());
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<VariableReferenceExpression, Integer>)outputMappings.build(), context, source);
        }

        private AggregationOperator.AggregationOperatorFactory createAggregationOperatorFactory(PlanNodeId planNodeId, Map<VariableReferenceExpression, AggregationNode.Aggregation> aggregations, AggregationNode.Step step, int startOutputChannel, ImmutableMap.Builder<VariableReferenceExpression, Integer> outputMappings, PhysicalOperation source, LocalExecutionPlanContext context, boolean useSystemMemory) {
            int outputChannel = startOutputChannel;
            ImmutableList.Builder accumulatorFactories = ImmutableList.builder();
            for (Map.Entry<VariableReferenceExpression, AggregationNode.Aggregation> entry : aggregations.entrySet()) {
                VariableReferenceExpression variable = entry.getKey();
                AggregationNode.Aggregation aggregation = entry.getValue();
                accumulatorFactories.add((Object)this.buildAccumulatorFactory(source, aggregation));
                outputMappings.put((Object)variable, (Object)outputChannel);
                ++outputChannel;
            }
            return new AggregationOperator.AggregationOperatorFactory(context.getNextOperatorId(), planNodeId, step, (List<AccumulatorFactory>)accumulatorFactories.build(), useSystemMemory);
        }

        private PhysicalOperation planGroupByAggregation(AggregationNode node, PhysicalOperation source, boolean spillEnabled, DataSize unspillMemoryLimit, LocalExecutionPlanContext context) {
            ImmutableMap.Builder mappings = ImmutableMap.builder();
            OperatorFactory operatorFactory = this.createHashAggregationOperatorFactory(node.getId(), node.getAggregations(), node.getGlobalGroupingSets(), node.getGroupingKeys(), node.getStep(), node.getHashVariable(), node.getGroupIdVariable(), source, node.hasDefaultOutput(), spillEnabled, node.isStreamable(), unspillMemoryLimit, context, 0, (ImmutableMap.Builder<VariableReferenceExpression, Integer>)mappings, 10000, Optional.of(LocalExecutionPlanner.this.maxPartialAggregationMemorySize), node.getStep().isOutputPartial());
            return new PhysicalOperation(operatorFactory, (Map<VariableReferenceExpression, Integer>)mappings.build(), context, source);
        }

        private OperatorFactory createHashAggregationOperatorFactory(PlanNodeId planNodeId, Map<VariableReferenceExpression, AggregationNode.Aggregation> aggregations, Set<Integer> globalGroupingSets, List<VariableReferenceExpression> groupbyVariables, AggregationNode.Step step, Optional<VariableReferenceExpression> hashVariable, Optional<VariableReferenceExpression> groupIdVariable, PhysicalOperation source, boolean hasDefaultOutput, boolean spillEnabled, boolean isStreamable, DataSize unspillMemoryLimit, LocalExecutionPlanContext context, int startOutputChannel, ImmutableMap.Builder<VariableReferenceExpression, Integer> outputMappings, int expectedGroups, Optional<DataSize> maxPartialAggregationMemorySize, boolean useSystemMemory) {
            ArrayList<Object> aggregationOutputVariables = new ArrayList<Object>();
            ArrayList<AccumulatorFactory> accumulatorFactories = new ArrayList<AccumulatorFactory>();
            for (Map.Entry<VariableReferenceExpression, AggregationNode.Aggregation> entry2 : aggregations.entrySet()) {
                VariableReferenceExpression variable = entry2.getKey();
                AggregationNode.Aggregation aggregation = entry2.getValue();
                accumulatorFactories.add(this.buildAccumulatorFactory(source, aggregation));
                aggregationOutputVariables.add(variable);
            }
            int channel = startOutputChannel;
            Optional<Integer> groupIdChannel = Optional.empty();
            for (VariableReferenceExpression variableReferenceExpression : groupbyVariables) {
                outputMappings.put((Object)variableReferenceExpression, (Object)channel);
                if (groupIdVariable.isPresent() && groupIdVariable.get().equals((Object)variableReferenceExpression)) {
                    groupIdChannel = Optional.of(channel);
                }
                ++channel;
            }
            if (hashVariable.isPresent()) {
                outputMappings.put((Object)hashVariable.get(), (Object)channel++);
            }
            for (VariableReferenceExpression variableReferenceExpression : aggregationOutputVariables) {
                outputMappings.put((Object)variableReferenceExpression, (Object)channel);
                ++channel;
            }
            List groupByChannels = LocalExecutionPlanner.getChannelsForVariables(groupbyVariables, source.getLayout());
            List list = (List)groupByChannels.stream().map(entry -> source.getTypes().get((int)entry)).collect(ImmutableList.toImmutableList());
            if (isStreamable) {
                return new StreamingAggregationOperator.StreamingAggregationOperatorFactory(context.getNextOperatorId(), planNodeId, source.getTypes(), list, groupByChannels, step, accumulatorFactories, LocalExecutionPlanner.this.joinCompiler);
            }
            Optional<Integer> hashChannel = hashVariable.map(LocalExecutionPlanner.variableChannelGetter(source));
            return new HashAggregationOperator.HashAggregationOperatorFactory(context.getNextOperatorId(), planNodeId, list, groupByChannels, (List<Integer>)ImmutableList.copyOf(globalGroupingSets), step, hasDefaultOutput, accumulatorFactories, hashChannel, groupIdChannel, expectedGroups, maxPartialAggregationMemorySize, spillEnabled, unspillMemoryLimit, LocalExecutionPlanner.this.spillerFactory, LocalExecutionPlanner.this.joinCompiler, useSystemMemory);
        }

        private static /* synthetic */ StatisticAggregationsDescriptor lambda$visitTableFinish$41(Map aggregationOutput, StatisticAggregationsDescriptor desc) {
            return desc.map(aggregationOutput::get);
        }

        private static /* synthetic */ PartitionedLookupSourceFactory lambda$createLookupSourceFactory$33(PhysicalOperation buildSource, ImmutableList buildOutputTypes, List buildChannels, LocalExecutionPlanContext buildContext, boolean buildOuter, Lifespan lifespan) {
            return new PartitionedLookupSourceFactory(buildSource.getTypes(), (List<Type>)buildOutputTypes, (List)buildChannels.stream().map(buildSource.getTypes()::get).collect(ImmutableList.toImmutableList()), buildContext.getDriverInstanceCount().orElse(1), buildSource.getLayout(), buildOuter);
        }

        private /* synthetic */ RecordSet lambda$visitIndexSource$6(List overlappingFieldSets, List remappedProbeKeyChannels, RecordSet recordSet) {
            if (!overlappingFieldSets.isEmpty()) {
                recordSet = new FieldSetFilteringRecordSet(LocalExecutionPlanner.this.metadata.getFunctionManager(), recordSet, overlappingFieldSets);
            }
            return new MappedRecordSet(recordSet, remappedProbeKeyChannels);
        }
    }

    public static class LocalExecutionPlan {
        private final List<DriverFactory> driverFactories;
        private final List<PlanNodeId> tableScanSourceOrder;
        private final StageExecutionDescriptor stageExecutionDescriptor;

        public LocalExecutionPlan(List<DriverFactory> driverFactories, List<PlanNodeId> tableScanSourceOrder, StageExecutionDescriptor stageExecutionDescriptor) {
            this.driverFactories = ImmutableList.copyOf((Collection)Objects.requireNonNull(driverFactories, "driverFactories is null"));
            this.tableScanSourceOrder = ImmutableList.copyOf((Collection)Objects.requireNonNull(tableScanSourceOrder, "tableScanSourceOrder is null"));
            this.stageExecutionDescriptor = Objects.requireNonNull(stageExecutionDescriptor, "stageExecutionDescriptor is null");
        }

        public List<DriverFactory> getDriverFactories() {
            return this.driverFactories;
        }

        public List<PlanNodeId> getTableScanSourceOrder() {
            return this.tableScanSourceOrder;
        }

        public StageExecutionDescriptor getStageExecutionDescriptor() {
            return this.stageExecutionDescriptor;
        }
    }

    private static class IndexSourceContext {
        private final SetMultimap<VariableReferenceExpression, Integer> indexLookupToProbeInput;

        public IndexSourceContext(SetMultimap<VariableReferenceExpression, Integer> indexLookupToProbeInput) {
            this.indexLookupToProbeInput = ImmutableSetMultimap.copyOf((Multimap)((Multimap)Objects.requireNonNull(indexLookupToProbeInput, "indexLookupToProbeInput is null")));
        }

        private SetMultimap<VariableReferenceExpression, Integer> getIndexLookupToProbeInput() {
            return this.indexLookupToProbeInput;
        }
    }

    private static class LocalExecutionPlanContext {
        private final TaskContext taskContext;
        private final List<DriverFactory> driverFactories;
        private final Optional<IndexSourceContext> indexSourceContext;
        private final AtomicInteger nextPipelineId;
        private final TableWriteInfo tableWriteInfo;
        private int nextOperatorId;
        private boolean inputDriver = true;
        private OptionalInt driverInstanceCount = OptionalInt.empty();

        public LocalExecutionPlanContext(TaskContext taskContext, TableWriteInfo tableWriteInfo) {
            this(taskContext, new ArrayList<DriverFactory>(), Optional.empty(), new AtomicInteger(0), tableWriteInfo);
        }

        private LocalExecutionPlanContext(TaskContext taskContext, List<DriverFactory> driverFactories, Optional<IndexSourceContext> indexSourceContext, AtomicInteger nextPipelineId, TableWriteInfo tableWriteInfo) {
            this.taskContext = taskContext;
            this.driverFactories = driverFactories;
            this.indexSourceContext = indexSourceContext;
            this.nextPipelineId = nextPipelineId;
            this.tableWriteInfo = tableWriteInfo;
        }

        public void addDriverFactory(boolean inputDriver, boolean outputDriver, List<OperatorFactory> operatorFactories, OptionalInt driverInstances, PipelineExecutionStrategy pipelineExecutionStrategy) {
            if (pipelineExecutionStrategy == PipelineExecutionStrategy.GROUPED_EXECUTION) {
                OperatorFactory firstOperatorFactory = operatorFactories.get(0);
                if (inputDriver) {
                    Preconditions.checkArgument((firstOperatorFactory instanceof ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory || firstOperatorFactory instanceof TableScanOperator.TableScanOperatorFactory ? 1 : 0) != 0);
                } else {
                    Preconditions.checkArgument((firstOperatorFactory instanceof LocalExchangeSourceOperator.LocalExchangeSourceOperatorFactory || firstOperatorFactory instanceof LookupOuterOperator.LookupOuterOperatorFactory ? 1 : 0) != 0);
                }
            }
            this.driverFactories.add(new DriverFactory(this.getNextPipelineId(), inputDriver, outputDriver, operatorFactories, driverInstances, pipelineExecutionStrategy));
        }

        private List<DriverFactory> getDriverFactories() {
            return ImmutableList.copyOf(this.driverFactories);
        }

        public Session getSession() {
            return this.taskContext.getSession();
        }

        public StageExecutionId getStageExecutionId() {
            return this.taskContext.getTaskId().getStageExecutionId();
        }

        public Optional<IndexSourceContext> getIndexSourceContext() {
            return this.indexSourceContext;
        }

        private int getNextPipelineId() {
            return this.nextPipelineId.getAndIncrement();
        }

        private int getNextOperatorId() {
            return this.nextOperatorId++;
        }

        private boolean isInputDriver() {
            return this.inputDriver;
        }

        private void setInputDriver(boolean inputDriver) {
            this.inputDriver = inputDriver;
        }

        public TableWriteInfo getTableWriteInfo() {
            return this.tableWriteInfo;
        }

        public LocalExecutionPlanContext createSubContext() {
            Preconditions.checkState((!this.indexSourceContext.isPresent() ? 1 : 0) != 0, (Object)"index build plan can not have sub-contexts");
            return new LocalExecutionPlanContext(this.taskContext, this.driverFactories, this.indexSourceContext, this.nextPipelineId, this.tableWriteInfo);
        }

        public LocalExecutionPlanContext createIndexSourceSubContext(IndexSourceContext indexSourceContext) {
            return new LocalExecutionPlanContext(this.taskContext, this.driverFactories, Optional.of(indexSourceContext), this.nextPipelineId, this.tableWriteInfo);
        }

        public OptionalInt getDriverInstanceCount() {
            return this.driverInstanceCount;
        }

        public void setDriverInstanceCount(int driverInstanceCount) {
            Preconditions.checkArgument((driverInstanceCount > 0 ? 1 : 0) != 0, (Object)"driverInstanceCount must be > 0");
            if (this.driverInstanceCount.isPresent()) {
                Preconditions.checkState((this.driverInstanceCount.getAsInt() == driverInstanceCount ? 1 : 0) != 0, (Object)("driverInstance count already set to " + this.driverInstanceCount.getAsInt()));
            }
            this.driverInstanceCount = OptionalInt.of(driverInstanceCount);
        }
    }
}

