/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.Parameter;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;

public class ParameterRewriter
extends ExpressionRewriter<Void> {
    private final List<Expression> parameterValues;
    private final Analysis analysis;

    public ParameterRewriter(List<Expression> parameterValues) {
        Objects.requireNonNull(parameterValues, "parameterValues is null");
        this.parameterValues = parameterValues;
        this.analysis = null;
    }

    public ParameterRewriter(List<Expression> parameterValues, Analysis analysis) {
        Objects.requireNonNull(parameterValues, "parameterValues is null");
        this.parameterValues = parameterValues;
        this.analysis = analysis;
    }

    public Expression rewriteExpression(Expression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
        return treeRewriter.defaultRewrite(node, (Object)context);
    }

    public Expression rewriteParameter(Parameter node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
        Preconditions.checkState((this.parameterValues.size() > node.getPosition() ? 1 : 0) != 0, (Object)"Too few parameter values");
        return this.coerceIfNecessary((Expression)node, this.parameterValues.get(node.getPosition()));
    }

    private Expression coerceIfNecessary(Expression original, Expression rewritten) {
        if (this.analysis == null) {
            return rewritten;
        }
        Type coercion = this.analysis.getCoercion(original);
        if (coercion != null) {
            rewritten = new Cast(rewritten, coercion.getTypeSignature().toString(), false, this.analysis.isTypeOnlyCoercion(original));
        }
        return rewritten;
    }
}

