/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.optimizations.PlanNodeDecorrelator;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.ExistsPredicate;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TransformExistsApplyToLateralNode
implements Rule<ApplyNode> {
    private static final Pattern<ApplyNode> PATTERN = Patterns.applyNode();
    private final StandardFunctionResolution functionResolution;

    public TransformExistsApplyToLateralNode(FunctionManager functionManager) {
        Objects.requireNonNull(functionManager, "functionManager is null");
        this.functionResolution = new FunctionResolution(functionManager);
    }

    @Override
    public Pattern<ApplyNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ApplyNode parent, Captures captures, Rule.Context context) {
        if (parent.getSubqueryAssignments().size() != 1) {
            return Rule.Result.empty();
        }
        Expression expression = OriginalExpressionUtils.castToExpression((RowExpression)Iterables.getOnlyElement((Iterable)parent.getSubqueryAssignments().getExpressions()));
        if (!(expression instanceof ExistsPredicate)) {
            return Rule.Result.empty();
        }
        Optional<PlanNode> nonDefaultAggregation = this.rewriteToNonDefaultAggregation(parent, context);
        return nonDefaultAggregation.map(Rule.Result::ofPlanNode).orElseGet(() -> Rule.Result.ofPlanNode(this.rewriteToDefaultAggregation(parent, context)));
    }

    private Optional<PlanNode> rewriteToNonDefaultAggregation(ApplyNode applyNode, Rule.Context context) {
        Preconditions.checkState((boolean)applyNode.getSubquery().getOutputVariables().isEmpty(), (Object)"Expected subquery output variables to be pruned");
        VariableReferenceExpression exists = (VariableReferenceExpression)Iterables.getOnlyElement((Iterable)applyNode.getSubqueryAssignments().getVariables());
        VariableReferenceExpression subqueryTrue = context.getVariableAllocator().newVariable("subqueryTrue", (Type)BooleanType.BOOLEAN);
        Assignments.Builder assignments = Assignments.builder();
        assignments.putAll(AssignmentUtils.identitiesAsSymbolReferences(applyNode.getInput().getOutputVariables()));
        assignments.put(exists, OriginalExpressionUtils.castToRowExpression((Expression)new CoalesceExpression((List)ImmutableList.of((Object)new SymbolReference(subqueryTrue.getName()), (Object)BooleanLiteral.FALSE_LITERAL))));
        ProjectNode subquery = new ProjectNode(context.getIdAllocator().getNextId(), (PlanNode)new LimitNode(context.getIdAllocator().getNextId(), applyNode.getSubquery(), 1L, LimitNode.Step.FINAL), Assignments.of((VariableReferenceExpression)subqueryTrue, (RowExpression)OriginalExpressionUtils.castToRowExpression((Expression)BooleanLiteral.TRUE_LITERAL)));
        PlanNodeDecorrelator decorrelator = new PlanNodeDecorrelator(context.getIdAllocator(), context.getVariableAllocator(), context.getLookup());
        if (!decorrelator.decorrelateFilters((PlanNode)subquery, applyNode.getCorrelation()).isPresent()) {
            return Optional.empty();
        }
        return Optional.of(new ProjectNode(context.getIdAllocator().getNextId(), (PlanNode)new LateralJoinNode(applyNode.getId(), applyNode.getInput(), (PlanNode)subquery, applyNode.getCorrelation(), LateralJoinNode.Type.LEFT, applyNode.getOriginSubqueryError()), assignments.build()));
    }

    private PlanNode rewriteToDefaultAggregation(ApplyNode parent, Rule.Context context) {
        VariableReferenceExpression count = context.getVariableAllocator().newVariable("count", (Type)BigintType.BIGINT);
        VariableReferenceExpression exists = (VariableReferenceExpression)Iterables.getOnlyElement((Iterable)parent.getSubqueryAssignments().getVariables());
        return new LateralJoinNode(parent.getId(), parent.getInput(), (PlanNode)new ProjectNode(context.getIdAllocator().getNextId(), (PlanNode)new AggregationNode(context.getIdAllocator().getNextId(), parent.getSubquery(), (Map)ImmutableMap.of((Object)count, (Object)new AggregationNode.Aggregation(new CallExpression("count", this.functionResolution.countFunction(), (Type)BigintType.BIGINT, (List)ImmutableList.of()), Optional.empty(), Optional.empty(), false, Optional.empty())), AggregationNode.globalAggregation(), (List)ImmutableList.of(), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty()), Assignments.of((VariableReferenceExpression)exists, (RowExpression)OriginalExpressionUtils.castToRowExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)OriginalExpressionUtils.asSymbolReference(count), (Expression)new Cast((Expression)new LongLiteral("0"), BigintType.BIGINT.toString()))))), parent.getCorrelation(), LateralJoinNode.Type.INNER, parent.getOriginSubqueryError());
    }
}

