/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.ExceptNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.IntersectNode;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.sql.planner.plan.AssignUniqueId;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import java.util.function.Function;

public final class DistinctOutputQueryUtil {
    private DistinctOutputQueryUtil() {
    }

    public static boolean isDistinct(PlanNode node) {
        return (Boolean)node.accept((PlanVisitor)new IsDistinctPlanVisitor(Function.identity()), null);
    }

    public static boolean isDistinct(PlanNode node, Function<PlanNode, PlanNode> lookupFunction) {
        return (Boolean)node.accept((PlanVisitor)new IsDistinctPlanVisitor(lookupFunction), null);
    }

    private static final class IsDistinctPlanVisitor
    extends InternalPlanVisitor<Boolean, Void> {
        private final Function<PlanNode, PlanNode> lookupFunction;

        private IsDistinctPlanVisitor(Function<PlanNode, PlanNode> lookupFunction) {
            this.lookupFunction = lookupFunction;
        }

        public Boolean visitPlan(PlanNode node, Void context) {
            return false;
        }

        public Boolean visitAggregation(AggregationNode node, Void context) {
            return true;
        }

        @Override
        public Boolean visitAssignUniqueId(AssignUniqueId node, Void context) {
            return true;
        }

        @Override
        public Boolean visitDistinctLimit(DistinctLimitNode node, Void context) {
            return true;
        }

        @Override
        public Boolean visitEnforceSingleRow(EnforceSingleRowNode node, Void context) {
            return true;
        }

        public Boolean visitExcept(ExceptNode node, Void context) {
            return true;
        }

        public Boolean visitFilter(FilterNode node, Void context) {
            return (Boolean)this.lookupFunction.apply(node.getSource()).accept((PlanVisitor)this, null);
        }

        public Boolean visitIntersect(IntersectNode node, Void context) {
            return true;
        }

        public Boolean visitValues(ValuesNode node, Void context) {
            return node.getRows().size() == 1;
        }

        public Boolean visitLimit(LimitNode node, Void context) {
            return node.getCount() <= 1L;
        }

        public Boolean visitTopN(TopNNode node, Void context) {
            return node.getCount() <= 1L;
        }
    }
}

