/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.TableLayout;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.LocalProperty;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.MarkDistinctNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.PlannerUtils;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.ActualProperties;
import com.facebook.presto.sql.planner.optimizations.PropertyDerivations;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.AssignUniqueId;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.SpatialJoinNode;
import com.facebook.presto.sql.planner.plan.StatisticsWriterNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableWriterMergeNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;

public final class StreamPropertyDerivations {
    private StreamPropertyDerivations() {
    }

    public static StreamProperties derivePropertiesRecursively(PlanNode node, Metadata metadata, Session session, TypeProvider types, SqlParser parser) {
        List inputProperties = (List)node.getSources().stream().map(source -> StreamPropertyDerivations.derivePropertiesRecursively(source, metadata, session, types, parser)).collect(ImmutableList.toImmutableList());
        return StreamPropertyDerivations.deriveProperties(node, inputProperties, metadata, session, types, parser);
    }

    public static StreamProperties deriveProperties(PlanNode node, StreamProperties inputProperties, Metadata metadata, Session session, TypeProvider types, SqlParser parser) {
        return StreamPropertyDerivations.deriveProperties(node, (List<StreamProperties>)ImmutableList.of((Object)inputProperties), metadata, session, types, parser);
    }

    public static StreamProperties deriveProperties(PlanNode node, List<StreamProperties> inputProperties, Metadata metadata, Session session, TypeProvider types, SqlParser parser) {
        Objects.requireNonNull(node, "node is null");
        Objects.requireNonNull(inputProperties, "inputProperties is null");
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(parser, "parser is null");
        ActualProperties otherProperties = PropertyDerivations.streamBackdoorDeriveProperties(node, (List)inputProperties.stream().map(properties -> ((StreamProperties)properties).otherActualProperties).collect(ImmutableList.toImmutableList()), metadata, session, types, parser);
        StreamProperties result = ((StreamProperties)node.accept((PlanVisitor)new Visitor(metadata, session, types), inputProperties)).withOtherActualProperties(otherProperties);
        result.getPartitioningColumns().ifPresent(columns -> Verify.verify((boolean)node.getOutputVariables().containsAll((Collection<?>)columns), (String)"Stream-level partitioning properties contain columns not present in node's output", (Object[])new Object[0]));
        Set localPropertyColumns = result.getLocalProperties().stream().flatMap(property -> property.getColumns().stream()).collect(Collectors.toSet());
        Verify.verify((boolean)node.getOutputVariables().containsAll(localPropertyColumns), (String)"Stream-level local properties contain columns not present in node's output", (Object[])new Object[0]);
        return result;
    }

    @Immutable
    public static final class StreamProperties {
        private final StreamDistribution distribution;
        private final Optional<List<VariableReferenceExpression>> partitioningColumns;
        private final boolean ordered;
        private final ActualProperties otherActualProperties;

        private StreamProperties(StreamDistribution distribution, Optional<? extends Iterable<VariableReferenceExpression>> partitioningColumns, boolean ordered) {
            this(distribution, partitioningColumns, ordered, null);
        }

        private StreamProperties(StreamDistribution distribution, Optional<? extends Iterable<VariableReferenceExpression>> partitioningColumns, boolean ordered, ActualProperties otherActualProperties) {
            this.distribution = Objects.requireNonNull(distribution, "distribution is null");
            this.partitioningColumns = Objects.requireNonNull(partitioningColumns, "partitioningProperties is null").map(ImmutableList::copyOf);
            Preconditions.checkArgument((distribution != StreamDistribution.SINGLE || this.partitioningColumns.equals(Optional.of(ImmutableList.of())) ? 1 : 0) != 0, (Object)"Single stream must be partitioned on empty set");
            Preconditions.checkArgument((distribution == StreamDistribution.SINGLE || !this.partitioningColumns.equals(Optional.of(ImmutableList.of())) ? 1 : 0) != 0, (Object)"Multiple streams must not be partitioned on empty set");
            this.ordered = ordered;
            Preconditions.checkArgument((!ordered || distribution == StreamDistribution.SINGLE ? 1 : 0) != 0, (Object)"Ordered must be a single stream");
            this.otherActualProperties = otherActualProperties;
        }

        public List<LocalProperty<VariableReferenceExpression>> getLocalProperties() {
            Preconditions.checkState((this.otherActualProperties != null ? 1 : 0) != 0, (Object)"otherActualProperties not set");
            return this.otherActualProperties.getLocalProperties();
        }

        private static StreamProperties singleStream() {
            return new StreamProperties(StreamDistribution.SINGLE, Optional.of(ImmutableSet.of()), false);
        }

        private static StreamProperties fixedStreams() {
            return new StreamProperties(StreamDistribution.FIXED, Optional.empty(), false);
        }

        private static StreamProperties ordered() {
            return new StreamProperties(StreamDistribution.SINGLE, Optional.of(ImmutableSet.of()), true);
        }

        private StreamProperties unordered(boolean unordered) {
            if (unordered) {
                ActualProperties updatedProperies = null;
                if (this.otherActualProperties != null) {
                    updatedProperies = ActualProperties.builderFrom(this.otherActualProperties).unordered(true).build();
                }
                return new StreamProperties(this.distribution, this.partitioningColumns, false, updatedProperies);
            }
            return this;
        }

        public boolean isSingleStream() {
            return this.distribution == StreamDistribution.SINGLE;
        }

        public StreamDistribution getDistribution() {
            return this.distribution;
        }

        public boolean isExactlyPartitionedOn(Iterable<VariableReferenceExpression> columns) {
            return this.partitioningColumns.isPresent() && columns.equals(ImmutableList.copyOf((Collection)this.partitioningColumns.get()));
        }

        public boolean isPartitionedOn(Iterable<VariableReferenceExpression> columns) {
            if (!this.partitioningColumns.isPresent()) {
                return false;
            }
            return ImmutableSet.copyOf(columns).containsAll((Collection)this.partitioningColumns.get());
        }

        public boolean isOrdered() {
            return this.ordered;
        }

        private StreamProperties withUnspecifiedPartitioning() {
            if (this.isSingleStream()) {
                return this;
            }
            return new StreamProperties(this.distribution, Optional.empty(), this.ordered);
        }

        private StreamProperties withOtherActualProperties(ActualProperties actualProperties) {
            return new StreamProperties(this.distribution, this.partitioningColumns, this.ordered, actualProperties);
        }

        public StreamProperties translate(Function<VariableReferenceExpression, Optional<VariableReferenceExpression>> translator) {
            return new StreamProperties(this.distribution, this.partitioningColumns.flatMap(partitioning -> {
                ImmutableList.Builder newPartitioningColumns = ImmutableList.builder();
                for (VariableReferenceExpression partitioningColumn : partitioning) {
                    Optional translated = (Optional)translator.apply(partitioningColumn);
                    if (!translated.isPresent()) {
                        return Optional.empty();
                    }
                    newPartitioningColumns.add(translated.get());
                }
                return Optional.of(newPartitioningColumns.build());
            }), this.ordered, this.otherActualProperties.translateVariable(translator));
        }

        public Optional<List<VariableReferenceExpression>> getPartitioningColumns() {
            return this.partitioningColumns;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.distribution, this.partitioningColumns});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            StreamProperties other = (StreamProperties)obj;
            return Objects.equals((Object)this.distribution, (Object)other.distribution) && Objects.equals(this.partitioningColumns, other.partitioningColumns);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("distribution", (Object)this.distribution).add("partitioningColumns", this.partitioningColumns).toString();
        }

        public static enum StreamDistribution {
            SINGLE,
            MULTIPLE,
            FIXED;

        }
    }

    private static class Visitor
    extends InternalPlanVisitor<StreamProperties, List<StreamProperties>> {
        private final Metadata metadata;
        private final Session session;
        private final TypeProvider types;

        private Visitor(Metadata metadata, Session session, TypeProvider types) {
            this.metadata = metadata;
            this.session = session;
            this.types = types;
        }

        public StreamProperties visitPlan(PlanNode node, List<StreamProperties> inputProperties) {
            throw new UnsupportedOperationException("not yet implemented: " + node.getClass().getName());
        }

        @Override
        public StreamProperties visitJoin(JoinNode node, List<StreamProperties> inputProperties) {
            StreamProperties leftProperties = inputProperties.get(0);
            List<VariableReferenceExpression> outputs = node.getOutputVariables();
            boolean unordered = PropertyDerivations.spillPossible(this.session, node.getType());
            switch (node.getType()) {
                case INNER: {
                    return leftProperties.translate(column -> PropertyDerivations.filterOrRewrite(outputs, node.getCriteria(), column)).unordered(unordered);
                }
                case LEFT: {
                    return leftProperties.translate(column -> PropertyDerivations.filterIfMissing(outputs, column)).unordered(unordered);
                }
                case RIGHT: {
                    return new StreamProperties(StreamProperties.StreamDistribution.MULTIPLE, Optional.empty(), false);
                }
                case FULL: {
                    return new StreamProperties(StreamProperties.StreamDistribution.MULTIPLE, Optional.empty(), false);
                }
            }
            throw new UnsupportedOperationException("Unsupported join type: " + (Object)((Object)node.getType()));
        }

        @Override
        public StreamProperties visitSpatialJoin(SpatialJoinNode node, List<StreamProperties> inputProperties) {
            StreamProperties leftProperties = inputProperties.get(0);
            switch (node.getType()) {
                case INNER: 
                case LEFT: {
                    return leftProperties.translate(column -> PropertyDerivations.filterIfMissing(node.getOutputVariables(), column));
                }
            }
            throw new IllegalArgumentException("Unsupported spatial join type: " + (Object)((Object)node.getType()));
        }

        @Override
        public StreamProperties visitIndexJoin(IndexJoinNode node, List<StreamProperties> inputProperties) {
            StreamProperties probeProperties = inputProperties.get(0);
            switch (node.getType()) {
                case INNER: {
                    return probeProperties;
                }
                case SOURCE_OUTER: {
                    return probeProperties.withUnspecifiedPartitioning();
                }
            }
            throw new UnsupportedOperationException("Unsupported join type: " + (Object)((Object)node.getType()));
        }

        public StreamProperties visitValues(ValuesNode node, List<StreamProperties> context) {
            return StreamProperties.singleStream();
        }

        public StreamProperties visitTableScan(TableScanNode node, List<StreamProperties> inputProperties) {
            TableLayout layout = this.metadata.getLayout(this.session, node.getTable());
            ImmutableBiMap assignments = ImmutableBiMap.copyOf((Map)node.getAssignments()).inverse();
            HashSet constants = new HashSet();
            ((Map)PropertyDerivations.extractFixedValuesToConstantExpressions(node.getCurrentConstraint()).orElse((Map<ImmutableMap, ConstantExpression>)ImmutableMap.of())).entrySet().stream().filter(entry -> !((ConstantExpression)entry.getValue()).isNull()).forEach(entry -> constants.add(entry.getKey()));
            Optional streamPartitionSymbols = layout.getStreamPartitioningColumns().flatMap(arg_0 -> this.lambda$visitTableScan$5((Map)assignments, constants, arg_0));
            if (streamPartitionSymbols.isPresent() && ((Set)streamPartitionSymbols.get()).isEmpty()) {
                return new StreamProperties(StreamProperties.StreamDistribution.MULTIPLE, Optional.empty(), false);
            }
            return new StreamProperties(StreamProperties.StreamDistribution.MULTIPLE, streamPartitionSymbols, false);
        }

        private Optional<Set<VariableReferenceExpression>> getNonConstantVariables(Set<ColumnHandle> columnHandles, Map<ColumnHandle, VariableReferenceExpression> assignments, Set<ColumnHandle> globalConstants) {
            Set constantsStrippedPartitionColumns = (Set)columnHandles.stream().filter(column -> !globalConstants.contains(column)).collect(ImmutableSet.toImmutableSet());
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (ColumnHandle column2 : constantsStrippedPartitionColumns) {
                VariableReferenceExpression translated = assignments.get(column2);
                if (translated == null) {
                    return Optional.empty();
                }
                builder.add((Object)translated);
            }
            return Optional.of(builder.build());
        }

        @Override
        public StreamProperties visitExchange(ExchangeNode node, List<StreamProperties> inputProperties) {
            if (node.isEnsureSourceOrdering() || node.getOrderingScheme().isPresent()) {
                return StreamProperties.ordered();
            }
            if (node.getScope().isRemote()) {
                return StreamProperties.fixedStreams();
            }
            switch (node.getType()) {
                case GATHER: {
                    return StreamProperties.singleStream();
                }
                case REPARTITION: {
                    if (node.getPartitioningScheme().getPartitioning().getHandle().equals(SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION)) {
                        return new StreamProperties(StreamProperties.StreamDistribution.FIXED, Optional.empty(), false);
                    }
                    Preconditions.checkArgument((boolean)node.getPartitioningScheme().getPartitioning().getArguments().stream().allMatch(VariableReferenceExpression.class::isInstance), (Object)String.format("Expect all partitioning arguments to be VariableReferenceExpression, but get %s", node.getPartitioningScheme().getPartitioning().getArguments()));
                    return new StreamProperties(StreamProperties.StreamDistribution.FIXED, Optional.of(node.getPartitioningScheme().getPartitioning().getArguments().stream().map(VariableReferenceExpression.class::cast).collect(ImmutableList.toImmutableList())), false);
                }
                case REPLICATE: {
                    return new StreamProperties(StreamProperties.StreamDistribution.MULTIPLE, Optional.empty(), false);
                }
            }
            throw new UnsupportedOperationException("not yet implemented");
        }

        public StreamProperties visitProject(ProjectNode node, List<StreamProperties> inputProperties) {
            StreamProperties properties = (StreamProperties)Iterables.getOnlyElement(inputProperties);
            Map<VariableReferenceExpression, VariableReferenceExpression> identities = Visitor.computeIdentityTranslations(node.getAssignments().getMap(), this.types);
            return properties.translate(column -> Optional.ofNullable(identities.get(column)));
        }

        private static Map<VariableReferenceExpression, VariableReferenceExpression> computeIdentityTranslations(Map<VariableReferenceExpression, RowExpression> assignments, TypeProvider types) {
            HashMap<VariableReferenceExpression, VariableReferenceExpression> inputToOutput = new HashMap<VariableReferenceExpression, VariableReferenceExpression>();
            for (Map.Entry<VariableReferenceExpression, RowExpression> assignment : assignments.entrySet()) {
                RowExpression expression = assignment.getValue();
                if (OriginalExpressionUtils.isExpression(expression)) {
                    if (!(OriginalExpressionUtils.castToExpression(expression) instanceof SymbolReference)) continue;
                    inputToOutput.put(PlannerUtils.toVariableReference(OriginalExpressionUtils.castToExpression(expression), types), assignment.getKey());
                    continue;
                }
                if (!(expression instanceof VariableReferenceExpression)) continue;
                inputToOutput.put((VariableReferenceExpression)expression, assignment.getKey());
            }
            return inputToOutput;
        }

        @Override
        public StreamProperties visitGroupId(GroupIdNode node, List<StreamProperties> inputProperties) {
            HashMap<VariableReferenceExpression, VariableReferenceExpression> inputToOutputMappings = new HashMap<VariableReferenceExpression, VariableReferenceExpression>();
            for (Map.Entry<VariableReferenceExpression, VariableReferenceExpression> setMapping : node.getGroupingColumns().entrySet()) {
                if (!node.getCommonGroupingColumns().contains(setMapping.getKey())) continue;
                inputToOutputMappings.putIfAbsent(setMapping.getValue(), setMapping.getKey());
            }
            for (VariableReferenceExpression argument : node.getAggregationArguments()) {
                inputToOutputMappings.putIfAbsent(argument, argument);
            }
            return ((StreamProperties)Iterables.getOnlyElement(inputProperties)).translate(column -> Optional.ofNullable(inputToOutputMappings.get(column)));
        }

        public StreamProperties visitAggregation(AggregationNode node, List<StreamProperties> inputProperties) {
            StreamProperties properties = (StreamProperties)Iterables.getOnlyElement(inputProperties);
            return properties.translate(variable -> node.getGroupingKeys().contains(variable) ? Optional.of(variable) : Optional.empty());
        }

        @Override
        public StreamProperties visitStatisticsWriterNode(StatisticsWriterNode node, List<StreamProperties> inputProperties) {
            StreamProperties properties = (StreamProperties)Iterables.getOnlyElement(inputProperties);
            return properties.withUnspecifiedPartitioning();
        }

        @Override
        public StreamProperties visitTableFinish(TableFinishNode node, List<StreamProperties> inputProperties) {
            StreamProperties properties = (StreamProperties)Iterables.getOnlyElement(inputProperties);
            return properties.withUnspecifiedPartitioning();
        }

        @Override
        public StreamProperties visitDelete(DeleteNode node, List<StreamProperties> inputProperties) {
            StreamProperties properties = (StreamProperties)Iterables.getOnlyElement(inputProperties);
            return properties.withUnspecifiedPartitioning();
        }

        @Override
        public StreamProperties visitTableWriter(TableWriterNode node, List<StreamProperties> inputProperties) {
            StreamProperties properties = (StreamProperties)Iterables.getOnlyElement(inputProperties);
            return properties.withUnspecifiedPartitioning();
        }

        @Override
        public StreamProperties visitTableWriteMerge(TableWriterMergeNode node, List<StreamProperties> inputProperties) {
            return (StreamProperties)Iterables.getOnlyElement(inputProperties);
        }

        @Override
        public StreamProperties visitUnnest(UnnestNode node, List<StreamProperties> inputProperties) {
            StreamProperties properties = (StreamProperties)Iterables.getOnlyElement(inputProperties);
            ImmutableSet passThroughInputs = ImmutableSet.copyOf(node.getReplicateVariables());
            return properties.translate(arg_0 -> Visitor.lambda$visitUnnest$10((Set)passThroughInputs, arg_0));
        }

        @Override
        public StreamProperties visitExplainAnalyze(ExplainAnalyzeNode node, List<StreamProperties> inputProperties) {
            StreamProperties properties = (StreamProperties)Iterables.getOnlyElement(inputProperties);
            return properties.withUnspecifiedPartitioning();
        }

        @Override
        public StreamProperties visitIndexSource(IndexSourceNode node, List<StreamProperties> context) {
            return StreamProperties.singleStream();
        }

        public StreamProperties visitUnion(UnionNode node, List<StreamProperties> context) {
            return StreamProperties.singleStream();
        }

        @Override
        public StreamProperties visitEnforceSingleRow(EnforceSingleRowNode node, List<StreamProperties> context) {
            return StreamProperties.singleStream();
        }

        @Override
        public StreamProperties visitAssignUniqueId(AssignUniqueId node, List<StreamProperties> inputProperties) {
            StreamProperties properties = (StreamProperties)Iterables.getOnlyElement(inputProperties);
            if (properties.getPartitioningColumns().isPresent()) {
                return properties;
            }
            return new StreamProperties(properties.getDistribution(), Optional.of(ImmutableList.of((Object)node.getIdVariable())), properties.isOrdered());
        }

        @Override
        public StreamProperties visitOutput(OutputNode node, List<StreamProperties> inputProperties) {
            return ((StreamProperties)Iterables.getOnlyElement(inputProperties)).translate(column -> PropertyDerivations.filterIfMissing(node.getOutputVariables(), column));
        }

        public StreamProperties visitMarkDistinct(MarkDistinctNode node, List<StreamProperties> inputProperties) {
            return (StreamProperties)Iterables.getOnlyElement(inputProperties);
        }

        @Override
        public StreamProperties visitWindow(WindowNode node, List<StreamProperties> inputProperties) {
            return (StreamProperties)Iterables.getOnlyElement(inputProperties);
        }

        @Override
        public StreamProperties visitRowNumber(RowNumberNode node, List<StreamProperties> inputProperties) {
            return (StreamProperties)Iterables.getOnlyElement(inputProperties);
        }

        @Override
        public StreamProperties visitTopNRowNumber(TopNRowNumberNode node, List<StreamProperties> inputProperties) {
            return (StreamProperties)Iterables.getOnlyElement(inputProperties);
        }

        public StreamProperties visitTopN(TopNNode node, List<StreamProperties> inputProperties) {
            if (node.getStep().equals((Object)TopNNode.Step.PARTIAL)) {
                return (StreamProperties)Iterables.getOnlyElement(inputProperties);
            }
            return StreamProperties.ordered();
        }

        @Override
        public StreamProperties visitSort(SortNode node, List<StreamProperties> inputProperties) {
            StreamProperties sourceProperties = (StreamProperties)Iterables.getOnlyElement(inputProperties);
            if (sourceProperties.isSingleStream()) {
                return StreamProperties.ordered();
            }
            return sourceProperties;
        }

        public StreamProperties visitLimit(LimitNode node, List<StreamProperties> inputProperties) {
            return (StreamProperties)Iterables.getOnlyElement(inputProperties);
        }

        @Override
        public StreamProperties visitDistinctLimit(DistinctLimitNode node, List<StreamProperties> inputProperties) {
            return (StreamProperties)Iterables.getOnlyElement(inputProperties);
        }

        @Override
        public StreamProperties visitSemiJoin(SemiJoinNode node, List<StreamProperties> inputProperties) {
            return inputProperties.get(0);
        }

        @Override
        public StreamProperties visitApply(ApplyNode node, List<StreamProperties> inputProperties) {
            throw new IllegalStateException("Unexpected node: " + ((Object)((Object)node)).getClass());
        }

        @Override
        public StreamProperties visitLateralJoin(LateralJoinNode node, List<StreamProperties> inputProperties) {
            throw new IllegalStateException("Unexpected node: " + ((Object)((Object)node)).getClass());
        }

        public StreamProperties visitFilter(FilterNode node, List<StreamProperties> inputProperties) {
            return (StreamProperties)Iterables.getOnlyElement(inputProperties);
        }

        @Override
        public StreamProperties visitSample(SampleNode node, List<StreamProperties> inputProperties) {
            return (StreamProperties)Iterables.getOnlyElement(inputProperties);
        }

        private static /* synthetic */ Optional lambda$visitUnnest$10(Set passThroughInputs, VariableReferenceExpression column) {
            if (passThroughInputs.contains(column)) {
                return Optional.of(column);
            }
            return Optional.empty();
        }

        private /* synthetic */ Optional lambda$visitTableScan$5(Map assignments, Set constants, Set columns) {
            return this.getNonConstantVariables(columns, assignments, constants);
        }
    }
}

