/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.rewrite;

import com.facebook.presto.Session;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.function.QualifiedFunctionName;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.connector.informationSchema.InformationSchemaMetadata;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.metadata.BuiltInFunctionNamespaceManager;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataListing;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.metadata.ViewDefinition;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunction;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.PrincipalType;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.ParsingUtil;
import com.facebook.presto.sql.QueryUtil;
import com.facebook.presto.sql.SqlFormatter;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.rewrite.StatementRewrite;
import com.facebook.presto.sql.tree.AllColumns;
import com.facebook.presto.sql.tree.ArrayConstructor;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.ColumnDefinition;
import com.facebook.presto.sql.tree.CreateFunction;
import com.facebook.presto.sql.tree.CreateTable;
import com.facebook.presto.sql.tree.CreateView;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.Explain;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.OrderBy;
import com.facebook.presto.sql.tree.Property;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.RoutineBody;
import com.facebook.presto.sql.tree.RoutineCharacteristics;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SelectItem;
import com.facebook.presto.sql.tree.ShowCatalogs;
import com.facebook.presto.sql.tree.ShowColumns;
import com.facebook.presto.sql.tree.ShowCreate;
import com.facebook.presto.sql.tree.ShowCreateFunction;
import com.facebook.presto.sql.tree.ShowFunctions;
import com.facebook.presto.sql.tree.ShowGrants;
import com.facebook.presto.sql.tree.ShowRoleGrants;
import com.facebook.presto.sql.tree.ShowRoles;
import com.facebook.presto.sql.tree.ShowSchemas;
import com.facebook.presto.sql.tree.ShowSession;
import com.facebook.presto.sql.tree.ShowTables;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.SqlParameterDeclaration;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.Values;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.primitives.Primitives;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.stream.Collectors;

final class ShowQueriesRewrite
implements StatementRewrite.Rewrite {
    ShowQueriesRewrite() {
    }

    @Override
    public Statement rewrite(Session session, Metadata metadata, SqlParser parser, Optional<QueryExplainer> queryExplainer, Statement node, List<Expression> parameters, AccessControl accessControl, WarningCollector warningCollector) {
        return (Statement)new Visitor(metadata, parser, session, parameters, accessControl, queryExplainer, warningCollector).process((Node)node, null);
    }

    private static class Visitor
    extends AstVisitor<Node, Void> {
        private final Metadata metadata;
        private final Session session;
        private final SqlParser sqlParser;
        final List<Expression> parameters;
        private final AccessControl accessControl;
        private Optional<QueryExplainer> queryExplainer;
        private final WarningCollector warningCollector;

        public Visitor(Metadata metadata, SqlParser sqlParser, Session session, List<Expression> parameters, AccessControl accessControl, Optional<QueryExplainer> queryExplainer, WarningCollector warningCollector) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.parameters = Objects.requireNonNull(parameters, "parameters is null");
            this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
            this.queryExplainer = Objects.requireNonNull(queryExplainer, "queryExplainer is null");
            this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        }

        protected Node visitExplain(Explain node, Void context) {
            Statement statement = (Statement)this.process((Node)node.getStatement(), null);
            return new Explain((NodeLocation)node.getLocation().get(), node.isAnalyze(), node.isVerbose(), statement, node.getOptions());
        }

        protected Node visitShowTables(ShowTables showTables, Void context) {
            CatalogSchemaName schema = MetadataUtil.createCatalogSchemaName(this.session, (Node)showTables, showTables.getSchema());
            this.accessControl.checkCanShowTablesMetadata(this.session.getRequiredTransactionId(), this.session.getIdentity(), this.session.getAccessControlContext(), schema);
            if (!this.metadata.catalogExists(this.session, schema.getCatalogName())) {
                throw new SemanticException(SemanticErrorCode.MISSING_CATALOG, (Node)showTables, "Catalog '%s' does not exist", schema.getCatalogName());
            }
            if (!this.metadata.schemaExists(this.session, schema)) {
                throw new SemanticException(SemanticErrorCode.MISSING_SCHEMA, (Node)showTables, "Schema '%s' does not exist", schema.getSchemaName());
            }
            Expression predicate = QueryUtil.equal((Expression)QueryUtil.identifier((String)"table_schema"), (Expression)new StringLiteral(schema.getSchemaName()));
            Optional likePattern = showTables.getLikePattern();
            if (likePattern.isPresent()) {
                LikePredicate likePredicate = new LikePredicate((Expression)QueryUtil.identifier((String)"table_name"), (Expression)new StringLiteral((String)likePattern.get()), showTables.getEscape().map(StringLiteral::new));
                predicate = QueryUtil.logicalAnd((Expression)predicate, (Expression)likePredicate);
            }
            return QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{QueryUtil.aliasedName((String)"table_name", (String)"Table")}), (Relation)Visitor.from(schema.getCatalogName(), InformationSchemaMetadata.TABLE_TABLES), (Expression)predicate, (OrderBy)QueryUtil.ordering((SortItem[])new SortItem[]{QueryUtil.ascending((String)"table_name")}));
        }

        protected Node visitShowGrants(ShowGrants showGrants, Void context) {
            String catalogName = this.session.getCatalog().orElse(null);
            Optional<Object> predicate = Optional.empty();
            Optional tableName = showGrants.getTableName();
            if (tableName.isPresent()) {
                QualifiedObjectName qualifiedTableName = MetadataUtil.createQualifiedObjectName(this.session, (Node)showGrants, (QualifiedName)tableName.get());
                if (!this.metadata.getView(this.session, qualifiedTableName).isPresent() && !this.metadata.getTableHandle(this.session, qualifiedTableName).isPresent()) {
                    throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)showGrants, "Table '%s' does not exist", tableName);
                }
                catalogName = qualifiedTableName.getCatalogName();
                this.accessControl.checkCanShowTablesMetadata(this.session.getRequiredTransactionId(), this.session.getIdentity(), this.session.getAccessControlContext(), new CatalogSchemaName(catalogName, qualifiedTableName.getSchemaName()));
                predicate = Optional.of(ExpressionUtils.combineConjuncts(QueryUtil.equal((Expression)QueryUtil.identifier((String)"table_schema"), (Expression)new StringLiteral(qualifiedTableName.getSchemaName())), QueryUtil.equal((Expression)QueryUtil.identifier((String)"table_name"), (Expression)new StringLiteral(qualifiedTableName.getObjectName()))));
            } else {
                if (catalogName == null) {
                    throw new SemanticException(SemanticErrorCode.CATALOG_NOT_SPECIFIED, (Node)showGrants, "Catalog must be specified when session catalog is not set", new Object[0]);
                }
                SortedSet<String> allowedSchemas = MetadataListing.listSchemas(this.session, this.metadata, this.accessControl, catalogName);
                for (String schema : allowedSchemas) {
                    this.accessControl.checkCanShowTablesMetadata(this.session.getRequiredTransactionId(), this.session.getIdentity(), this.session.getAccessControlContext(), new CatalogSchemaName(catalogName, schema));
                }
            }
            return QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{QueryUtil.aliasedName((String)"grantor", (String)"Grantor"), QueryUtil.aliasedName((String)"grantor_type", (String)"Grantor Type"), QueryUtil.aliasedName((String)"grantee", (String)"Grantee"), QueryUtil.aliasedName((String)"grantee_type", (String)"Grantee Type"), QueryUtil.aliasedName((String)"table_catalog", (String)"Catalog"), QueryUtil.aliasedName((String)"table_schema", (String)"Schema"), QueryUtil.aliasedName((String)"table_name", (String)"Table"), QueryUtil.aliasedName((String)"privilege_type", (String)"Privilege"), QueryUtil.aliasedName((String)"is_grantable", (String)"Grantable"), QueryUtil.aliasedName((String)"with_hierarchy", (String)"With Hierarchy")}), (Relation)Visitor.from(catalogName, InformationSchemaMetadata.TABLE_TABLE_PRIVILEGES), predicate, Optional.empty());
        }

        protected Node visitShowRoles(ShowRoles node, Void context) {
            if (!node.getCatalog().isPresent() && !this.session.getCatalog().isPresent()) {
                throw new SemanticException(SemanticErrorCode.CATALOG_NOT_SPECIFIED, (Node)node, "Catalog must be specified when session catalog is not set", new Object[0]);
            }
            String catalog = node.getCatalog().map(c -> c.getValue().toLowerCase(Locale.ENGLISH)).orElseGet(() -> this.session.getCatalog().get());
            if (node.isCurrent()) {
                this.accessControl.checkCanShowCurrentRoles(this.session.getRequiredTransactionId(), this.session.getIdentity(), this.session.getAccessControlContext(), catalog);
                return QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{QueryUtil.aliasedName((String)"role_name", (String)"Role")}), (Relation)Visitor.from(catalog, InformationSchemaMetadata.TABLE_ENABLED_ROLES));
            }
            this.accessControl.checkCanShowRoles(this.session.getRequiredTransactionId(), this.session.getIdentity(), this.session.getAccessControlContext(), catalog);
            return QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{QueryUtil.aliasedName((String)"role_name", (String)"Role")}), (Relation)Visitor.from(catalog, InformationSchemaMetadata.TABLE_ROLES));
        }

        protected Node visitShowRoleGrants(ShowRoleGrants node, Void context) {
            if (!node.getCatalog().isPresent() && !this.session.getCatalog().isPresent()) {
                throw new SemanticException(SemanticErrorCode.CATALOG_NOT_SPECIFIED, (Node)node, "Catalog must be specified when session catalog is not set", new Object[0]);
            }
            String catalog = node.getCatalog().map(c -> c.getValue().toLowerCase(Locale.ENGLISH)).orElseGet(() -> this.session.getCatalog().get());
            PrestoPrincipal principal = new PrestoPrincipal(PrincipalType.USER, this.session.getUser());
            this.accessControl.checkCanShowRoleGrants(this.session.getRequiredTransactionId(), this.session.getIdentity(), this.session.getAccessControlContext(), catalog);
            List rows = this.metadata.listRoleGrants(this.session, catalog, principal).stream().map(roleGrant -> QueryUtil.row((Expression[])new Expression[]{new StringLiteral(roleGrant.getRoleName())})).collect(Collectors.toList());
            return QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.aliased((Relation)new Values(rows), (String)"role_grants", (List)ImmutableList.of((Object)"Role Grants")), (OrderBy)QueryUtil.ordering((SortItem[])new SortItem[]{QueryUtil.ascending((String)"Role Grants")}));
        }

        protected Node visitShowSchemas(ShowSchemas node, Void context) {
            if (!node.getCatalog().isPresent() && !this.session.getCatalog().isPresent()) {
                throw new SemanticException(SemanticErrorCode.CATALOG_NOT_SPECIFIED, (Node)node, "Catalog must be specified when session catalog is not set", new Object[0]);
            }
            String catalog = node.getCatalog().map(Identifier::getValue).orElseGet(() -> this.session.getCatalog().get());
            this.accessControl.checkCanShowSchemas(this.session.getRequiredTransactionId(), this.session.getIdentity(), this.session.getAccessControlContext(), catalog);
            Optional<Object> predicate = Optional.empty();
            Optional likePattern = node.getLikePattern();
            if (likePattern.isPresent()) {
                predicate = Optional.of(new LikePredicate((Expression)QueryUtil.identifier((String)"schema_name"), (Expression)new StringLiteral((String)likePattern.get()), node.getEscape().map(StringLiteral::new)));
            }
            return QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{QueryUtil.aliasedName((String)"schema_name", (String)"Schema")}), (Relation)Visitor.from(catalog, InformationSchemaMetadata.TABLE_SCHEMATA), predicate, Optional.of(QueryUtil.ordering((SortItem[])new SortItem[]{QueryUtil.ascending((String)"schema_name")})));
        }

        protected Node visitShowCatalogs(ShowCatalogs node, Void context) {
            List rows = MetadataListing.listCatalogs(this.session, this.metadata, this.accessControl).keySet().stream().map(name -> QueryUtil.row((Expression[])new Expression[]{new StringLiteral(name)})).collect(Collectors.toList());
            Optional<Object> predicate = Optional.empty();
            Optional likePattern = node.getLikePattern();
            if (likePattern.isPresent()) {
                predicate = Optional.of(new LikePredicate((Expression)QueryUtil.identifier((String)"Catalog"), (Expression)new StringLiteral((String)likePattern.get()), Optional.empty()));
            }
            return QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.aliased((Relation)new Values(rows), (String)"catalogs", (List)ImmutableList.of((Object)"Catalog")), predicate, Optional.of(QueryUtil.ordering((SortItem[])new SortItem[]{QueryUtil.ascending((String)"Catalog")})));
        }

        protected Node visitShowColumns(ShowColumns showColumns, Void context) {
            QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(this.session, (Node)showColumns, showColumns.getTable());
            if (!this.metadata.getView(this.session, tableName).isPresent() && !this.metadata.getTableHandle(this.session, tableName).isPresent()) {
                throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)showColumns, "Table '%s' does not exist", tableName);
            }
            return QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{QueryUtil.aliasedName((String)"column_name", (String)"Column"), QueryUtil.aliasedName((String)"data_type", (String)"Type"), QueryUtil.aliasedNullToEmpty((String)"extra_info", (String)"Extra"), QueryUtil.aliasedNullToEmpty((String)"comment", (String)"Comment")}), (Relation)Visitor.from(tableName.getCatalogName(), InformationSchemaMetadata.TABLE_COLUMNS), (Expression)QueryUtil.logicalAnd((Expression)QueryUtil.equal((Expression)QueryUtil.identifier((String)"table_schema"), (Expression)new StringLiteral(tableName.getSchemaName())), (Expression)QueryUtil.equal((Expression)QueryUtil.identifier((String)"table_name"), (Expression)new StringLiteral(tableName.getObjectName()))), (OrderBy)QueryUtil.ordering((SortItem[])new SortItem[]{QueryUtil.ascending((String)"ordinal_position")}));
        }

        private static <T> Expression getExpression(PropertyMetadata<T> property, Object value) throws PrestoException {
            return Visitor.toExpression(property.encode(property.getJavaType().cast(value)));
        }

        private static Expression toExpression(Object value) throws PrestoException {
            if (value instanceof String) {
                return new StringLiteral(value.toString());
            }
            if (value instanceof Boolean) {
                return new BooleanLiteral(value.toString());
            }
            if (value instanceof Long || value instanceof Integer) {
                return new LongLiteral(value.toString());
            }
            if (value instanceof Double) {
                return new DoubleLiteral(value.toString());
            }
            if (value instanceof List) {
                List list = (List)value;
                return new ArrayConstructor(list.stream().map(Visitor::toExpression).collect(Collectors.toList()));
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Failed to convert object of type %s to expression: %s", value.getClass().getName(), value));
        }

        protected Node visitShowCreate(ShowCreate node, Void context) {
            QualifiedObjectName objectName = MetadataUtil.createQualifiedObjectName(this.session, (Node)node, node.getName());
            Optional<ViewDefinition> viewDefinition = this.metadata.getView(this.session, objectName);
            if (node.getType() == ShowCreate.Type.VIEW) {
                if (!viewDefinition.isPresent()) {
                    if (this.metadata.getTableHandle(this.session, objectName).isPresent()) {
                        throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Relation '%s' is a table, not a view", objectName);
                    }
                    throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)node, "View '%s' does not exist", objectName);
                }
                Query query = this.parseView(viewDefinition.get().getOriginalSql(), objectName, (Node)node);
                String sql = SqlFormatter.formatSql((Node)new CreateView(MetadataUtil.createQualifiedName(objectName), query, false), Optional.of(this.parameters)).trim();
                return QueryUtil.singleValueQuery((String)"Create View", (String)sql);
            }
            if (node.getType() == ShowCreate.Type.TABLE) {
                if (viewDefinition.isPresent()) {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Relation '%s' is a view, not a table", objectName);
                }
                Optional<TableHandle> tableHandle = this.metadata.getTableHandle(this.session, objectName);
                if (!tableHandle.isPresent()) {
                    throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)node, "Table '%s' does not exist", objectName);
                }
                ConnectorTableMetadata connectorTableMetadata = this.metadata.getTableMetadata(this.session, tableHandle.get()).getMetadata();
                Map allColumnProperties = (Map)this.metadata.getColumnPropertyManager().getAllProperties().get(tableHandle.get().getConnectorId());
                List columns = (List)connectorTableMetadata.getColumns().stream().filter(column -> !column.isHidden()).map(column -> {
                    List<Property> propertyNodes = this.buildProperties(objectName, Optional.of(column.getName()), StandardErrorCode.INVALID_COLUMN_PROPERTY, column.getProperties(), allColumnProperties);
                    return new ColumnDefinition(new Identifier(column.getName()), column.getType().getDisplayName(), column.isNullable(), propertyNodes, Optional.ofNullable(column.getComment()));
                }).collect(ImmutableList.toImmutableList());
                Map properties = connectorTableMetadata.getProperties();
                Map allTableProperties = (Map)this.metadata.getTablePropertyManager().getAllProperties().get(tableHandle.get().getConnectorId());
                List<Property> propertyNodes = this.buildProperties(objectName, Optional.empty(), StandardErrorCode.INVALID_TABLE_PROPERTY, properties, allTableProperties);
                CreateTable createTable = new CreateTable(QualifiedName.of((String)objectName.getCatalogName(), (String[])new String[]{objectName.getSchemaName(), objectName.getObjectName()}), columns, false, propertyNodes, connectorTableMetadata.getComment());
                return QueryUtil.singleValueQuery((String)"Create Table", (String)SqlFormatter.formatSql((Node)createTable, Optional.of(this.parameters)).trim());
            }
            throw new UnsupportedOperationException("SHOW CREATE only supported for tables and views");
        }

        protected Node visitShowCreateFunction(ShowCreateFunction node, Void context) {
            QualifiedFunctionName functionName = FunctionManager.qualifyFunctionName(node.getName());
            Collection functions = this.metadata.getFunctionManager().getFunctions(this.session.getTransactionId(), functionName);
            if (node.getParameterTypes().isPresent()) {
                List parameterTypes2 = (List)((List)node.getParameterTypes().get()).stream().map(TypeSignature::parseTypeSignature).collect(ImmutableList.toImmutableList());
                functions = (Collection)functions.stream().filter(function -> function.getSignature().getArgumentTypes().equals(parameterTypes2)).collect(ImmutableList.toImmutableList());
            }
            if (functions.isEmpty()) {
                String types = node.getParameterTypes().map(parameterTypes -> String.format("(%s)", Joiner.on((String)", ").join((Iterable)parameterTypes))).orElse("");
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, String.format("Function not found: %s%s", functionName, types));
            }
            ImmutableList.Builder rows = ImmutableList.builder();
            for (SqlFunction function2 : functions) {
                if (!(function2 instanceof SqlInvokedFunction)) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, "SHOW CREATE FUNCTION is only supported for SQL functions");
                }
                SqlInvokedFunction sqlFunction = (SqlInvokedFunction)function2;
                CreateFunction createFunction = new CreateFunction(node.getName(), false, (List)sqlFunction.getParameters().stream().map(parameter -> new SqlParameterDeclaration(new Identifier(parameter.getName()), parameter.getType().toString())).collect(ImmutableList.toImmutableList()), sqlFunction.getSignature().getReturnType().toString(), Optional.of(sqlFunction.getDescription()), new RoutineCharacteristics(new RoutineCharacteristics.Language(sqlFunction.getRoutineCharacteristics().getLanguage().getLanguage()), RoutineCharacteristics.Determinism.valueOf((String)sqlFunction.getRoutineCharacteristics().getDeterminism().name()), RoutineCharacteristics.NullCallClause.valueOf((String)sqlFunction.getRoutineCharacteristics().getNullCallClause().name())), (RoutineBody)this.sqlParser.createReturn(sqlFunction.getBody(), ParsingUtil.createParsingOptions(this.session, this.warningCollector)));
                rows.add((Object)QueryUtil.row((Expression[])new Expression[]{new StringLiteral(SqlFormatter.formatSql((Node)createFunction, Optional.empty())), new StringLiteral(function2.getSignature().getArgumentTypes().stream().map(TypeSignature::toString).collect(Collectors.joining(", ")))}));
            }
            ImmutableMap columns = ImmutableMap.builder().put((Object)"create_function", (Object)"Create Function").put((Object)"argument_types", (Object)"Argument Types").build();
            return QueryUtil.simpleQuery((Select)QueryUtil.selectAll((List)((List)columns.entrySet().stream().map(entry -> QueryUtil.aliasedName((String)((String)entry.getKey()), (String)((String)entry.getValue()))).collect(ImmutableList.toImmutableList()))), (Relation)QueryUtil.aliased((Relation)new Values((List)rows.build()), (String)"functions", (List)ImmutableList.copyOf(columns.keySet())), (OrderBy)QueryUtil.ordering((SortItem[])new SortItem[]{QueryUtil.ascending((String)"argument_types")}));
        }

        private List<Property> buildProperties(Object objectName, Optional<String> columnName, StandardErrorCode errorCode, Map<String, Object> properties, Map<String, PropertyMetadata<?>> allProperties) {
            if (properties.isEmpty()) {
                return Collections.emptyList();
            }
            ImmutableSortedMap.Builder sqlProperties = ImmutableSortedMap.naturalOrder();
            for (Map.Entry<String, Object> propertyEntry : properties.entrySet()) {
                String propertyName = propertyEntry.getKey();
                Object value = propertyEntry.getValue();
                if (value == null) {
                    throw new PrestoException((ErrorCodeSupplier)errorCode, String.format("Property %s for %s cannot have a null value", propertyName, Visitor.toQualifedName(objectName, columnName)));
                }
                PropertyMetadata<?> property = allProperties.get(propertyName);
                if (!Primitives.wrap((Class)property.getJavaType()).isInstance(value)) {
                    throw new PrestoException((ErrorCodeSupplier)errorCode, String.format("Property %s for %s should have value of type %s, not %s", propertyName, Visitor.toQualifedName(objectName, columnName), property.getJavaType().getName(), value.getClass().getName()));
                }
                Expression sqlExpression = Visitor.getExpression(property, value);
                sqlProperties.put((Object)propertyName, (Object)sqlExpression);
            }
            return (List)sqlProperties.build().entrySet().stream().map(entry -> new Property(new Identifier((String)entry.getKey()), (Expression)entry.getValue())).collect(ImmutableList.toImmutableList());
        }

        private static String toQualifedName(Object objectName, Optional<String> columnName) {
            return columnName.map(s -> String.format("column %s of table %s", s, objectName)).orElseGet(() -> "table " + objectName);
        }

        protected Node visitShowFunctions(ShowFunctions node, Void context) {
            ImmutableList.Builder rows = ImmutableList.builder();
            for (SqlFunction function : this.metadata.listFunctions(this.session)) {
                Signature signature = function.getSignature();
                boolean builtIn = signature.getName().getFunctionNamespace().equals((Object)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE);
                rows.add((Object)QueryUtil.row((Expression[])new Expression[]{builtIn ? new StringLiteral(signature.getNameSuffix()) : new StringLiteral(signature.getName().toString()), new StringLiteral(signature.getReturnType().toString()), new StringLiteral(Joiner.on((String)", ").join((Iterable)signature.getArgumentTypes())), new StringLiteral(Visitor.getFunctionType(function)), function.isDeterministic() ? BooleanLiteral.TRUE_LITERAL : BooleanLiteral.FALSE_LITERAL, new StringLiteral(Strings.nullToEmpty((String)function.getDescription())), signature.isVariableArity() ? BooleanLiteral.TRUE_LITERAL : BooleanLiteral.FALSE_LITERAL, builtIn ? BooleanLiteral.TRUE_LITERAL : BooleanLiteral.FALSE_LITERAL, function instanceof SqlInvokedFunction ? new StringLiteral(((SqlInvokedFunction)function).getRoutineCharacteristics().getLanguage().getLanguage().toLowerCase(Locale.ENGLISH)) : new StringLiteral("")}));
            }
            ImmutableMap columns = ImmutableMap.builder().put((Object)"function_name", (Object)"Function").put((Object)"return_type", (Object)"Return Type").put((Object)"argument_types", (Object)"Argument Types").put((Object)"function_type", (Object)"Function Type").put((Object)"deterministic", (Object)"Deterministic").put((Object)"description", (Object)"Description").put((Object)"variable_arity", (Object)"Variable Arity").put((Object)"built_in", (Object)"Built In").put((Object)"language", (Object)"Language").build();
            return QueryUtil.simpleQuery((Select)QueryUtil.selectAll((List)((List)columns.entrySet().stream().map(entry -> QueryUtil.aliasedName((String)((String)entry.getKey()), (String)((String)entry.getValue()))).collect(ImmutableList.toImmutableList()))), (Relation)QueryUtil.aliased((Relation)new Values((List)rows.build()), (String)"functions", (List)ImmutableList.copyOf(columns.keySet())), node.getLikePattern().map(pattern -> new LikePredicate((Expression)QueryUtil.identifier((String)"function_name"), (Expression)new StringLiteral(pattern), node.getEscape().map(StringLiteral::new))), Optional.of(QueryUtil.ordering((SortItem[])new SortItem[]{QueryUtil.descending((String)"built_in"), new SortItem(QueryUtil.functionCall((String)"lower", (Expression[])new Expression[]{QueryUtil.identifier((String)"function_name")}), SortItem.Ordering.ASCENDING, SortItem.NullOrdering.UNDEFINED), QueryUtil.ascending((String)"return_type"), QueryUtil.ascending((String)"argument_types"), QueryUtil.ascending((String)"function_type")})));
        }

        private static String getFunctionType(SqlFunction function) {
            FunctionKind kind = function.getSignature().getKind();
            switch (kind) {
                case AGGREGATE: {
                    return "aggregate";
                }
                case WINDOW: {
                    return "window";
                }
                case SCALAR: {
                    return "scalar";
                }
            }
            throw new IllegalArgumentException("Unsupported function kind: " + kind);
        }

        protected Node visitShowSession(ShowSession node, Void context) {
            ImmutableList.Builder rows = ImmutableList.builder();
            SortedMap<String, ConnectorId> catalogNames = MetadataListing.listCatalogs(this.session, this.metadata, this.accessControl);
            List<SessionPropertyManager.SessionPropertyValue> sessionProperties = this.metadata.getSessionPropertyManager().getAllSessionProperties(this.session, catalogNames);
            for (SessionPropertyManager.SessionPropertyValue sessionProperty : sessionProperties) {
                if (sessionProperty.isHidden()) continue;
                String value = sessionProperty.getValue();
                String defaultValue = sessionProperty.getDefaultValue();
                rows.add((Object)QueryUtil.row((Expression[])new Expression[]{new StringLiteral(sessionProperty.getFullyQualifiedName()), new StringLiteral(Strings.nullToEmpty((String)value)), new StringLiteral(Strings.nullToEmpty((String)defaultValue)), new StringLiteral(sessionProperty.getType()), new StringLiteral(sessionProperty.getDescription()), BooleanLiteral.TRUE_LITERAL}));
            }
            rows.add((Object)QueryUtil.row((Expression[])new Expression[]{new StringLiteral(""), new StringLiteral(""), new StringLiteral(""), new StringLiteral(""), new StringLiteral(""), BooleanLiteral.FALSE_LITERAL}));
            return QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{QueryUtil.aliasedName((String)"name", (String)"Name"), QueryUtil.aliasedName((String)"value", (String)"Value"), QueryUtil.aliasedName((String)"default", (String)"Default"), QueryUtil.aliasedName((String)"type", (String)"Type"), QueryUtil.aliasedName((String)"description", (String)"Description")}), (Relation)QueryUtil.aliased((Relation)new Values((List)rows.build()), (String)"session", (List)ImmutableList.of((Object)"name", (Object)"value", (Object)"default", (Object)"type", (Object)"description", (Object)"include")), (Expression)QueryUtil.identifier((String)"include"));
        }

        private Query parseView(String view, QualifiedObjectName name, Node node) {
            try {
                Statement statement = this.sqlParser.createStatement(view, ParsingUtil.createParsingOptions(this.session, this.warningCollector));
                return (Query)statement;
            }
            catch (ParsingException e) {
                throw new SemanticException(SemanticErrorCode.VIEW_PARSE_ERROR, node, "Failed parsing stored view '%s': %s", name, e.getMessage());
            }
        }

        private static Relation from(String catalog, SchemaTableName table) {
            return QueryUtil.table((QualifiedName)QualifiedName.of((String)catalog, (String[])new String[]{table.getSchemaName(), table.getTableName()}));
        }

        private static Optional<OrderBy> orderBy(List<SortItem> sortItems) {
            Objects.requireNonNull(sortItems, "sortItems is null");
            if (sortItems.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new OrderBy(sortItems));
        }

        protected Node visitNode(Node node, Void context) {
            return node;
        }
    }
}

