/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.common.type.FunctionType;
import com.facebook.presto.common.type.ParameterKind;
import com.facebook.presto.common.type.ParametricType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeParameter;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.Collectors;

public final class FunctionParametricType
implements ParametricType {
    public static final FunctionParametricType FUNCTION = new FunctionParametricType();

    private FunctionParametricType() {
    }

    public String getName() {
        return "function";
    }

    public Type createType(TypeManager typeManager, List<TypeParameter> parameters) {
        Preconditions.checkArgument((parameters.size() >= 1 ? 1 : 0) != 0, (String)"Function type must have at least one parameter, got %s", parameters);
        Preconditions.checkArgument((boolean)parameters.stream().allMatch(parameter -> parameter.getKind() == ParameterKind.TYPE), (String)"Expected only types as a parameters, got %s", parameters);
        List types = parameters.stream().map(TypeParameter::getType).collect(Collectors.toList());
        return new FunctionType(types.subList(0, types.size() - 1), (Type)types.get(types.size() - 1));
    }
}

